/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.view.netcdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.ncSubset.view.netcdf.CFPointWriterUtils;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;
import ucar.nc2.constants.CF;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.ft.point.writer.CFPointWriter;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.Station;

class WriterCFTimeSeriesProfileCollection
extends CFPointWriter {
    private static Logger log = LoggerFactory.getLogger(WriterCFTimeSeriesProfileCollection.class);
    private static final String PROFILE_DIM_NAME = "profile";
    private static final String STATION_DIM_NAME = "station";
    private double lastTimeCoordValue = -1.0;
    private int recno = -1;
    private int[] origin = new int[1];
    private Variable stnName;
    private Variable stnDesc;
    private Variable lat;
    private Variable lon;
    private Variable ensVar;

    WriterCFTimeSeriesProfileCollection(NetcdfFileWriter.Version version, String fileOut, List<Attribute> atts) throws IOException {
        super(fileOut, atts, version);
        this.writer.addGroupAttribute(null, new Attribute("featureType", CF.FeatureType.timeSeriesProfile.name()));
    }

    void writeHeader(List<Station> stns, Map<String, List<String>> groupedVars, GridDataset gds, List<Attribute> timeDimAtts, int timeDimLength, Double vertCoord) throws IOException {
        Dimension profile = this.writer.addDimension(null, PROFILE_DIM_NAME, timeDimLength);
        Dimension station = this.writer.addDimension(null, STATION_DIM_NAME, stns.size());
        ArrayList<Dimension> stationDims = new ArrayList<Dimension>();
        stationDims.add(station);
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        dims.add(station);
        dims.add(profile);
        ArrayList<Dimension> timeDims = new ArrayList<Dimension>();
        timeDims.addAll(dims);
        ArrayList<String> keys = new ArrayList<String>(groupedVars.keySet());
        CoordinateAxis1D ensAxis = gds.findGridDatatype(groupedVars.get(keys.get(0)).get(0)).getCoordinateSystem().getEnsembleAxis();
        if (ensAxis != null) {
            Dimension d = this.writer.addDimension(null, ensAxis.getShortName(), ensAxis.getCoordValues().length);
            dims.add(d);
            ArrayList<Dimension> ensDim = new ArrayList<Dimension>();
            ensDim.add(d);
            this.ensVar = this.writer.addVariable(null, ensAxis.getShortName(), ensAxis.getDataType(), ensDim);
        }
        for (String key : keys) {
            List<String> vars = groupedVars.get(key);
            ArrayList<Dimension> tempDims = new ArrayList<Dimension>();
            tempDims.addAll(dims);
            String coordinates = "time longitude latitude";
            CoordinateAxis1D zAxis = gds.findGridDatatype(vars.get(0)).getCoordinateSystem().getVerticalAxis();
            if (zAxis != null) {
                int zAxisLength = zAxis.getCoordValues().length;
                if (vertCoord != null) {
                    zAxisLength = 1;
                }
                Dimension d = this.writer.addDimension(null, zAxis.getShortName(), zAxisLength);
                tempDims.add(d);
                Variable zVar = this.writer.addVariable(null, zAxis.getShortName(), zAxis.getDataType(), tempDims);
                this.writer.addVariableAttribute(zVar, new Attribute("standard_name", zAxis.getShortName()));
                this.writer.addVariableAttribute(zVar, new Attribute("long_name", zAxis.getFullName()));
                this.writer.addVariableAttribute(zVar, new Attribute("units", zAxis.getUnitsString()));
                this.writer.addVariableAttribute(zVar, new Attribute("positive", zAxis.getPositive()));
                this.writer.addVariableAttribute(zVar, new Attribute("axis", "Z"));
                coordinates = coordinates + " " + d.getShortName();
            }
            for (String var : vars) {
                GridDatatype grid = gds.findGridDatatype(var);
                Variable v = this.writer.addVariable(null, grid.getShortName(), grid.getDataType(), tempDims);
                this.writer.addVariableAttribute(v, new Attribute("standard_name", grid.getShortName()));
                this.writer.addVariableAttribute(v, new Attribute("long_name", grid.getFullName()));
                this.writer.addVariableAttribute(v, new Attribute("units", grid.getUnitsString()));
                this.writer.addVariableAttribute(v, new Attribute("coordinates", coordinates));
                VerticalCT vct = grid.getCoordinateSystem().getVerticalCT();
                if (vct == null || this.writer.findVariable(vct.getName()) != null) continue;
                Variable av = this.writer.addVariable(null, vct.getName(), DataType.DOUBLE, tempDims);
                this.writer.addVariableAttribute(av, new Attribute("standard_name", vct.getName()));
                this.writer.addVariableAttribute(av, new Attribute("long_name", vct.getName()));
                this.writer.addVariableAttribute(av, new Attribute("units", grid.getCoordinateSystem().getVerticalTransform().getUnitString()));
                this.writer.addVariableAttribute(av, new Attribute("coordinates", coordinates));
            }
        }
        int name_strlen = 1;
        int desc_strlen = 1;
        for (Station stn : stns) {
            name_strlen = Math.max(name_strlen, stn.getName().length());
            desc_strlen = Math.max(name_strlen, stn.getDescription().length());
        }
        this.stnName = this.writer.addStringVariable(null, "station_name", stationDims, name_strlen);
        this.writer.addVariableAttribute(this.stnName, new Attribute("long_name", "station name"));
        this.writer.addVariableAttribute(this.stnName, new Attribute("cf_role", "timeseries_id"));
        this.stnDesc = this.writer.addStringVariable(null, "station_description", stationDims, desc_strlen);
        this.writer.addVariableAttribute(this.stnDesc, new Attribute("long_name", "station description"));
        this.writer.addVariableAttribute(this.stnDesc, new Attribute("standard_name", "platform_name"));
        this.lat = this.writer.addVariable(null, "latitude", DataType.DOUBLE, STATION_DIM_NAME);
        this.writer.addVariableAttribute(this.lat, new Attribute("units", "degrees_north"));
        this.writer.addVariableAttribute(this.lat, new Attribute("long_name", "profile latitude"));
        this.lon = this.writer.addVariable(null, "longitude", DataType.DOUBLE, STATION_DIM_NAME);
        this.writer.addVariableAttribute(this.lon, new Attribute("units", "degrees_east"));
        this.writer.addVariableAttribute(this.lon, new Attribute("long_name", "profile longitude"));
        Variable time = this.writer.addVariable(null, "time", DataType.DOUBLE, timeDims);
        for (Attribute att : timeDimAtts) {
            this.writer.addVariableAttribute(time, att);
        }
        this.writer.create();
        this.writeStations(stns);
    }

    private void writeStations(List<Station> stations) {
        this.llbb = CFPointWriterUtils.getBoundingBox(stations);
        int nstns = stations.size();
        ArrayObject.D1 namesArray = new ArrayObject.D1(String.class, stations.size());
        ArrayObject.D1 descArray = new ArrayObject.D1(String.class, stations.size());
        ArrayDouble.D1 latArray = new ArrayDouble.D1(nstns);
        ArrayDouble.D1 lonArray = new ArrayDouble.D1(nstns);
        int i = 0;
        for (Station station : stations) {
            namesArray.set(i, (Object)station.getName());
            descArray.set(i, (Object)station.getDescription());
            latArray.set(i, station.getLatitude());
            lonArray.set(i, station.getLongitude());
            ++i;
        }
        try {
            this.writer.writeStringData(this.stnName, (Array)namesArray);
            this.writer.writeStringData(this.stnDesc, (Array)descArray);
            this.writer.write(this.lat, (Array)latArray);
            this.writer.write(this.lon, (Array)lonArray);
        }
        catch (IOException ioe) {
            log.error("Error writing station names:" + ioe);
        }
        catch (InvalidRangeException ire) {
            log.error("Invalid range exception error writing station names:" + (Object)((Object)ire));
        }
    }

    void writeRecord(double timeCoordValue, CalendarDate obsDate, EarthLocation loc, StructureData sdata) throws IOException {
        this.trackBB(null, obsDate);
        try {
            this.updateRecno(timeCoordValue);
            int[] origin = new int[]{0, this.recno};
            StructureMembers sm = sdata.getStructureMembers();
            for (StructureMembers.Member m : sm.getMembers()) {
                Variable v = this.writer.findVariable(m.getName());
                if (v == null || v.getShortName().equals("time") || this.writer.findVariable(m.getName()) == null) continue;
                Array arr = CFPointWriterUtils.getArrayFromMember(this.writer.findVariable(m.getName()), m);
                this.writer.write(this.writer.findVariable(m.getName()), origin, arr);
            }
        }
        catch (InvalidRangeException ire) {
            log.error("Error writing data: " + (Object)((Object)ire));
        }
    }

    void writeRecord(String profileName, double timeCoordValue, CalendarDate obsDate, EarthLocation loc, StructureData sdata, int vIndex) throws IOException {
        this.trackBB(null, obsDate);
        try {
            this.updateRecno(timeCoordValue);
            this.origin[0] = this.recno;
            int[] tmp3D = new int[]{0, this.recno, vIndex};
            StructureMembers sm = sdata.getStructureMembers();
            for (StructureMembers.Member m : sm.getMembers()) {
                Variable v = this.writer.findVariable(m.getName());
                if (v == null || v.getShortName().equals("longitude") || v.getShortName().equals("latitude") || v.getShortName().equals("time")) continue;
                Array arr = CFPointWriterUtils.getArrayFromMember(this.writer.findVariable(m.getName()), m);
                this.writer.write(this.writer.findVariable(m.getName()), tmp3D, arr);
            }
        }
        catch (InvalidRangeException ire) {
            log.error("Error writing data: " + (Object)((Object)ire));
        }
    }

    void writeRecord(String profileName, double timeCoordValue, double ensCoordValue, CalendarDate obsDate, EarthLocation loc, StructureData sdata, int vIndex) throws IOException {
        this.trackBB(null, obsDate);
        try {
            this.updateRecno(timeCoordValue);
            this.origin[0] = this.recno;
            int[] tmp4D = new int[]{0, this.recno, (int)ensCoordValue, vIndex};
            StructureMembers sm = sdata.getStructureMembers();
            for (StructureMembers.Member m : sm.getMembers()) {
                Variable v = this.writer.findVariable(m.getName());
                if (v == null || v.getShortName().equals("longitude") || v.getShortName().equals("latitude") || v.getShortName().equals("time")) continue;
                Array arr = CFPointWriterUtils.getArrayFromMember(this.writer.findVariable(m.getName()), m);
                this.writer.write(this.writer.findVariable(m.getName()), tmp4D, arr);
            }
        }
        catch (InvalidRangeException ire) {
            log.error("Error writing data: " + (Object)((Object)ire));
        }
    }

    void writeRecord(double timeCoordValue, double ensCoordValue, CalendarDate obsDate, EarthLocation loc, StructureData sdata) throws IOException {
        this.trackBB(null, obsDate);
        try {
            this.updateRecno(timeCoordValue);
            this.origin[0] = this.recno;
            int[] tmp3D = new int[]{0, this.recno, (int)ensCoordValue};
            StructureMembers sm = sdata.getStructureMembers();
            for (StructureMembers.Member m : sm.getMembers()) {
                Variable v = this.writer.findVariable(m.getName());
                if (v == null || v.getShortName().equals("longitude") || v.getShortName().equals("latitude") || v.getShortName().equals("time")) continue;
                Array arr = CFPointWriterUtils.getArrayFromMember(this.writer.findVariable(m.getName()), m);
                this.writer.write(this.writer.findVariable(m.getName()), tmp3D, arr);
            }
        }
        catch (InvalidRangeException ire) {
            log.error("Error writing data: " + (Object)((Object)ire));
        }
    }

    void writeEnsCoord(int ensIdx, double ensCoord) throws IOException {
        ArrayDouble.D1 tmpArray = new ArrayDouble.D1(1);
        tmpArray.setDouble(0, ensCoord);
        int[] idx = new int[]{ensIdx};
        try {
            this.writer.write(this.ensVar, idx, (Array)tmpArray);
        }
        catch (InvalidRangeException ire) {
            log.error("Error writing data: " + (Object)((Object)ire));
        }
    }

    private void updateRecno(double timeCoordValue) throws IOException, InvalidRangeException {
        if (timeCoordValue != this.lastTimeCoordValue) {
            int[] tmp = new int[]{0, ++this.recno};
            Double data = timeCoordValue;
            this.lastTimeCoordValue = timeCoordValue;
            ArrayDouble.D2 tmpArray = new ArrayDouble.D2(1, 1);
            tmpArray.setDouble(0, data.doubleValue());
            this.writer.write(this.writer.findVariable("time"), tmp, (Array)tmpArray);
        }
    }

    void close() throws IOException {
        this.writer.close();
    }
}

