/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.io.DataOutputStream;
import java.io.IOException;
import opendap.servers.SDByte;
import thredds.server.opendap.HasNetcdfVariable;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Variable;

public class NcSDByte
extends SDByte
implements HasNetcdfVariable {
    private Variable ncVar;

    NcSDByte(Variable ncVar) {
        super(Variable.getDAPName((Variable)ncVar));
        this.ncVar = ncVar;
    }

    @Override
    public Variable getVariable() {
        return this.ncVar;
    }

    public boolean read(String datasetName, Object specialO) throws IOException {
        this.setData(this.ncVar.read());
        return false;
    }

    @Override
    public void setData(Array data) {
        this.setValue(data.getByte(data.getIndex()));
        this.setRead(true);
    }

    @Override
    public void serialize(DataOutputStream sink, StructureData sdata, StructureMembers.Member m) throws IOException {
        this.setValue(sdata.getScalarByte(m));
        this.externalize(sink);
    }
}

