/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.radarServer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadarDayCollection
implements Serializable {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    public static final Pattern p_yyyymmdd_hhmm = Pattern.compile("\\d{8}_(\\d{4})");
    private static final long serialVersionUID = 20100109L;
    String dir;
    boolean stnTime = true;
    boolean stnProduct = false;
    String yyyymmdd;
    String product = null;
    boolean standardName = true;
    String suffix = null;
    HashMap<String, ArrayList<String>> time = new HashMap();

    public RadarDayCollection() {
    }

    public RadarDayCollection(String dir, boolean type, String yyyymmdd, String product) {
        this.stnTime = type;
        this.yyyymmdd = yyyymmdd;
        this.product = product;
        this.dir = this.stnTime ? (product == null ? dir : dir + "/" + product) : (product == null ? dir : dir + "/" + product + "/");
    }

    public boolean populate(String dir, boolean type, String yyyymmdd, String product) throws IOException {
        this.dir = product == null ? dir : dir + "/" + product;
        this.stnTime = type;
        this.yyyymmdd = yyyymmdd;
        this.product = product;
        ArrayList<String> stations = null;
        if (this.stnTime) {
            stations = this.getStationsFromDir(this.dir);
        }
        for (String stn : stations) {
            this.populateStationsTimesFromDir(stn, this.dir + "/" + stn + "/" + yyyymmdd);
        }
        return true;
    }

    private ArrayList<String> getStationsFromDir(String stnDir) throws IOException {
        ArrayList<String> stations = new ArrayList<String>();
        File dir = new File(stnDir);
        if (dir.exists() && dir.isDirectory()) {
            String[] children;
            this.log.debug("In directory " + dir.getParent() + "/" + dir.getName());
            for (String aChild : children = dir.list()) {
                File child = new File(dir, aChild);
                if (!child.isDirectory()) continue;
                stations.add(aChild);
            }
        } else {
            return null;
        }
        return stations;
    }

    private boolean populateStationsTimesFromDir(String stn, String stnDir) throws IOException {
        ArrayList<String> hhmm;
        File dir = new File(stnDir);
        if (dir.exists() && dir.isDirectory()) {
            this.log.debug("In directory " + dir.getParent() + "/" + dir.getName());
            hhmm = new ArrayList<String>();
            String[] children = dir.list();
            if (children.length > 0) {
                for (String aChildren : children) {
                    int start;
                    if (aChildren.startsWith(".")) continue;
                    if (!aChildren.startsWith("Level")) {
                        this.standardName = false;
                    }
                    if ((start = aChildren.lastIndexOf(46)) <= 0) continue;
                    this.suffix = aChildren.substring(start);
                }
            }
            for (String aChildren : children) {
                Matcher m;
                if (aChildren.startsWith(".") || !(m = p_yyyymmdd_hhmm.matcher(aChildren)).find()) continue;
                if (this.standardName) {
                    hhmm.add(m.group(1));
                    continue;
                }
                hhmm.add(aChildren);
            }
        } else {
            return false;
        }
        Collections.sort(hhmm, new CompareKeyDescend());
        this.time.put(stn, hhmm);
        return true;
    }

    public final Set<String> getStations() {
        return this.time.keySet();
    }

    public final ArrayList<String> getTimes(String station) {
        return this.time.get(station);
    }

    public String write() {
        String filename = this.dir + "/." + this.yyyymmdd;
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        try {
            fos = new FileOutputStream(filename);
            out = new ObjectOutputStream(fos);
            out.writeObject(this);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RadarDayCollection read(String sfile) {
        ObjectInputStream in = null;
        try {
            File file = new File(sfile);
            if (!file.exists()) {
                RadarDayCollection radarDayCollection = null;
                return radarDayCollection;
            }
            FileInputStream fis = new FileInputStream(file);
            in = new ObjectInputStream(fis);
            RadarDayCollection rdc = (RadarDayCollection)in.readObject();
            in.close();
            RadarDayCollection radarDayCollection = rdc;
            return radarDayCollection;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.log.debug("radarServer reading DayCollection " + sfile);
                }
            }
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        String tdir = null;
        boolean type = true;
        String day = null;
        String product = null;
        if (args.length != 4) {
            System.out.println("Not the correct parameters: tdir, structType, day, product");
            return;
        }
        tdir = args[0];
        type = args[1].equals("true");
        day = args[2];
        product = args[3].equals("null") ? null : args[3];
        RadarDayCollection rdc = new RadarDayCollection();
        rdc.populate(tdir, type, day, product);
        String sfile = rdc.write();
        if (sfile == null) {
            System.out.println("RadarDayCollection write Unsuccessful");
        } else {
            System.out.println("RadarDayCollection write successful");
        }
    }

    protected class CompareKeyDescend
    implements Comparator<String> {
        protected CompareKeyDescend() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s2.compareTo(s1);
        }
    }
}

