/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.root;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.inventory.CollectionManager;
import thredds.inventory.CollectionUpdater;
import thredds.inventory.MFile;
import thredds.server.config.TdsContext;
import thredds.servlet.DataRootHandler;
import thredds.servlet.DebugHandler;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.unidata.util.StringUtil2;

public class CollectionController
extends AbstractController {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String PATH = "/admin/collection";
    private static final String COLLECTION = "collection";
    private static final String TRIGGER = "trigger";
    private static final String NOCHECK = "nocheck";
    private final TdsContext tdsContext;

    CollectionController(TdsContext _tdsContext) {
        this.tdsContext = _tdsContext;
        DebugHandler debugHandler = DebugHandler.get("Collections");
        DebugHandler.Action act = new DebugHandler.Action("showCollection", "Show Collections"){

            @Override
            public void doAction(DebugHandler.Event e) {
                List<InvDatasetFeatureCollection> fcList = DataRootHandler.getInstance().getFeatureCollections();
                Collections.sort(fcList, new Comparator<InvDatasetFeatureCollection>(){

                    @Override
                    public int compare(InvDatasetFeatureCollection o1, InvDatasetFeatureCollection o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                for (InvDatasetFeatureCollection fc : fcList) {
                    String ename = StringUtil2.escape((String)fc.getName(), (String)"");
                    String url = CollectionController.this.tdsContext.getContextPath() + CollectionController.PATH + "?" + CollectionController.COLLECTION + "=" + ename;
                    e.pw.printf("<p/><a href='%s'>%s</a>%n", url, fc.getName());
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("sched", "Show scheduler"){

            @Override
            public void doAction(DebugHandler.Event e) {
                Scheduler scheduler = CollectionUpdater.INSTANCE.getScheduler();
                if (scheduler == null) {
                    return;
                }
                try {
                    e.pw.println(scheduler.getMetaData());
                    List groups = scheduler.getJobGroupNames();
                    List triggers = scheduler.getTriggerGroupNames();
                    for (String group : scheduler.getJobGroupNames()) {
                        e.pw.println("Group " + group);
                        for (JobKey jobKey : scheduler.getJobKeys(GroupMatcher.groupEquals((String)group))) {
                            e.pw.println("  Job " + jobKey.getName());
                            e.pw.println("    " + scheduler.getJobDetail(jobKey));
                        }
                        for (TriggerKey triggerKey : scheduler.getTriggerKeys(GroupMatcher.groupEquals((String)group))) {
                            e.pw.println("  Trigger " + triggerKey.getName());
                            e.pw.println("    " + scheduler.getTrigger(triggerKey));
                        }
                    }
                }
                catch (Exception e1) {
                    e.pw.println("Error on scheduler " + e1.getMessage());
                    CollectionController.this.log.error("Error on scheduler " + e1.getMessage());
                }
            }
        };
        debugHandler.addAction(act);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest req, HttpServletResponse res) throws Exception {
        InvDatasetFeatureCollection fc;
        String path = req.getPathInfo();
        if (path == null) {
            path = "";
        }
        PrintWriter pw = res.getWriter();
        res.setContentType("text/html");
        String collectName = req.getParameter(COLLECTION);
        boolean trigger = false;
        boolean nocheck = false;
        if (path.equals("/collection/trigger")) {
            trigger = true;
            boolean bl = nocheck = req.getParameter(NOCHECK) != null;
        }
        if ((fc = DataRootHandler.getInstance().getFeatureCollection(collectName)) == null) {
            res.setStatus(404);
            pw.append("NOT FOUND");
            pw.flush();
            return null;
        }
        CollectionManager dcm = fc.getDatasetCollectionManager();
        pw.printf("<h3>Collection Name %s</h3>%n", dcm.getCollectionName());
        if (trigger) {
            if (!fc.getConfig().isTrigggerOk()) {
                res.setStatus(403);
                pw.printf(" TRIGGER NOT ENABLED%n", new Object[0]);
                pw.flush();
                return null;
            }
            CollectionUpdater.INSTANCE.triggerUpdate(dcm.getCollectionName(), nocheck ? NOCHECK : TRIGGER);
            pw.printf(" TRIGGER SENT%n", new Object[0]);
        } else {
            this.showFiles(pw, dcm);
            String ename = StringUtil2.escape((String)fc.getName(), (String)"");
            String url = this.tdsContext.getContextPath() + PATH + "/trigger?" + COLLECTION + "=" + ename;
            pw.printf("<p/><a href='%s'>Trigger rescan for %s</a>%n", url, fc.getName());
        }
        pw.flush();
        return null;
    }

    private void showFiles(PrintWriter pw, CollectionManager dcm) {
        boolean unscanned;
        boolean bl = unscanned = dcm.getLastScanned() == 0L;
        if (unscanned) {
            pw.printf("%n<pre>Not Yet Scanned%n", new Object[0]);
            return;
        }
        pw.printf("%n<pre>Last Scanned %-20s%n", CalendarDateFormatter.toDateTimeString((Date)new Date(dcm.getLastScanned())));
        pw.printf("%n%-100s %-20s %9.3s %s%n", "Path", "Last Modified", "MB", "Aux");
        for (MFile mfile : dcm.getFiles()) {
            pw.printf("%-100s %-20s %9.3f %s%n", mfile.getPath(), CalendarDateFormatter.toDateTimeString((Date)new Date(mfile.getLastModified())), (double)mfile.getLength() / 1000000.0, mfile.getAuxInfo());
        }
        pw.printf("</pre>%n", new Object[0]);
    }
}

