/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.util.StringValidateEncodeUtils;
import ucar.nc2.util.EscapeStrings;

public class RequestQueryFilter
implements Filter {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean allowAngleBrackets = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        String s = filterConfig.getInitParameter("allowAngleBrackets");
        if (s != null && s.equalsIgnoreCase("true")) {
            this.allowAngleBrackets = true;
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            this.log.error("doFilter(): Not an HTTP request! How did this filter get here?");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String query = request.getQueryString();
        if (query != null) {
            String decodedQuery = EscapeStrings.unescapeURLQuery((String)query);
            boolean badQuery = false;
            if (!this.allowAngleBrackets && StringValidateEncodeUtils.containsAngleBracketCharacters(decodedQuery)) {
                badQuery = true;
            } else if (StringValidateEncodeUtils.containsBackslashCharacters(decodedQuery) || !StringValidateEncodeUtils.validSingleLineString(decodedQuery)) {
                badQuery = true;
            }
            if (badQuery) {
                String msg = "Invalid query string [" + query + "].";
                this.log.debug("doFilter(): " + msg);
                response.sendError(404, msg);
                return;
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

