/*
 * Decompiled with CFR 0.152.
 */
package thredds.dqc.server.latest;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LatestConfig {
    private static Logger log = LoggerFactory.getLogger(LatestConfig.class);
    private Map items = new HashMap();

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public boolean addItem(String id, Item item) {
        if (id == null) {
            throw new IllegalArgumentException("Null item ID not allowed.");
        }
        if (id.equals("")) {
            throw new IllegalArgumentException("Empty string for item ID not allowed.");
        }
        if (item == null) {
            throw new IllegalArgumentException("Null item not allowed.");
        }
        if (this.items.keySet().contains(id)) {
            log.info("addItem(): Config already contains Item with this id <" + id + ">.");
            return false;
        }
        return null == this.items.put(id, item);
    }

    public boolean removeItem(String id) {
        return null != this.items.remove(id);
    }

    public Set getIds() {
        return this.items.keySet();
    }

    public Item getItem(String id) {
        return (Item)this.items.get(id);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("LatestConfig[");
        for (String curId : this.items.keySet()) {
            buf.append("\n    ").append(this.getItem(curId).toString());
        }
        buf.append("\n]");
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LatestConfig config = (LatestConfig)o;
        return !(this.items != null ? !this.items.equals(config.items) : config.items != null);
    }

    public int hashCode() {
        return this.items != null ? this.items.hashCode() : 0;
    }

    public static class Item {
        private String id;
        private String name;
        private String dirLocation;
        private String datasetNameMatchPattern;
        private String datasetTimeSubstitutionPattern;
        private String serviceBaseURL;
        private String invCatSpecVersion;
        private String dqcSpecVersion;
        private String refId;

        protected Item(String id, String refId) {
            if (id == null || refId == null) {
                throw new IllegalArgumentException("Neither Id nor RefID may be null.");
            }
            this.id = id;
            this.refId = refId;
        }

        protected Item(String id, String name, String dirLocation, String datasetNameMatchPattern, String datasetTimeSubstitutionPattern, String serviceBaseURL, String invCatSpecVersion, String dqcSpecVersion) {
            if (id == null || name == null || dirLocation == null || datasetNameMatchPattern == null || datasetTimeSubstitutionPattern == null || serviceBaseURL == null || invCatSpecVersion == null || dqcSpecVersion == null) {
                throw new IllegalArgumentException("Null parameter not allowed.");
            }
            this.id = id;
            this.name = name;
            this.dirLocation = dirLocation;
            this.datasetNameMatchPattern = datasetNameMatchPattern;
            this.datasetTimeSubstitutionPattern = datasetTimeSubstitutionPattern;
            this.serviceBaseURL = serviceBaseURL;
            this.invCatSpecVersion = invCatSpecVersion;
            this.dqcSpecVersion = dqcSpecVersion;
        }

        protected void setReferencedItem(Item referencedItem) {
            this.name = referencedItem.getName();
            this.dirLocation = referencedItem.getDirLocation();
            this.datasetNameMatchPattern = referencedItem.getDatasetNameMatchPattern();
            this.datasetTimeSubstitutionPattern = referencedItem.getDatasetTimeSubstitutionPattern();
            this.serviceBaseURL = referencedItem.getServiceBaseURL();
            this.invCatSpecVersion = referencedItem.getInvCatSpecVersion();
            this.dqcSpecVersion = referencedItem.getDqcSpecVersion();
        }

        public String getId() {
            return this.id;
        }

        public String getRefId() {
            return this.refId;
        }

        public String getName() {
            return this.name;
        }

        public String getDirLocation() {
            return this.dirLocation;
        }

        public String getDatasetNameMatchPattern() {
            return this.datasetNameMatchPattern;
        }

        public String getDatasetTimeSubstitutionPattern() {
            return this.datasetTimeSubstitutionPattern;
        }

        public String getServiceBaseURL() {
            return this.serviceBaseURL;
        }

        public String getInvCatSpecVersion() {
            return this.invCatSpecVersion;
        }

        public String getDqcSpecVersion() {
            return this.dqcSpecVersion;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("LatestConfig.Item[");
            buf.append(this.id).append(", ");
            if (this.refId != null) {
                buf.append(this.refId).append("]");
            } else {
                buf.append(this.name).append(", ").append(this.dirLocation).append(", ").append(this.datasetNameMatchPattern).append(", ").append(this.datasetTimeSubstitutionPattern).append(", ").append(this.serviceBaseURL).append(", ").append(this.invCatSpecVersion).append(", ").append(this.dqcSpecVersion).append("]");
            }
            return buf.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            if (this.datasetNameMatchPattern != null ? !this.datasetNameMatchPattern.equals(item.datasetNameMatchPattern) : item.datasetNameMatchPattern != null) {
                return false;
            }
            if (this.datasetTimeSubstitutionPattern != null ? !this.datasetTimeSubstitutionPattern.equals(item.datasetTimeSubstitutionPattern) : item.datasetTimeSubstitutionPattern != null) {
                return false;
            }
            if (this.dirLocation != null ? !this.dirLocation.equals(item.dirLocation) : item.dirLocation != null) {
                return false;
            }
            if (this.dqcSpecVersion != null ? !this.dqcSpecVersion.equals(item.dqcSpecVersion) : item.dqcSpecVersion != null) {
                return false;
            }
            if (this.id != null ? !this.id.equals(item.id) : item.id != null) {
                return false;
            }
            if (this.invCatSpecVersion != null ? !this.invCatSpecVersion.equals(item.invCatSpecVersion) : item.invCatSpecVersion != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(item.name) : item.name != null) {
                return false;
            }
            if (this.refId != null ? !this.refId.equals(item.refId) : item.refId != null) {
                return false;
            }
            return !(this.serviceBaseURL != null ? !this.serviceBaseURL.equals(item.serviceBaseURL) : item.serviceBaseURL != null);
        }

        public int hashCode() {
            int result = this.id != null ? this.id.hashCode() : 0;
            result = 29 * result + (this.refId != null ? this.refId.hashCode() : 0);
            result = 29 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 29 * result + (this.dirLocation != null ? this.dirLocation.hashCode() : 0);
            result = 29 * result + (this.datasetNameMatchPattern != null ? this.datasetNameMatchPattern.hashCode() : 0);
            result = 29 * result + (this.datasetTimeSubstitutionPattern != null ? this.datasetTimeSubstitutionPattern.hashCode() : 0);
            result = 29 * result + (this.serviceBaseURL != null ? this.serviceBaseURL.hashCode() : 0);
            result = 29 * result + (this.invCatSpecVersion != null ? this.invCatSpecVersion.hashCode() : 0);
            result = 29 * result + (this.dqcSpecVersion != null ? this.dqcSpecVersion.hashCode() : 0);
            return result;
        }
    }
}

