/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Random;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.transform.XSLTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.mvc.LastModified;
import thredds.server.config.TdsContext;
import thredds.server.ncSubset.GridPointWriter;
import thredds.server.ncSubset.QueryParams;
import thredds.servlet.DataRootHandler;
import thredds.servlet.DatasetHandler;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsConfig;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.constants.CDM;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDatasetInfo;
import ucar.nc2.dt.grid.NetcdfCFWriter;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.Misc;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;

public class NcssController
extends AbstractController
implements LastModified {
    private static final Logger log = LoggerFactory.getLogger(NcssController.class);
    private static final String servletPath = "/ncss/grid";
    private TdsContext tdsContext;
    private String servletCachePath = "/cache/ncss";
    private DiskCache2 diskCache = null;
    private boolean allow = false;
    private boolean debug = false;
    private long maxFileDownloadSize = -1L;

    public void setTdsContext(TdsContext tdsContext) {
        this.tdsContext = tdsContext;
    }

    public long getLastModified(HttpServletRequest req) {
        File file = DataRootHandler.getInstance().getCrawlableDatasetAsFile(req.getPathInfo());
        if (file != null && file.exists()) {
            return file.lastModified();
        }
        return -1L;
    }

    public void init() {
        this.allow = ThreddsConfig.getBoolean("NetcdfSubsetService.allow", false);
        if (!this.allow) {
            return;
        }
        this.maxFileDownloadSize = ThreddsConfig.getBytes("NetcdfSubsetService.maxFileDownloadSize", -1L);
        String cache = ThreddsConfig.get("NetcdfSubsetService.dir", ServletUtil.getContentPath() + this.servletCachePath);
        File cacheDir = new File(cache);
        if (!cacheDir.exists() && !cacheDir.mkdirs()) {
            ServletUtil.logServerStartup.error("Cant make cache directory " + cache);
            throw new IllegalArgumentException("Cant make cache directory " + cache);
        }
        int scourSecs = ThreddsConfig.getSeconds("NetcdfSubsetService.scour", 600);
        int maxAgeSecs = ThreddsConfig.getSeconds("NetcdfSubsetService.maxAge", -1);
        maxAgeSecs = Math.max(maxAgeSecs, 300);
        scourSecs = Math.max(scourSecs, 300);
        this.diskCache = new DiskCache2(cache, false, maxAgeSecs / 60, scourSecs / 60);
        ServletUtil.logServerStartup.info(((Object)((Object)this)).getClass().getName() + "Ncss.Cache= " + cache + " scour = " + scourSecs + " maxAgeSecs = " + maxAgeSecs);
        ServletUtil.logServerStartup.info(((Object)((Object)this)).getClass().getName() + " initialization done -  ");
    }

    public void destroy() {
        ServletUtil.logServerStartup.info(((Object)((Object)this)).getClass().getName() + " destroy start -  ");
        if (this.diskCache != null) {
            this.diskCache.exit();
        }
        ServletUtil.logServerStartup.info(((Object)((Object)this)).getClass().getName() + " destroy done -  ");
    }

    private String buildCacheUrl(String path) {
        return this.tdsContext.getContextPath() + this.servletCachePath + "/" + path;
    }

    private String buildDatasetUrl(String path) {
        return this.tdsContext.getContextPath() + servletPath + "/" + path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest req, HttpServletResponse res) throws Exception {
        if (!this.allow) {
            res.sendError(403, "Service not supported");
            return null;
        }
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            res.sendError(404);
            return null;
        }
        boolean wantXML = pathInfo.endsWith("/dataset.xml");
        boolean showForm = pathInfo.endsWith("/dataset.html");
        boolean showPointForm = pathInfo.endsWith("/pointDataset.html");
        if (wantXML || showForm || showPointForm) {
            int len = pathInfo.length();
            if (wantXML) {
                pathInfo = pathInfo.substring(0, len - 12);
            } else if (showForm) {
                pathInfo = pathInfo.substring(0, len - 13);
            } else if (showPointForm) {
                pathInfo = pathInfo.substring(0, len - 18);
            }
            if (pathInfo.startsWith("/")) {
                pathInfo = pathInfo.substring(1);
            }
            GridDataset gds = null;
            try {
                gds = DatasetHandler.openGridDataset(req, res, pathInfo);
                if (null == gds) {
                    res.sendError(404);
                    ModelAndView modelAndView = null;
                    return modelAndView;
                }
                this.showForm(res, gds, pathInfo, wantXML, showPointForm);
            }
            catch (FileNotFoundException ioe) {
                if (!res.isCommitted()) {
                    res.sendError(404);
                }
            }
            catch (Throwable e) {
                log.error("GridServlet.showForm", e);
                if (!res.isCommitted()) {
                    res.sendError(500);
                }
            }
            finally {
                if (null != gds) {
                    try {
                        gds.close();
                    }
                    catch (IOException ioe) {
                        log.error("Failed to close = " + pathInfo);
                    }
                }
            }
            return null;
        }
        String point = ServletUtil.getParameterIgnoreCase(req, "point");
        if (point != null && point.equalsIgnoreCase("true")) {
            this.processGridAsPoint(req, res, pathInfo);
            return null;
        }
        this.processGrid(req, res, pathInfo);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGrid(HttpServletRequest req, HttpServletResponse res, String pathInfo) throws IOException {
        long start = System.currentTimeMillis();
        GridDataset gds = null;
        try {
            long estSize;
            boolean addLatLon;
            QueryParams qp = new QueryParams();
            if (!qp.parseQuery(req, res, new String[]{"application/x-netcdf"})) {
                return;
            }
            gds = DatasetHandler.openGridDataset(req, res, pathInfo);
            if (null == gds) {
                res.sendError(404, "Cant find " + pathInfo);
                return;
            }
            if (qp.vars == null || qp.vars.size() == 0) {
                qp.errs.append("No Grid variables selected\n");
                qp.writeErr(req, res, qp.errs.toString(), 400);
                return;
            }
            if (qp.vars != null) {
                int count = 0;
                StringBuilder buff = new StringBuilder();
                for (String varName : qp.vars) {
                    if (null != gds.findGridDatatype(varName)) continue;
                    buff.append(varName);
                    if (count > 0) {
                        buff.append(";");
                    }
                    ++count;
                }
                if (buff.length() != 0) {
                    qp.errs.append("Grid variable(s) not found in dataset=" + buff + "\n");
                    qp.writeErr(req, res, qp.errs.toString(), 400);
                    return;
                }
            }
            if (qp.hasDateRange) {
                CalendarDateRange dr = qp.getCalendarDateRange();
                if (dr.getStart().isAfter(dr.getEnd())) {
                    qp.errs.append("Request Time range start > end\nRequest Time range = " + dr.toString() + "\n");
                    qp.writeErr(req, res, qp.errs.toString(), 400);
                    return;
                }
                if (dr.getStart().isAfter(gds.getCalendarDateEnd()) || dr.getEnd().isBefore(gds.getCalendarDateStart())) {
                    qp.errs.append("RequestTime range does not intersect the Data\nData Time Range = " + gds.getStartDate() + " to " + gds.getEndDate() + "\n");
                    qp.writeErr(req, res, qp.errs.toString(), 400);
                    return;
                }
            }
            boolean hasBB = false;
            if (qp.hasBB) {
                LatLonRect maxBB = gds.getBoundingBox();
                boolean bl = hasBB = !Misc.closeEnough((double)qp.north, (double)maxBB.getUpperRightPoint().getLatitude()) || !Misc.closeEnough((double)qp.south, (double)maxBB.getLowerLeftPoint().getLatitude()) || !Misc.closeEnough((double)qp.east, (double)maxBB.getUpperRightPoint().getLongitude()) || !Misc.closeEnough((double)qp.west, (double)maxBB.getLowerLeftPoint().getLongitude());
                if (maxBB.intersect(qp.getBB()) == null) {
                    qp.errs.append("Request Bounding Box does not intersect the Data\nData Bounding Box = " + maxBB.toString2() + "\n");
                    qp.writeErr(req, res, qp.errs.toString(), 400);
                    return;
                }
            }
            Range zRange = null;
            if (qp.hasVerticalCoord) {
                for (String varName : qp.vars) {
                    GridDatatype grid = gds.findGridDatatype(varName);
                    GridCoordSystem gcs = grid.getCoordinateSystem();
                    CoordinateAxis1D vaxis = gcs.getVerticalAxis();
                    if (vaxis == null || vaxis.getSize() <= 1L) continue;
                    int bestIndex = -1;
                    double bestDiff = Double.MAX_VALUE;
                    int i = 0;
                    while ((long)i < vaxis.getSize()) {
                        double diff = Math.abs(vaxis.getCoordValue(i) - qp.vertCoord);
                        if (diff < bestDiff) {
                            bestIndex = i;
                            bestDiff = diff;
                        }
                        ++i;
                    }
                    if (bestIndex < 0) break;
                    zRange = new Range(bestIndex, bestIndex);
                    break;
                }
            }
            boolean bl = addLatLon = ServletUtil.getParameterIgnoreCase(req, "addLatLon") != null;
            if (this.maxFileDownloadSize > 0L && (estSize = this.makeGridFileSizeEstimate(gds, qp, hasBB, addLatLon, zRange)) > this.maxFileDownloadSize) {
                res.sendError(403, "NCSS request too large = " + estSize + " max = " + this.maxFileDownloadSize);
                return;
            }
            try {
                this.makeGridFile(req, res, gds, qp, hasBB, addLatLon, zRange);
            }
            catch (InvalidRangeException e) {
                res.sendError(400, "Invalid Lat/Lon or Time Range: " + e.getMessage());
            }
        }
        catch (Throwable e) {
            log.error("GridServlet.processGrid", e);
            if (!res.isCommitted()) {
                res.sendError(500);
            }
        }
        finally {
            if (null != gds) {
                try {
                    gds.close();
                }
                catch (IOException ioe) {
                    log.error("Failed to close = " + pathInfo);
                }
            }
        }
        if (log.isDebugEnabled()) {
            long took = System.currentTimeMillis() - start;
            log.debug(" total response took = " + took + " msecs");
        }
    }

    private long makeGridFileSizeEstimate(GridDataset gds, QueryParams qp, boolean useBB, boolean addLatLon, Range zRange) throws IOException, InvalidRangeException {
        NetcdfCFWriter writer = new NetcdfCFWriter();
        return writer.makeGridFileSizeEstimate(gds, qp.vars, useBB ? qp.getBB() : null, qp.horizStride, zRange, qp.hasDateRange ? qp.getCalendarDateRange() : null, qp.timeStride, addLatLon);
    }

    private void makeGridFile(HttpServletRequest req, HttpServletResponse res, GridDataset gds, QueryParams qp, boolean useBB, boolean addLatLon, Range zRange) throws IOException, InvalidRangeException {
        String filename = req.getRequestURI();
        int pos = filename.lastIndexOf("/");
        if (!(filename = filename.substring(pos + 1)).endsWith(".nc")) {
            filename = filename + ".nc";
        }
        Random random = new Random(System.currentTimeMillis());
        int randomInt = random.nextInt();
        String pathname = Integer.toString(randomInt) + "/" + filename;
        File ncFile = this.diskCache.getCacheFile(pathname);
        String cacheFilename = ncFile.getPath();
        String url = this.buildCacheUrl(pathname);
        try {
            NetcdfCFWriter writer = new NetcdfCFWriter();
            writer.makeFile(cacheFilename, gds, qp.vars, useBB ? qp.getBB() : null, qp.horizStride, zRange, qp.hasDateRange ? qp.getCalendarDateRange() : null, qp.timeStride, addLatLon);
        }
        catch (IllegalArgumentException e) {
            res.sendError(403, e.getMessage());
            return;
        }
        catch (Throwable ioe) {
            log.error("Writing to " + cacheFilename, ioe);
            if (!res.isCommitted()) {
                res.sendError(500, ioe.getMessage());
            }
            return;
        }
        res.addHeader("Content-Location", url);
        res.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        ServletUtil.returnFile(req, res, new File(cacheFilename), "application/x-netcdf");
    }

    private void showForm(HttpServletResponse res, GridDataset gds, String path, boolean wantXml, boolean isPoint) throws IOException {
        String infoString;
        GridDatasetInfo writer = new GridDatasetInfo(gds, "path");
        if (wantXml) {
            infoString = writer.writeXML(writer.makeDatasetDescription());
        } else {
            InputStream xslt = this.getXSLT(isPoint ? "/WEB-INF/xsl/ncssGridAsPoint.xsl" : "/WEB-INF/xsl/ncssGrid.xsl");
            Document doc = writer.makeGridForm();
            Element root = doc.getRootElement();
            root.setAttribute("location", this.buildDatasetUrl(path));
            try {
                XSLTransformer transformer = new XSLTransformer(xslt);
                Document html = transformer.transform(doc);
                XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
                infoString = fmt.outputString(html);
            }
            catch (Throwable e) {
                log.error("ForecastModelRunServlet internal error", e);
                if (!res.isCommitted()) {
                    res.sendError(500, "ForecastModelRunServlet internal error");
                }
                return;
            }
        }
        res.setContentLength(infoString.length());
        if (wantXml) {
            res.setContentType("text/xml; charset=iso-8859-1");
        } else {
            res.setContentType("text/html; charset=iso-8859-1");
        }
        ServletOutputStream out = res.getOutputStream();
        out.write(infoString.getBytes(CDM.utf8Charset));
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGridAsPoint(HttpServletRequest req, HttpServletResponse res, String pathInfo) throws IOException {
        long start;
        block60: {
            start = System.currentTimeMillis();
            GridDataset gds = null;
            try {
                QueryParams qp;
                block59: {
                    qp = new QueryParams();
                    if (!qp.parseQuery(req, res, new String[]{"text/csv", "application/xml", "application/x-netcdf"})) {
                        return;
                    }
                    gds = DatasetHandler.openGridDataset(req, res, pathInfo);
                    if (null == gds) {
                        res.sendError(404);
                        return;
                    }
                    if (qp.vars == null || qp.vars.size() == 0) {
                        qp.errs.append("No Grid variables selected\n");
                        qp.writeErr(req, res, qp.errs.toString(), 400);
                        return;
                    }
                    if (qp.vars != null) {
                        int count = 0;
                        StringBuilder buff = new StringBuilder();
                        for (String varName : qp.vars) {
                            if (null != gds.findGridDatatype(varName)) continue;
                            buff.append(varName);
                            if (count > 0) {
                                buff.append(";");
                            }
                            ++count;
                        }
                        if (buff.length() != 0) {
                            qp.errs.append("Grid variable(s) not found in dataset=" + buff + "\n");
                            qp.writeErr(req, res, qp.errs.toString(), 400);
                            return;
                        }
                    } else {
                        qp.errs.append("You must specify at least one variable\n");
                        qp.writeErr(req, res, qp.errs.toString(), 400);
                        return;
                    }
                    if (qp.hasLatlonPoint) {
                        LatLonPoint pt;
                        LatLonRect bb = gds.getBoundingBox();
                        if (!bb.contains(pt = qp.getPoint())) {
                            qp.errs.append("Requested Lat/Lon Point (+" + pt + ") is not contained in the Data\n" + "Data Bounding Box = " + bb.toString2() + "\n");
                            qp.writeErr(req, res, qp.errs.toString(), 400);
                            return;
                        }
                    } else {
                        qp.errs.append("Must specify a Lat/Lon Point\n");
                        qp.writeErr(req, res, qp.errs.toString(), 400);
                        return;
                    }
                    GridPointWriter writer = new GridPointWriter(gds, this.diskCache);
                    String contentType = qp.acceptType;
                    if (qp.acceptType.equals("text/csv")) {
                        contentType = "text/plain";
                    }
                    res.setContentType(contentType);
                    try {
                        if (qp.acceptType.equals("application/x-netcdf")) break block59;
                        writer.write(qp, res.getWriter());
                        if (this.debug) {
                            long took = System.currentTimeMillis() - start;
                            System.out.println("\ntotal response took = " + took + " msecs");
                        }
                        return;
                    }
                    catch (InvalidRangeException e) {
                        if (!res.isCommitted()) {
                            res.sendError(400, "Invalid Lat/Lon or Time Range");
                        }
                        break block60;
                    }
                }
                this.sendPointFile(req, res, gds, qp);
            }
            catch (Throwable e) {
                System.err.println("GridServlet.processGridAsPoint req=" + req.getRequestURI());
                e.printStackTrace();
                log.error("GridServlet.processGridAsPoint", e);
                if (!res.isCommitted()) {
                    res.sendError(500);
                }
            }
            finally {
                if (null != gds) {
                    try {
                        gds.close();
                    }
                    catch (IOException ioe) {
                        log.error("Failed to close = " + pathInfo);
                    }
                }
            }
        }
        if (this.debug) {
            long took = System.currentTimeMillis() - start;
            System.out.println("\ntotal response took = " + took + " msecs");
        }
    }

    private void sendPointFile(HttpServletRequest req, HttpServletResponse res, GridDataset gds, QueryParams qp) throws IOException, InvalidRangeException {
        File result;
        String filename = req.getRequestURI();
        int pos = filename.lastIndexOf("/");
        if (!(filename = filename.substring(pos + 1)).endsWith(".nc")) {
            filename = filename + ".nc";
        }
        Random random = new Random(System.currentTimeMillis());
        int randomInt = random.nextInt();
        String pathname = Integer.toString(randomInt) + "/" + filename;
        File ncFile = this.diskCache.getCacheFile(pathname);
        String cacheFilename = ncFile.getPath();
        String url = this.buildCacheUrl(pathname);
        try {
            GridPointWriter writer = new GridPointWriter(gds, this.diskCache);
            PrintWriter pw = !qp.acceptType.equals("application/x-netcdf") ? res.getWriter() : null;
            result = writer.write(qp, pw);
        }
        catch (Throwable ioe) {
            log.error("Writing to " + cacheFilename, ioe);
            if (!res.isCommitted()) {
                res.sendError(500, ioe.getMessage());
            }
            return;
        }
        res.addHeader("Content-Location", url);
        res.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        ServletUtil.returnFile(req, res, result, "application/x-netcdf");
    }

    private InputStream getXSLT(String xslName) throws IOException {
        ServletContextResource r = new ServletContextResource(this.getServletContext(), xslName);
        return r.getInputStream();
    }
}

