/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.controller;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import thredds.server.ncSubset.controller.AbstractNcssController;
import thredds.server.ncSubset.controller.SupportedOperation;
import thredds.server.ncSubset.exception.UnsupportedResponseFormatException;
import thredds.server.ncSubset.format.SupportedFormat;
import thredds.server.ncSubset.params.ParamsBean;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.grid.gis.GridBoundariesExtractor;

@Controller
@Scope(value="request")
@RequestMapping(value={"/ncss/grid/**"})
public class DatasetBoundariesController
extends AbstractNcssController {
    private static final Logger log = LoggerFactory.getLogger(DatasetBoundariesController.class);

    @RequestMapping(value={"datasetBoundaries"})
    void getDatasetBoundaries(ParamsBean params, HttpServletRequest req, HttpServletResponse res) throws IOException, UnsupportedResponseFormatException {
        SupportedFormat sf = this.getSupportedFormat(params, SupportedOperation.DATASET_BOUNDARIES_REQUEST);
        String boundaries = this.getBoundaries(sf);
        res.setContentType(sf.getResponseContentType());
        res.getWriter().write(boundaries);
        res.getWriter().flush();
    }

    private String getBoundaries(SupportedFormat format) {
        String boundaries = "";
        GridBoundariesExtractor gbe = GridBoundariesExtractor.valueOf((GridDataset)this.gridDataset);
        if (format == SupportedFormat.WKT) {
            boundaries = gbe.getDatasetBoundariesWKT();
        }
        if (format == SupportedFormat.JSON) {
            boundaries = gbe.getDatasetBoundariesGeoJSON();
        }
        return boundaries;
    }

    @Override
    String extractRequestPathInfo(String requestPathInfo) {
        if (requestPathInfo.endsWith("datasetBoundaries")) {
            requestPathInfo = requestPathInfo.trim();
            String[] pathInfoArr = requestPathInfo.split("/");
            StringBuilder sb = new StringBuilder();
            int len = pathInfoArr.length;
            sb.append(pathInfoArr[1]);
            for (int i = 2; i < len - 1; ++i) {
                sb.append("/" + pathInfoArr[i]);
            }
            requestPathInfo = sb.toString();
        }
        this.requestPathInfo = requestPathInfo;
        return requestPathInfo;
    }
}

