/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.controller;

import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import thredds.server.ncSubset.controller.AbstractNcssController;
import thredds.server.ncSubset.dataservice.NcssShowDatasetInfo;
import thredds.server.ncSubset.util.NcssRequestUtils;

@Controller
@Scope(value="request")
class DatasetInfoController
extends AbstractNcssController {
    private boolean wantXML = false;
    private boolean showForm = false;
    private boolean showPointForm = false;
    private static final Logger log = LoggerFactory.getLogger(DatasetInfoController.class);
    @Autowired
    private NcssShowDatasetInfo ncssShowDatasetInfo;

    DatasetInfoController() {
    }

    @RequestMapping(value={"/ncss/grid/**/dataset.html", "/ncss/grid/**/dataset.xml", "/ncss/grid/**/pointDataset.html"})
    void getDatasetDescription(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String strResponse = this.ncssShowDatasetInfo.showForm(this.getGridDataset(), this.buildDatasetUrl(this.requestPathInfo), this.wantXML, this.showPointForm);
        res.setContentLength(strResponse.length());
        if (this.wantXML) {
            res.setContentType("text/xml; charset=iso-8859-1");
        } else {
            res.setContentType("text/html; charset=UTF-8");
        }
        PrintWriter pw = res.getWriter();
        pw.write(strResponse);
        pw.flush();
        res.flushBuffer();
    }

    private String buildDatasetUrl(String path) {
        return NcssRequestUtils.getTdsContext().getContextPath() + "/ncss/grid" + "/" + path;
    }

    @Override
    String extractRequestPathInfo(String requestPathInfo) {
        this.wantXML = requestPathInfo.endsWith("/dataset.xml");
        this.showForm = requestPathInfo.endsWith("/dataset.html");
        this.showPointForm = requestPathInfo.endsWith("/pointDataset.html");
        if (this.wantXML || this.showForm || this.showPointForm) {
            int len = requestPathInfo.length();
            if (this.wantXML) {
                requestPathInfo = requestPathInfo.substring(0, len - 12);
            } else if (this.showForm) {
                requestPathInfo = requestPathInfo.substring(0, len - 13);
            } else if (this.showPointForm) {
                requestPathInfo = requestPathInfo.substring(0, len - 18);
            }
            if (requestPathInfo.startsWith("/")) {
                requestPathInfo = requestPathInfo.substring(1);
            }
        }
        this.requestPathInfo = requestPathInfo;
        return requestPathInfo;
    }
}

