/*
 * Decompiled with CFR 0.152.
 */
package thredds.util;

import org.springframework.util.StringUtils;
import thredds.util.PathAliasReplacement;
import thredds.util.StartsWithPathAliasReplacement;

public class TdsConfiguredPathAliasReplacement
implements PathAliasReplacement {
    private final String alias;
    private StartsWithPathAliasReplacement swpar;

    public TdsConfiguredPathAliasReplacement(String alias) {
        if (alias == null) {
            throw new IllegalArgumentException("Alias must not be null.");
        }
        this.alias = (alias = StringUtils.cleanPath((String)alias)).endsWith("/") ? alias.substring(0, alias.length() - 1) : alias;
        this.swpar = null;
    }

    public void init(String replacementPath) {
        this.swpar = new StartsWithPathAliasReplacement(this.alias, replacementPath);
    }

    public String getAlias() {
        return this.alias;
    }

    public String getReplacementPath() {
        if (this.swpar == null) {
            throw new IllegalStateException("Not yet initialized.");
        }
        return this.swpar.getReplacementPath();
    }

    public boolean containsPathAlias(String path) {
        if (this.swpar == null) {
            throw new IllegalStateException("Not yet initialized.");
        }
        return this.swpar.containsPathAlias(path);
    }

    public String replacePathAlias(String path) {
        if (this.swpar == null) {
            throw new IllegalStateException("Not yet initialized.");
        }
        return this.swpar.replacePathAlias(path);
    }
}

