/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wms;

import java.io.IOException;
import java.util.List;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import thredds.server.wms.ThreddsDataset;
import thredds.server.wms.ThreddsLayer;
import thredds.server.wms.config.LayerSettings;
import uk.ac.rdg.resc.edal.coverage.grid.HorizontalGrid;
import uk.ac.rdg.resc.edal.coverage.grid.RegularGrid;
import uk.ac.rdg.resc.edal.util.Range;
import uk.ac.rdg.resc.ncwms.exceptions.InvalidDimensionValueException;
import uk.ac.rdg.resc.ncwms.graphics.ColorPalette;
import uk.ac.rdg.resc.ncwms.wms.ScalarLayer;
import uk.ac.rdg.resc.ncwms.wms.VectorLayer;

class ThreddsVectorLayer
implements VectorLayer,
ThreddsLayer {
    private final VectorLayer wrappedLayer;
    private LayerSettings layerSettings;

    public ThreddsVectorLayer(VectorLayer wrappedLayer) {
        this.wrappedLayer = wrappedLayer;
    }

    public String getName() {
        return this.getId();
    }

    @Override
    public String getStandardName() {
        return this.getId();
    }

    public ScalarLayer getXComponent() {
        return this.wrappedLayer.getXComponent();
    }

    public ScalarLayer getYComponent() {
        return this.wrappedLayer.getYComponent();
    }

    public List<Float>[] readXYComponents(DateTime dateTime, double elevation, RegularGrid grid) throws InvalidDimensionValueException, IOException, FactoryException, TransformException {
        return this.wrappedLayer.readXYComponents(dateTime, elevation, grid);
    }

    @Override
    public ThreddsDataset getDataset() {
        return (ThreddsDataset)this.wrappedLayer.getDataset();
    }

    public String getId() {
        return this.wrappedLayer.getId();
    }

    public String getTitle() {
        return this.wrappedLayer.getTitle();
    }

    public String getLayerAbstract() {
        return this.wrappedLayer.getLayerAbstract();
    }

    public String getUnits() {
        return this.wrappedLayer.getUnits();
    }

    public GeographicBoundingBox getGeographicBoundingBox() {
        return this.wrappedLayer.getGeographicBoundingBox();
    }

    public HorizontalGrid getHorizontalGrid() {
        return this.wrappedLayer.getHorizontalGrid();
    }

    public Chronology getChronology() {
        return this.wrappedLayer.getChronology();
    }

    public List<DateTime> getTimeValues() {
        return this.wrappedLayer.getTimeValues();
    }

    public DateTime getCurrentTimeValue() {
        return this.wrappedLayer.getCurrentTimeValue();
    }

    public DateTime getDefaultTimeValue() {
        return this.wrappedLayer.getDefaultTimeValue();
    }

    public List<Double> getElevationValues() {
        return this.wrappedLayer.getElevationValues();
    }

    public double getDefaultElevationValue() {
        return this.wrappedLayer.getDefaultElevationValue();
    }

    public String getElevationUnits() {
        return this.wrappedLayer.getElevationUnits();
    }

    public boolean isElevationPositive() {
        return this.wrappedLayer.isElevationPositive();
    }

    public boolean isElevationPressure() {
        return this.wrappedLayer.isElevationPressure();
    }

    @Override
    public void setLayerSettings(LayerSettings layerSettings) {
        this.layerSettings = layerSettings;
    }

    public boolean isQueryable() {
        return this.layerSettings.isAllowFeatureInfo();
    }

    public boolean isIntervalTime() {
        return this.layerSettings.isIntervalTime();
    }

    public Range<Float> getApproxValueRange() {
        return this.layerSettings.getDefaultColorScaleRange();
    }

    public boolean isLogScaling() {
        return this.layerSettings.isLogScaling();
    }

    public ColorPalette getDefaultColorPalette() {
        return ColorPalette.get((String)this.layerSettings.getDefaultPaletteName());
    }

    public int getDefaultNumColorBands() {
        return this.layerSettings.getDefaultNumColorBands();
    }
}

