/*
 * Decompiled with CFR 0.152.
 */
package thredds.dqc.server.jplQuikSCAT;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.dqc.UserQuery;
import thredds.dqc.server.jplQuikSCAT.JplQuikScatCalendar;

public class JplQuikScatUserQuery
implements UserQuery {
    private static Logger log = LoggerFactory.getLogger(JplQuikScatUserQuery.class);
    protected double dateRangeMin = 0.0;
    protected double dateRangeMax = 0.0;
    protected boolean dateRangeSet = false;
    protected double longitudeRangeMin = 0.0;
    protected double longitudeRangeMax = 0.0;
    protected boolean longitudeRangeSet = false;
    protected JplQuikScatCalendar calendar = null;

    private JplQuikScatUserQuery() {
    }

    public JplQuikScatUserQuery(JplQuikScatCalendar calendar) {
        if (calendar == null) {
            String tmpMsg = "JplQuikScatUserQuery(): given calendar is null";
            log.debug(tmpMsg);
            throw new IllegalArgumentException(tmpMsg);
        }
        this.calendar = calendar;
    }

    public void setDateRange(String minString, String maxString) {
        String tmpMsg = null;
        if (minString != null && maxString != null) {
            this.dateRangeMin = Double.parseDouble(minString);
            this.dateRangeMax = Double.parseDouble(maxString);
            this.dateRangeSet = true;
            if (this.dateRangeMin > this.dateRangeMax) {
                tmpMsg = "setDateRange(strings): date range min <" + this.dateRangeMin + "> greater than date range max <" + this.dateRangeMax + ">.";
                log.debug(tmpMsg);
                throw new IllegalArgumentException(tmpMsg);
            }
            log.debug("setDateRange(strings): date range (in seconds since " + this.calendar.getEpochStartDateString() + "), from " + this.dateRangeMin + " to " + this.dateRangeMax + ".");
        } else {
            if (minString != null || maxString != null) {
                tmpMsg = "setDateRange(strings): one but not both date strings are null: min <" + minString + ">, max <" + maxString + ">.";
                log.debug(tmpMsg);
                throw new IllegalArgumentException(tmpMsg);
            }
            this.dateRangeSet = false;
        }
    }

    public void setDateRange(double min, double max) {
        String tmpMsg = null;
        this.dateRangeMin = min;
        this.dateRangeMax = max;
        this.dateRangeSet = true;
        if (this.dateRangeMin > this.dateRangeMax) {
            tmpMsg = "setDateRange(strings): date range min <" + this.dateRangeMin + "> greater than date range max <" + this.dateRangeMax + ">.";
            log.debug(tmpMsg);
            throw new IllegalArgumentException(tmpMsg);
        }
        log.debug("setDateRange(doubles): date range (in seconds since " + this.calendar.getEpochStartDateString() + "), from " + this.dateRangeMin + " to " + this.dateRangeMax + ".");
    }

    public boolean isDateRangeSet() {
        return this.dateRangeSet;
    }

    public double getDateRangeMin() {
        return this.dateRangeMin;
    }

    public double getDateRangeMax() {
        return this.dateRangeMax;
    }

    public Date getDateRangeMinDate() {
        return this.calendar.getDateFromSecondsSinceEpoch(this.dateRangeMin);
    }

    public Date getDateRangeMaxDate() {
        return this.calendar.getDateFromSecondsSinceEpoch(this.dateRangeMax);
    }

    public void setLongitudeRange(String minString, String maxString) {
        if (minString != null && maxString != null) {
            this.longitudeRangeMin = Double.parseDouble(minString);
            this.longitudeRangeMax = Double.parseDouble(maxString);
            this.longitudeRangeSet = true;
            log.debug("setLongitudeRange(strings): longitude range (degree_east), from " + this.longitudeRangeMin + " to " + this.longitudeRangeMax + ".");
        } else {
            if (minString != null || maxString != null) {
                String tmp = "setLongitudeRange(strings): one but not both longitude strings are null: min <" + minString + ">, max <" + maxString + ">.";
                log.debug(tmp);
                throw new IllegalArgumentException(tmp);
            }
            this.longitudeRangeSet = false;
        }
    }

    public void setLongitudeRange(double min, double max) {
        this.longitudeRangeMin = min;
        this.longitudeRangeMax = max;
        this.longitudeRangeSet = true;
        log.debug("setLongitudeRange(dates): longitude range (degree_east), from " + this.longitudeRangeMin + " to " + this.longitudeRangeMax + ".");
    }

    public boolean isLongitudeRangeSet() {
        return this.longitudeRangeSet;
    }

    public double getLongitudeRangeMin() {
        return this.longitudeRangeMin;
    }

    public double getLongitudeRangeMax() {
        return this.longitudeRangeMax;
    }

    @Override
    public boolean isSet() {
        return this.isDateRangeSet() || this.isLongitudeRangeSet();
    }
}

