/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wcs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import thredds.server.wcs.VersionHandler;
import thredds.server.wcs.v1_0_0_1.WcsHandler;
import thredds.servlet.AbstractServlet;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsConfig;
import thredds.util.Version;
import ucar.nc2.util.DiskCache2;

public class WCSServlet
extends AbstractServlet {
    private DiskCache2 diskCache = null;
    private boolean allow = false;
    private boolean deleteImmediately = true;
    private boolean allowRemote = false;
    private long maxFileDownloadSize;
    private List<VersionHandler> versionHandlers;
    private List<VersionHandler> experimentalHandlers;
    private String supportedVersionsString;
    private VersionHandler latestSupportedVersion;

    @Override
    protected String getPath() {
        return "wcs/";
    }

    @Override
    protected void makeDebugActions() {
    }

    @Override
    public void init() throws ServletException {
        super.init();
        this.allow = ThreddsConfig.getBoolean("WCS.allow", false);
        this.logServerStartup.info("WCS:allow= " + this.allow);
        if (!this.allow) {
            this.logServerStartup.info("WCS service not enabled in threddsConfig.xml: ");
            return;
        }
        this.allowRemote = ThreddsConfig.getBoolean("WCS.allowRemote", false);
        this.deleteImmediately = ThreddsConfig.getBoolean("WCS.deleteImmediately", this.deleteImmediately);
        this.maxFileDownloadSize = ThreddsConfig.getBytes("WCS.maxFileDownloadSize", 1000000000L);
        String cache = ThreddsConfig.get("WCS.dir", ServletUtil.getContentPath() + "cache/wcs/");
        File cacheDir = new File(cache);
        cacheDir.mkdirs();
        int scourSecs = ThreddsConfig.getSeconds("WCS.scour", 600);
        int maxAgeSecs = ThreddsConfig.getSeconds("WCS.maxAge", -1);
        maxAgeSecs = Math.max(maxAgeSecs, 300);
        scourSecs = Math.max(scourSecs, 300);
        this.diskCache = new DiskCache2(cache, false, maxAgeSecs / 60, scourSecs / 60);
        this.latestSupportedVersion = new WcsHandler("1.0.0").setDeleteImmediately(this.deleteImmediately).setDiskCache(this.diskCache);
        VersionHandler wcsPlusVersion = new thredds.server.wcs.v1_0_0_Plus.WcsHandler("1.0.0.11").setDeleteImmediately(this.deleteImmediately).setDiskCache(this.diskCache);
        this.versionHandlers = new ArrayList<VersionHandler>();
        this.versionHandlers.add(this.latestSupportedVersion);
        for (VersionHandler vh : this.versionHandlers) {
            this.supportedVersionsString = (this.supportedVersionsString == null ? "" : this.supportedVersionsString + ",") + vh.getVersion().getVersionString();
        }
        this.experimentalHandlers = new ArrayList<VersionHandler>();
        this.experimentalHandlers.add(wcsPlusVersion);
        this.logServerStartup.info("WCS service - init done - ");
    }

    public void destroy() {
        this.logServerStartup.info("WCSServlet.destroy() start: ");
        if (this.diskCache != null) {
            this.diskCache.exit();
        }
        super.destroy();
        this.logServerStartup.info("WCSServlet.destroy() done:");
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!this.allow) {
            res.sendError(403, "WCS service not supported");
            this.log.debug("WCS service not supported in threddsConfig.xml");
            return;
        }
        String datasetURL = ServletUtil.getParameterIgnoreCase(req, "dataset");
        if (datasetURL != null && !this.allowRemote) {
            res.sendError(403, "WCS service not supported for remote datasets.");
            return;
        }
        String serviceParam = ServletUtil.getParameterIgnoreCase(req, "Service");
        String requestParam = ServletUtil.getParameterIgnoreCase(req, "Request");
        String acceptVersionsParam = ServletUtil.getParameterIgnoreCase(req, "AcceptVersions");
        String versionParam = ServletUtil.getParameterIgnoreCase(req, "Version");
        if (serviceParam == null || !serviceParam.equalsIgnoreCase("WCS")) {
            res.sendError(400, "GET request not a WCS KVP requestParam (missing or bad SERVICE parameter).");
            return;
        }
        VersionHandler targetHandler = null;
        if (requestParam == null) {
            this.latestSupportedVersion.handleExceptionReport(res, "MissingParameterValue", "Request", "");
            return;
        }
        if (requestParam.equalsIgnoreCase(Operation.GetCapabilities.toString())) {
            if (acceptVersionsParam == null && versionParam == null) {
                targetHandler = this.latestSupportedVersion;
            } else {
                if (acceptVersionsParam != null && versionParam != null) {
                    this.latestSupportedVersion.handleExceptionReport(res, "NoApplicableCode", "", "Request requires one and only one version parameter: either \"Version\" or \"AcceptVersions\".");
                    return;
                }
                if (acceptVersionsParam != null) {
                    targetHandler = this.getHandlerUsingNegotiation_1_1_0(acceptVersionsParam);
                    if (targetHandler == null) {
                        this.latestSupportedVersion.handleExceptionReport(res, "VersionNegotiationFailed", "AcceptVersions", "The \"AcceptVersions\" parameter value [" + acceptVersionsParam + "[ did not match any supported versions [" + this.supportedVersionsString + "].");
                        return;
                    }
                } else if (versionParam != null) {
                    targetHandler = this.getHandlerUsingNegotiation_1_0_0(versionParam);
                    if (targetHandler == null) {
                        this.latestSupportedVersion.handleExceptionReport(res, "InvalidParameterValue", "Version", "Invale \"Version\" parameter value [" + acceptVersionsParam + "] did not match any supported versions [" + this.supportedVersionsString + "].");
                        return;
                    }
                } else {
                    targetHandler = this.latestSupportedVersion;
                }
            }
        } else {
            if (!requestParam.equalsIgnoreCase(Operation.DescribeCoverage.toString()) && !requestParam.equalsIgnoreCase(Operation.GetCoverage.toString())) {
                this.latestSupportedVersion.handleExceptionReport(res, "InvalidParameterValue", "Request", "Invalid \"Operation\" parameter value [" + requestParam + "].");
                return;
            }
            if (versionParam == null) {
                this.latestSupportedVersion.handleExceptionReport(res, "InvalidParameterValue", "Version", "Request requires a \"Version\" parameter.");
                return;
            }
            targetHandler = this.getMatchingVersionHandler(versionParam);
            if (targetHandler == null && (targetHandler = this.getMatchingExpermimentalVersionHandler(versionParam)) == null) {
                this.latestSupportedVersion.handleExceptionReport(res, "InvalidParameterValue", "Version", "Invaled \"Version\" parameter value [" + versionParam + "].");
                return;
            }
        }
        if (targetHandler == null) {
            this.latestSupportedVersion.handleExceptionReport(res, "VersionNegotiationFailed", "", "Version negotiation failed.");
            return;
        }
        targetHandler.handleKVP(this, req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!this.allow) {
            res.setStatus(403);
            return;
        }
        res.setStatus(405);
        res.setHeader("Allow", "GET");
    }

    private VersionHandler getHandlerUsingNegotiation_1_0_0(String versionNumber) {
        if (versionNumber == null) {
            return null;
        }
        Version reqVersion = null;
        try {
            reqVersion = new Version(versionNumber);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        VersionHandler handler = null;
        VersionHandler prevVh = null;
        for (VersionHandler curVh : this.versionHandlers) {
            int reqCompareCur = reqVersion.compareTo(curVh.getVersion());
            if (reqCompareCur == 0) {
                return curVh;
            }
            if (reqCompareCur < 0) {
                if (prevVh == null) {
                    return curVh;
                }
                return prevVh;
            }
            if (reqCompareCur <= 0) continue;
            prevVh = curVh;
        }
        if (handler == null) {
            for (VersionHandler curVh : this.experimentalHandlers) {
                if (!reqVersion.equals(curVh.getVersion())) continue;
                return curVh;
            }
            return this.latestSupportedVersion;
        }
        return handler;
    }

    private VersionHandler getHandlerUsingNegotiation_1_1_0(String acceptVersionsParam) throws IOException {
        String curVerString;
        String[] acceptableVersions;
        VersionHandler handler = null;
        String[] arr$ = acceptableVersions = acceptVersionsParam.split(",");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (handler = this.getMatchingVersionHandler(curVerString = arr$[i$])) == null; ++i$) {
        }
        return handler;
    }

    private VersionHandler getMatchingVersionHandler(String versionNumber) {
        if (versionNumber == null) {
            return null;
        }
        Version reqVersion = null;
        try {
            reqVersion = new Version(versionNumber);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        for (VersionHandler curVh : this.versionHandlers) {
            if (!reqVersion.equals(curVh.getVersion())) continue;
            return curVh;
        }
        return null;
    }

    private VersionHandler getMatchingExpermimentalVersionHandler(String versionNumber) {
        if (versionNumber == null) {
            return null;
        }
        Version reqVersion = null;
        try {
            reqVersion = new Version(versionNumber);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        for (VersionHandler curVh : this.experimentalHandlers) {
            if (!reqVersion.equals(curVh.getVersion())) continue;
            return curVh;
        }
        return null;
    }

    public static enum Operation {
        GetCapabilities,
        DescribeCoverage,
        GetCoverage;

    }
}

