/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.controller;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import thredds.server.ncss.controller.AbstractNcssController;
import thredds.server.ncss.dataservice.FeatureDatasetService;
import thredds.server.ncss.exception.UnsupportedResponseFormatException;
import thredds.server.ncss.format.SupportedFormat;
import thredds.server.ncss.format.SupportedOperation;
import thredds.server.ncss.params.NcssParamsBean;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.dt.grid.gis.GridBoundariesExtractor;
import ucar.nc2.ft.FeatureDataset;

@Controller
@Scope(value="request")
@RequestMapping(value={"/ncss/**/datasetBoundaries.xml"})
public class NcssDatasetBoundariesController
extends AbstractNcssController {
    private static final Logger log = LoggerFactory.getLogger(NcssDatasetBoundariesController.class);
    @Autowired
    FeatureDatasetService datasetService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"datasetBoundaries"})
    void getDatasetBoundaries(NcssParamsBean params, HttpServletRequest req, HttpServletResponse res) throws IOException, UnsupportedResponseFormatException {
        SupportedFormat sf = this.getSupportedFormat(params, SupportedOperation.DATASET_BOUNDARIES_REQUEST);
        String datasetPath = NcssDatasetBoundariesController.getDatasetPath(req);
        FeatureDataset fd = null;
        try {
            fd = this.datasetService.findDatasetByPath(req, res, datasetPath);
            if (fd == null) {
                throw new UnsupportedOperationException("Feature Type not supported");
            }
            if (fd.getFeatureType() != FeatureType.GRID) {
                throw new UnsupportedOperationException("Dataset Boundaries request is only supported on Grid features");
            }
            String boundaries = this.getBoundaries(sf, (GridDataset)fd);
            res.setContentType(sf.getResponseContentType());
            res.getWriter().write(boundaries);
            res.getWriter().flush();
        }
        finally {
            if (fd != null) {
                fd.close();
            }
        }
    }

    private String getBoundaries(SupportedFormat format, GridDataset gridDataset) {
        String boundaries = "";
        GridBoundariesExtractor gbe = GridBoundariesExtractor.valueOf((ucar.nc2.dt.GridDataset)gridDataset);
        if (format == SupportedFormat.WKT) {
            boundaries = gbe.getDatasetBoundariesWKT();
        }
        if (format == SupportedFormat.JSON) {
            boundaries = gbe.getDatasetBoundariesGeoJSON();
        }
        return boundaries;
    }

    protected SupportedFormat getSupportedFormat(NcssParamsBean params, SupportedOperation operation) throws UnsupportedResponseFormatException {
        SupportedFormat sf;
        if (params.getAccept() == null) {
            sf = operation.getDefaultFormat();
            params.setAccept(sf.getFormatName());
        } else {
            sf = operation.getSupportedFormat(params.getAccept());
            if (sf == null) {
                operation.getSupportedFormat(params.getAccept());
                throw new UnsupportedResponseFormatException("Requested format: " + params.getAccept() + " is not supported for " + operation.getName().toLowerCase());
            }
        }
        return sf;
    }
}

