/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cdmremote.service;

import java.io.IOException;
import java.util.Formatter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.server.cdmremote.service.FeatureDatasetPointService;
import thredds.servlet.DatasetHandler;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;

@Service
public class FeatureDatasetPointServiceImpl
implements FeatureDatasetPointService {
    private static final Logger log = LoggerFactory.getLogger(FeatureDatasetPointServiceImpl.class);

    @Override
    public FeatureDatasetPoint findFeatureDatasetPointByPath(HttpServletRequest req, HttpServletResponse res, String path) throws IOException {
        FeatureDatasetPoint fdp = null;
        InvDatasetFeatureCollection fc = DatasetHandler.getFeatureCollection(req, res, path);
        if (fc != null) {
            fdp = (FeatureDatasetPoint)fc.getFeatureDataset();
        } else {
            FeatureDataset fd;
            NetcdfFile ncfile = DatasetHandler.getNetcdfFile(req, res, path);
            if (ncfile != null && (fd = FeatureDatasetFactoryManager.wrap((FeatureType)FeatureType.ANY, (NetcdfDataset)NetcdfDataset.wrap((NetcdfFile)ncfile, null), null, (Formatter)new Formatter(System.err))) instanceof FeatureDatasetPoint) {
                fdp = (FeatureDatasetPoint)fd;
            }
        }
        if (fdp == null) {
            res.sendError(404, "not a point or station dataset");
            return null;
        }
        List list = fdp.getPointFeatureCollectionList();
        if (list.size() == 0) {
            log.error(fdp.getLocation() + " does not have any PointFeatureCollections");
            res.sendError(404, fdp.getLocation() + " does not have any PointFeatureCollections");
            return null;
        }
        FeatureType ft = null;
        if (path.endsWith("/station")) {
            ft = FeatureType.STATION;
            path = path.substring(0, path.lastIndexOf(47));
        } else if (path.endsWith("/point")) {
            ft = FeatureType.POINT;
            path = path.substring(0, path.lastIndexOf(47));
        }
        if (ft != null && ft != fdp.getFeatureType()) {
            res.sendError(404, "feature type mismatch:  expetected " + ft + " found" + fdp.getFeatureType());
        }
        return fdp;
    }
}

