/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import thredds.server.ncss.controller.NcssResponder;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.format.SupportedFormat;
import thredds.server.ncss.params.NcssParamsBean;
import thredds.server.ncss.view.dsg.StationWriter;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.util.DiskCache2;

public class StationResponder
implements NcssResponder {
    private static final Logger log = LoggerFactory.getLogger(StationResponder.class);
    private StationWriter stationWriter;

    public static StationResponder factory(FeatureDataset fd, NcssParamsBean queryParams, DiskCache2 diskCache, SupportedFormat format, OutputStream out) throws IOException, ParseException, NcssException {
        FeatureDatasetPoint fdp = (FeatureDatasetPoint)fd;
        List coll = fdp.getPointFeatureCollectionList();
        StationTimeSeriesFeatureCollection sfc = (StationTimeSeriesFeatureCollection)coll.get(0);
        StationWriter stationWriter = StationWriter.stationWriterFactory((FeatureDatasetPoint)fd, sfc, queryParams, diskCache, out, format);
        return new StationResponder(diskCache, format, out, stationWriter);
    }

    private StationResponder(DiskCache2 diskCache, SupportedFormat format, OutputStream out, StationWriter stationWriter) {
        this.stationWriter = stationWriter;
    }

    @Override
    public void respond(HttpServletResponse res, FeatureDataset fd, String requestPathInfo, NcssParamsBean queryParams, SupportedFormat format) throws IOException, ParseException, InvalidRangeException, NcssException {
        this.stationWriter.write();
    }

    @Override
    public HttpHeaders getResponseHeaders(FeatureDataset fd, SupportedFormat format, String datasetPath) {
        return this.stationWriter.getHttpHeaders(fd, format, datasetPath);
    }
}

