/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import thredds.server.cdmremote.StationWriter;
import thredds.server.ncss.controller.NcssController;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.format.SupportedFormat;
import thredds.server.ncss.params.NcssParamsBean;
import thredds.server.ncss.util.NcssRequestUtils;
import thredds.server.ncss.view.dsg.AbstractWriter;
import thredds.server.ncss.view.gridaspoint.NetCDFPointDataWriter;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.remote.PointStream;
import ucar.nc2.ft.point.remote.PointStreamProto;
import ucar.nc2.ft.point.writer.WriterCFPointCollection;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamProto;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.xml.Parse;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.util.Format;

public class PointWriter
extends AbstractWriter {
    private static Logger log = LoggerFactory.getLogger(StationWriter.class);
    private static final boolean debug = false;
    private static final boolean debugDetail = false;
    private PointFeatureCollection pfc;
    private Writer writer;
    private LatLonRect wantBB;

    public static PointWriter factory(FeatureDatasetPoint fd, PointFeatureCollection sfc, NcssParamsBean qb, DiskCache2 diskCache, OutputStream out, SupportedFormat format) throws IOException, ParseException, NcssException {
        PointWriter sw = new PointWriter(fd, sfc, qb, diskCache);
        sw.writer = sw.getWriterForFormat(out, format);
        return sw;
    }

    public HttpHeaders getHttpHeaders(FeatureDataset fd, SupportedFormat format, String datasetPath) {
        return this.writer.getHttpHeaders(datasetPath);
    }

    private PointWriter(FeatureDatasetPoint fd, PointFeatureCollection pfc, NcssParamsBean qb, DiskCache2 diskCache) throws IOException, NcssException {
        super(fd, qb, diskCache);
        this.pfc = pfc;
    }

    private Writer getWriterForFormat(OutputStream out, SupportedFormat format) throws IOException, ParseException, NcssException {
        Writer w;
        switch (format) {
            case XML_STREAM: 
            case XML_FILE: {
                w = new WriterXML(new PrintWriter(out), format);
                break;
            }
            case CSV_STREAM: 
            case CSV_FILE: {
                w = new WriterCSV(new PrintWriter(out), format);
                break;
            }
            case NETCDF3: {
                w = new WriterNetcdf(out, format);
                break;
            }
            case NETCDF4: {
                w = new WriterNetcdf(out, format);
                break;
            }
            default: {
                log.error("Unknown result type = " + format.getFormatName());
                return null;
            }
        }
        return w;
    }

    public File writeNetcdf() throws IOException {
        WriterNetcdf w = (WriterNetcdf)this.write();
        return w.netcdfResult;
    }

    public Writer write() throws IOException {
        long start = System.currentTimeMillis();
        Limit counter = new Limit();
        this.pfc.resetIteration();
        Action act = this.writer.getAction();
        this.writer.header();
        this.scan(this.pfc, this.wantRange, null, act, counter);
        this.writer.trailer();
        return this.writer;
    }

    private void scan(PointFeatureCollection collection, CalendarDateRange range, Predicate p, Action a, Limit limit) throws IOException {
        while (collection.hasNext()) {
            CalendarDate obsDate;
            PointFeature pf = collection.next();
            if (range != null && !range.includes(obsDate = pf.getObservationTimeAsCalendarDate())) continue;
            ++limit.count;
            StructureData sdata = pf.getData();
            if (p == null || p.match(sdata)) {
                a.act(pf, sdata);
                ++limit.matches;
            }
            if (limit.matches <= limit.limit) continue;
            collection.finish();
            break;
        }
        collection.finish();
    }

    private void scan(StationTimeSeriesFeatureCollection collection, DateRange range, Predicate p, Action a, Limit limit) throws IOException {
        while (collection.hasNext()) {
            StationTimeSeriesFeature sf = collection.next();
            while (sf.hasNext()) {
                Date obsDate;
                PointFeature pf = sf.next();
                if (range != null && !range.contains(obsDate = pf.getObservationTimeAsDate())) continue;
                ++limit.count;
                StructureData sdata = pf.getData();
                if (p == null || p.match(sdata)) {
                    a.act(pf, sdata);
                    ++limit.matches;
                }
                if (limit.matches <= limit.limit) continue;
                sf.finish();
                break;
            }
            if (limit.matches <= limit.limit) continue;
            collection.finish();
            break;
        }
    }

    class WriterCSV
    extends Writer {
        WriterCSV(PrintWriter writer, SupportedFormat wantFormat) {
            super(writer, wantFormat);
        }

        @Override
        HttpHeaders getHttpHeaders(String pathInfo) {
            HttpHeaders httpHeaders = new HttpHeaders();
            if (!this.isStream) {
                httpHeaders.set("Content-Location", pathInfo);
                httpHeaders.set("Content-Disposition", "attachment; filename=\"" + NcssRequestUtils.nameFromPathInfo(pathInfo) + ".csv\"");
            }
            httpHeaders.set("Content-Type", this.wantFormat.getResponseContentType());
            return httpHeaders;
        }

        @Override
        public void header() {
            this.writer.print("time,station,latitude[unit=\"degrees_north\"],longitude[unit=\"degrees_east\"]");
            for (VariableSimpleIF var : PointWriter.this.wantVars) {
                this.writer.print(",");
                this.writer.print(var.getShortName());
                if (var.getUnitsString() == null) continue;
                this.writer.print("[unit=\"" + var.getUnitsString() + "\"]");
            }
            this.writer.println();
        }

        @Override
        public void trailer() {
            this.writer.flush();
        }

        @Override
        Action getAction() {
            return new Action(){

                @Override
                public void act(PointFeature pf, StructureData sdata) throws IOException {
                    EarthLocation loc = pf.getLocation();
                    WriterCSV.this.writer.print(CalendarDateFormatter.toDateTimeString((CalendarDate)pf.getObservationTimeAsCalendarDate()));
                    WriterCSV.this.writer.print(',');
                    WriterCSV.this.writer.print(Format.dfrac((double)loc.getLatitude(), (int)3));
                    WriterCSV.this.writer.print(',');
                    WriterCSV.this.writer.print(Format.dfrac((double)loc.getLongitude(), (int)3));
                    for (VariableSimpleIF var : PointWriter.this.wantVars) {
                        WriterCSV.this.writer.print(',');
                        Array sdataArray = sdata.getArray(var.getShortName());
                        WriterCSV.this.writer.print(sdataArray.toString());
                    }
                    WriterCSV.this.writer.println();
                    ++WriterCSV.this.count;
                }
            };
        }
    }

    class WriterXML
    extends Writer {
        XMLStreamWriter staxWriter;

        WriterXML(PrintWriter writer, SupportedFormat wantFormat) {
            super(writer, wantFormat);
            XMLOutputFactory f = XMLOutputFactory.newInstance();
            try {
                this.staxWriter = f.createXMLStreamWriter(writer);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e.getMessage());
            }
        }

        @Override
        HttpHeaders getHttpHeaders(String pathInfo) {
            HttpHeaders httpHeaders = new HttpHeaders();
            if (!this.isStream) {
                httpHeaders.set("Content-Location", pathInfo);
                httpHeaders.set("Content-Disposition", "attachment; filename=\"" + NcssRequestUtils.nameFromPathInfo(pathInfo) + ".xml\"");
            }
            httpHeaders.set("Content-Type", this.wantFormat.getResponseContentType());
            return httpHeaders;
        }

        @Override
        public void header() {
            try {
                this.staxWriter.writeStartDocument("UTF-8", "1.0");
                this.staxWriter.writeCharacters("\n");
                this.staxWriter.writeStartElement("stationFeatureCollection");
                this.staxWriter.writeCharacters("\n ");
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e.getMessage());
            }
        }

        @Override
        public void trailer() {
            try {
                this.staxWriter.writeEndElement();
                this.staxWriter.writeCharacters("\n");
                this.staxWriter.writeEndDocument();
                this.staxWriter.close();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e.getMessage());
            }
            this.writer.flush();
        }

        @Override
        Action getAction() {
            return new Action(){

                @Override
                public void act(PointFeature pf, StructureData sdata) throws IOException {
                    EarthLocation loc = pf.getLocation();
                    try {
                        WriterXML.this.staxWriter.writeStartElement("pointFeature");
                        WriterXML.this.staxWriter.writeAttribute("date", CalendarDateFormatter.toDateTimeString((CalendarDate)pf.getObservationTimeAsCalendarDate()));
                        WriterXML.this.staxWriter.writeCharacters("\n  ");
                        WriterXML.this.staxWriter.writeStartElement("location");
                        WriterXML.this.staxWriter.writeAttribute("latitude", Format.dfrac((double)loc.getLatitude(), (int)3));
                        WriterXML.this.staxWriter.writeAttribute("longitude", Format.dfrac((double)loc.getLongitude(), (int)3));
                        if (!Double.isNaN(loc.getAltitude())) {
                            WriterXML.this.staxWriter.writeAttribute("altitude", Format.dfrac((double)loc.getAltitude(), (int)0));
                        }
                        WriterXML.this.staxWriter.writeEndElement();
                        WriterXML.this.staxWriter.writeCharacters("\n ");
                        for (VariableSimpleIF var : PointWriter.this.wantVars) {
                            WriterXML.this.staxWriter.writeCharacters(" ");
                            WriterXML.this.staxWriter.writeStartElement("data");
                            WriterXML.this.staxWriter.writeAttribute("name", var.getShortName());
                            if (var.getUnitsString() != null) {
                                WriterXML.this.staxWriter.writeAttribute("units", var.getUnitsString());
                            }
                            Array sdataArray = sdata.getArray(var.getShortName());
                            String ss = sdataArray.toString();
                            Class elemType = sdataArray.getElementType();
                            if (elemType == String.class || elemType == Character.TYPE || elemType == StructureData.class) {
                                ss = Parse.cleanCharacterData((String)ss);
                            }
                            WriterXML.this.staxWriter.writeCharacters(ss);
                            WriterXML.this.staxWriter.writeEndElement();
                            WriterXML.this.staxWriter.writeCharacters("\n ");
                        }
                        WriterXML.this.staxWriter.writeEndElement();
                        WriterXML.this.staxWriter.writeCharacters("\n");
                        ++WriterXML.this.count;
                    }
                    catch (XMLStreamException e) {
                        throw new RuntimeException(e.getMessage());
                    }
                }
            };
        }
    }

    class WriterRaw
    extends Writer {
        WriterRaw(PrintWriter writer, SupportedFormat wantFormat) {
            super(writer, wantFormat);
        }

        @Override
        public HttpHeaders getHttpHeaders(String pathInfo) {
            return new HttpHeaders();
        }

        @Override
        public void header() {
        }

        @Override
        public void trailer() {
            this.writer.flush();
        }

        @Override
        Action getAction() {
            return new Action(){

                @Override
                public void act(PointFeature pf, StructureData sdata) throws IOException {
                    WriterRaw.this.writer.print(CalendarDateFormatter.toDateTimeString((CalendarDate)pf.getObservationTimeAsCalendarDate()));
                    WriterRaw.this.writer.print("= ");
                    String report = sdata.getScalarString("report");
                    WriterRaw.this.writer.println(report);
                    ++WriterRaw.this.count;
                }
            };
        }
    }

    class WriterNcstream
    extends Writer {
        OutputStream out;

        WriterNcstream(OutputStream os, SupportedFormat wantFormat) throws IOException {
            super(null, wantFormat);
            this.out = os;
        }

        @Override
        public HttpHeaders getHttpHeaders(String pathInfo) {
            return new HttpHeaders();
        }

        @Override
        public void header() {
        }

        @Override
        public void trailer() {
            try {
                PointStream.writeMagic((OutputStream)this.out, (PointStream.MessageType)PointStream.MessageType.End);
                this.out.flush();
            }
            catch (IOException e) {
                log.error("WriterNcstream.trailer", (Throwable)e);
            }
        }

        @Override
        Action getAction() {
            return new Action(){

                @Override
                public void act(PointFeature pf, StructureData sdata) throws IOException {
                    try {
                        byte[] b;
                        if (WriterNcstream.this.count == 0) {
                            PointStreamProto.PointFeatureCollection proto = PointStream.encodePointFeatureCollection((String)PointWriter.this.fd.getLocation(), (PointFeature)pf);
                            b = proto.toByteArray();
                            PointStream.writeMagic((OutputStream)WriterNcstream.this.out, (PointStream.MessageType)PointStream.MessageType.PointFeatureCollection);
                            NcStream.writeVInt((OutputStream)WriterNcstream.this.out, (int)b.length);
                            WriterNcstream.this.out.write(b);
                        }
                        PointStreamProto.PointFeature pfp = PointStream.encodePointFeature((PointFeature)pf);
                        b = pfp.toByteArray();
                        PointStream.writeMagic((OutputStream)WriterNcstream.this.out, (PointStream.MessageType)PointStream.MessageType.PointFeature);
                        NcStream.writeVInt((OutputStream)WriterNcstream.this.out, (int)b.length);
                        WriterNcstream.this.out.write(b);
                        ++WriterNcstream.this.count;
                    }
                    catch (Throwable t) {
                        String mess = t.getMessage();
                        if (mess == null) {
                            mess = t.getClass().getName();
                        }
                        NcStreamProto.Error err = NcStream.encodeErrorMessage((String)t.getMessage());
                        byte[] b = err.toByteArray();
                        PointStream.writeMagic((OutputStream)WriterNcstream.this.out, (PointStream.MessageType)PointStream.MessageType.Error);
                        NcStream.writeVInt((OutputStream)WriterNcstream.this.out, (int)b.length);
                        WriterNcstream.this.out.write(b);
                        throw new IOException(t);
                    }
                }
            };
        }
    }

    class WriterNetcdf
    extends Writer {
        File netcdfResult;
        WriterCFPointCollection cfWriter;
        boolean headerWritten;
        final NetcdfFileWriter.Version version;
        final OutputStream out;

        WriterNetcdf(OutputStream out, SupportedFormat wantFormat) throws IOException {
            super(null, wantFormat);
            this.headerWritten = false;
            this.version = wantFormat == SupportedFormat.NETCDF3 ? NetcdfFileWriter.Version.netcdf3 : NetcdfFileWriter.Version.netcdf4;
            this.out = out;
            this.netcdfResult = PointWriter.this.diskCache.createUniqueFile("ncssTemp", ".nc");
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            atts.add(new Attribute("title", "Extracted data from TDS Feature Collection " + PointWriter.this.fd.getLocation()));
            this.cfWriter = new WriterCFPointCollection(null, this.netcdfResult.getAbsolutePath(), atts);
        }

        @Override
        HttpHeaders getHttpHeaders(String pathInfo) {
            HttpHeaders httpHeaders = new HttpHeaders();
            String fileName = NetCDFPointDataWriter.getFileNameForResponse(this.version, pathInfo);
            String url = NcssRequestUtils.getTdsContext().getContextPath() + NcssController.getServletCachePath() + "/" + fileName;
            httpHeaders.set("Content-Type", this.wantFormat.getResponseContentType());
            httpHeaders.set("Content-Location", url);
            httpHeaders.set("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            return httpHeaders;
        }

        @Override
        public void header() {
        }

        @Override
        public void trailer() {
            if (!this.headerWritten) {
                throw new IllegalStateException("no data was written");
            }
            try {
                this.cfWriter.finish();
            }
            catch (IOException e) {
                log.error("WriterNetcdf.trailer", (Throwable)e);
            }
        }

        @Override
        Action getAction() {
            return new Action(){

                @Override
                public void act(PointFeature pf, StructureData sdata) throws IOException {
                    if (!WriterNetcdf.this.headerWritten) {
                        try {
                            WriterNetcdf.this.cfWriter.writeHeader(PointWriter.this.wantVars, pf.getTimeUnit(), "m");
                            WriterNetcdf.this.headerWritten = true;
                        }
                        catch (IOException e) {
                            log.error("WriterNetcdf.header", (Throwable)e);
                        }
                    }
                    WriterNetcdf.this.cfWriter.writeRecord(pf, sdata);
                    ++WriterNetcdf.this.count;
                }
            };
        }
    }

    public abstract class Writer {
        SupportedFormat wantFormat;
        boolean isStream;
        PrintWriter writer;
        int count = 0;

        abstract void header();

        abstract Action getAction();

        abstract void trailer();

        abstract HttpHeaders getHttpHeaders(String var1);

        Writer(PrintWriter writer, SupportedFormat wantFormat) {
            this.writer = writer;
            this.wantFormat = wantFormat;
            this.isStream = wantFormat.isStream();
        }
    }

    private class Limit {
        int count;
        int limit = Integer.MAX_VALUE;
        int matches;

        private Limit() {
        }
    }

    private static interface Action {
        public void act(PointFeature var1, StructureData var2) throws IOException;
    }

    private static interface Predicate {
        public boolean match(StructureData var1);
    }
}

