/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.gridaspoint;

import java.io.OutputStream;
import thredds.server.ncss.format.SupportedFormat;
import thredds.server.ncss.view.gridaspoint.CSVPointDataWriter;
import thredds.server.ncss.view.gridaspoint.NetCDFPointDataWriter;
import thredds.server.ncss.view.gridaspoint.PointDataWriter;
import thredds.server.ncss.view.gridaspoint.XMLPointDataWriter;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.util.DiskCache2;

public class PointDataWriterFactory {
    public static PointDataWriter factory(SupportedFormat wantFormat, OutputStream outputStream, DiskCache2 diskCache) {
        if (wantFormat == SupportedFormat.XML_FILE || wantFormat == SupportedFormat.XML_STREAM) {
            return XMLPointDataWriter.factory(outputStream);
        }
        if (wantFormat == SupportedFormat.NETCDF3) {
            return NetCDFPointDataWriter.factory(NetcdfFileWriter.Version.netcdf3, outputStream, diskCache);
        }
        if (wantFormat == SupportedFormat.NETCDF4) {
            return NetCDFPointDataWriter.factory(NetcdfFileWriter.Version.netcdf4, outputStream, diskCache);
        }
        if (wantFormat == SupportedFormat.CSV_FILE || wantFormat == SupportedFormat.CSV_STREAM) {
            return CSVPointDataWriter.factory(outputStream);
        }
        throw new IllegalStateException("PointDataWriter does not support " + (Object)((Object)wantFormat));
    }
}

