/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.radarServer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDatasetScan;
import thredds.catalog.ThreddsMetadata;
import thredds.server.AbstractController;
import thredds.server.radarServer.RadarDatasetRepository;
import thredds.server.radarServer.RadarStationController;
import thredds.servlet.HtmlWriter;
import thredds.util.TdsPathUtils;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonRect;

@Controller
@RequestMapping(value={"/radarServer"})
public class RadarCatalogController
extends AbstractController {
    private static Logger log = LoggerFactory.getLogger(RadarCatalogController.class);
    private static final String CREATE_VIEW = "forward:createdataset.htm";
    private static final String MODEL_KEY = "message";
    private static final String MSG_CODE = "message.create.dataset";
    @Autowired
    private RadarDatasetRepository radarDatasetRepository;

    @Override
    protected String getControllerPath() {
        return "/radarServer/";
    }

    @Override
    protected String[] getEndings() {
        return new String[]{"/catalog.xml", "/catalog.html"};
    }

    @RequestMapping(value={"**/catalog.xml", "**/catalog.html", "catalog.xml", "catalog.html"}, method={RequestMethod.GET})
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!RadarStationController.enabled) {
            response.sendError(403, "Service not supported");
            return null;
        }
        String path = TdsPathUtils.extractPath(request, this.getControllerPath());
        if (path == null) {
            path = "";
        }
        InvCatalogImpl catalog = null;
        if (path.contains("level2/catalog.") || path.contains("level3/catalog.") || path.contains("level2/dataset.") || path.contains("level3/dataset.")) {
            catalog = this.level2level3catalog(this.radarDatasetRepository.defaultCat, path);
            if (catalog == null) {
                response.sendError(400, this.getAbsolutePath(request));
                return null;
            }
        } else if (path.endsWith("dataset.xml") || path.endsWith("catalog.xml")) {
            Map<String, Object> model = this.datasetInfoXml(this.radarDatasetRepository.defaultCat, path);
            if (model == null) {
                response.sendError(400, this.getAbsolutePath(request));
                return null;
            }
            return new ModelAndView("datasetXml", model);
        }
        if (catalog == null) {
            ModelAndView mav = new ModelAndView(CREATE_VIEW);
            mav.addObject(MODEL_KEY, (Object)MSG_CODE);
            return mav;
        }
        if (path.endsWith(".html")) {
            HtmlWriter.getInstance().writeCatalog(request, response, catalog, true);
            return null;
        }
        return new ModelAndView("threddsInvCatXmlView", "catalog", (Object)catalog);
    }

    private InvCatalogImpl level2level3catalog(InvCatalogImpl catalog, String pathInfo) throws IOException {
        String dsPath;
        InvCatalogImpl tCat = null;
        if (pathInfo.indexOf("/dataset") > 0) {
            dsPath = pathInfo.substring(0, pathInfo.indexOf("/dataset"));
        } else if (pathInfo.indexOf("/catalog") > 0) {
            dsPath = pathInfo.substring(0, pathInfo.indexOf("/catalog"));
        } else {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(10000);
        InvCatalogFactory factory = InvCatalogFactory.getDefaultFactory((boolean)false);
        factory.writeXML(catalog, (OutputStream)os, true);
        tCat = factory.readXML((InputStream)new ByteArrayInputStream(os.toByteArray()), null);
        Iterator parents = tCat.getDatasets().iterator();
        while (parents.hasNext()) {
            ArrayList<InvDatasetImpl> delete = new ArrayList<InvDatasetImpl>();
            InvDatasetImpl top = (InvDatasetImpl)parents.next();
            for (InvDatasetImpl ds : top.getDatasets()) {
                InvDatasetScan ids;
                if (!(ds instanceof InvDatasetScan) || (ids = (InvDatasetScan)ds).getPath() == null) continue;
                if (ids.getPath().contains(dsPath)) {
                    ids.setXlinkHref(ids.getPath() + "/dataset.xml");
                    continue;
                }
                delete.add(ds);
            }
            for (InvDatasetImpl idi : delete) {
                top.removeDataset(idi);
            }
        }
        return tCat;
    }

    private Map<String, Object> datasetInfoXml(InvCatalogImpl cat, String pathInfo) throws IOException {
        String dsPath;
        HashMap<String, Object> model = new HashMap<String, Object>();
        InvDatasetScan ds = null;
        boolean found = false;
        if (pathInfo.indexOf("/dataset") > 0) {
            dsPath = pathInfo.substring(0, pathInfo.indexOf("/dataset"));
        } else if (pathInfo.indexOf("/catalog") > 0) {
            dsPath = pathInfo.substring(0, pathInfo.indexOf("/catalog"));
        } else {
            return null;
        }
        Iterator parents = cat.getDatasets().iterator();
        InvDatasetImpl top = (InvDatasetImpl)parents.next();
        for (InvDatasetImpl idsi : top.getDatasets()) {
            if (!(idsi instanceof InvDatasetScan) || (ds = (InvDatasetScan)idsi).getPath() == null || !ds.getPath().contains(dsPath)) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        model.put("ID", ds.getID());
        model.put("urlPath", ds.getPath());
        model.put("dataFormat", ds.getDataFormatType());
        model.put("documentation", ds.getSummary());
        CalendarDateRange dr = ds.getCalendarDateCoverage();
        model.put("tstart", dr.getStart().toString());
        model.put("tend", dr.getEnd().toString());
        ThreddsMetadata.GeospatialCoverage gc = ds.getGeospatialCoverage();
        LatLonRect bb = new LatLonRect();
        gc.setBoundingBox(bb);
        model.put("north", gc.getLatNorth());
        model.put("south", gc.getLatSouth());
        model.put("east", gc.getLonEast());
        model.put("west", gc.getLonWest());
        ThreddsMetadata.Variables cvs = (ThreddsMetadata.Variables)ds.getVariables().get(0);
        List vl = cvs.getVariableList();
        ArrayList<RsVar> variables = new ArrayList<RsVar>();
        for (int j = 0; j < vl.size(); ++j) {
            ThreddsMetadata.Variable v = (ThreddsMetadata.Variable)vl.get(j);
            RsVar rsv = new RsVar();
            rsv.setName(v.getName());
            rsv.setVname(v.getVocabularyName());
            rsv.setUnits(v.getUnits());
            variables.add(rsv);
        }
        model.put("variables", variables);
        return model;
    }

    public class RsVar {
        private String name;
        private String vname;
        private String units;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVname() {
            return this.vname;
        }

        public void setVname(String vname) {
            this.vname = vname;
        }

        public String getUnits() {
            return this.units;
        }

        public void setUnits(String units) {
            this.units = units;
        }
    }
}

