/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.servlet.filter.ParameterValidationUtils;

public class CatalogGenFilter
implements Filter {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            this.log.error("doFilter(): Not an HTTP request! How did this filter get here?");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (ParameterValidationUtils.validateParameterAsSingleValueIdString(request, response, "taskName") && ParameterValidationUtils.validateParameterAsSingleValueFilePathString(request, response, "fileName") && ParameterValidationUtils.validateParameterAsSingleValueFilePathString(request, response, "resultFileName") && ParameterValidationUtils.validateParameterAsSingleValueDecimalNumber(request, response, "period") && ParameterValidationUtils.validateParameterAsSingleValueDecimalNumber(request, response, "delay")) {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }
}

