/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpHeaders;
import thredds.server.ncss.controller.GridDatasetResponder;
import thredds.server.ncss.controller.NcssResponder;
import thredds.server.ncss.exception.DateUnitException;
import thredds.server.ncss.exception.OutOfBoundariesException;
import thredds.server.ncss.exception.TimeOutOfWindowException;
import thredds.server.ncss.exception.UnsupportedOperationException;
import thredds.server.ncss.exception.VariableNotContainedInDatasetException;
import thredds.server.ncss.format.SupportedFormat;
import thredds.server.ncss.params.NcssParamsBean;
import thredds.server.ncss.view.gridaspoint.PointDataWriter;
import thredds.server.ncss.view.gridaspoint.PointDataWriterFactory;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.DiskCache2;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionPoint;

public class GridAsPointResponder
extends GridDatasetResponder
implements NcssResponder {
    private DiskCache2 diskCache = null;
    private SupportedFormat format;
    private final PointDataWriter writer;

    public static GridAsPointResponder factory(DiskCache2 diskCache, SupportedFormat format, OutputStream out) {
        return new GridAsPointResponder(diskCache, format, out);
    }

    private GridAsPointResponder(DiskCache2 diskCache, SupportedFormat format, OutputStream out) {
        this.diskCache = diskCache;
        this.format = format;
        this.writer = PointDataWriterFactory.factory(format, out, diskCache);
    }

    @Override
    public void respond(HttpServletResponse res, FeatureDataset fd, String requestPathInfo, NcssParamsBean queryParams, SupportedFormat format) throws IOException, VariableNotContainedInDatasetException, UnsupportedOperationException, OutOfBoundariesException, TimeOutOfWindowException, ParseException, DateUnitException, InvalidRangeException {
        GridDataset gridDataset = (GridDataset)fd;
        LatLonPointImpl point = new LatLonPointImpl(queryParams.getLatitude().doubleValue(), queryParams.getLongitude().doubleValue());
        this.checkRequestedVars(gridDataset, queryParams);
        Map<String, List<String>> groupVars = this.groupVarsByVertLevels(gridDataset, queryParams);
        if (!this.isPointWithinBoundaries(gridDataset, (LatLonPoint)point, groupVars)) {
            throw new OutOfBoundariesException("Requested Lat/Lon Point (+" + point + ") is not contained in the Data. " + "Data Bounding Box = " + gridDataset.getBoundingBox().toString2());
        }
        List<CalendarDate> wantedDates = this.getRequestedDates(gridDataset, queryParams);
        boolean allDone = false;
        ArrayList vars = new ArrayList();
        ArrayList<String> keys = new ArrayList<String>(groupVars.keySet());
        for (String key : keys) {
            vars.addAll(groupVars.get(key));
        }
        Double vertCoord = queryParams.getVertCoord();
        if (this.writer.header(groupVars, (ucar.nc2.dt.GridDataset)gridDataset, wantedDates, this.getTimeDimAtts((ucar.nc2.dt.GridDataset)gridDataset), (LatLonPoint)point, vertCoord)) {
            boolean allPointsRead = this.writer.write(groupVars, (ucar.nc2.dt.GridDataset)gridDataset, wantedDates, (LatLonPoint)point, vertCoord);
            allDone = this.writer.trailer() && allPointsRead;
        }
    }

    private List<Attribute> getTimeDimAtts(ucar.nc2.dt.GridDataset gds) {
        Attribute tLongName;
        Attribute tStdName;
        CoordinateAxis1DTime tAxis = null;
        List ggss = gds.getGridsets();
        Iterator it = ggss.iterator();
        while (tAxis == null && it.hasNext()) {
            GridDataset.Gridset gs = (GridDataset.Gridset)it.next();
            tAxis = gs.getGeoCoordSystem().getTimeAxis1D();
        }
        if (tAxis == null) {
            return null;
        }
        ArrayList<Attribute> timeAtts = new ArrayList<Attribute>();
        String timeUnitString = tAxis.getUnitsString();
        if (tAxis.getDataType() == DataType.STRING && tAxis.getUnitsString().equals("")) {
            CalendarDate startDate = tAxis.getCalendarDate(0);
            timeUnitString = "seconds since " + startDate.toString();
            timeAtts.add(new Attribute("units", timeUnitString));
        } else {
            Attribute tUnits = tAxis.findAttribute("units");
            if (tUnits != null) {
                timeAtts.add(tUnits);
            }
        }
        Attribute tCal = tAxis.findAttribute("calendar");
        if (tCal != null) {
            timeAtts.add(tCal);
        }
        if ((tStdName = tAxis.findAttribute("standard_name")) != null) {
            timeAtts.add(tStdName);
        }
        if ((tLongName = tAxis.findAttribute("long_name")) != null) {
            timeAtts.add(tLongName);
        }
        return timeAtts;
    }

    private boolean isPointWithinBoundaries(GridDataset gridDataset, LatLonPoint point, Map<String, List<String>> groupVars) {
        boolean isInData = true;
        ArrayList<String> keys = new ArrayList<String>(groupVars.keySet());
        int[] xy = new int[2];
        Iterator it = keys.iterator();
        while (it.hasNext() && isInData) {
            ProjectionPoint p;
            String key = (String)it.next();
            GridDatatype grid = gridDataset.findGridDatatype(groupVars.get(key).get(0));
            GridCoordSystem coordSys = grid.getCoordinateSystem();
            xy = coordSys.findXYindexFromCoord((p = coordSys.getProjection().latLonToProj(point)).getX(), p.getY(), null);
            if (xy[0] >= 0 && xy[1] >= 0) continue;
            isInData = false;
        }
        return isInData;
    }

    @Override
    public HttpHeaders getResponseHeaders(FeatureDataset fd, SupportedFormat format, String datasetPath) {
        this.writer.setHTTPHeaders((ucar.nc2.dt.GridDataset)((GridDataset)fd), datasetPath, format.isStream());
        return this.writer.getResponseHeaders();
    }
}

