/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.exception.VariableNotContainedInDatasetException;
import thredds.server.ncss.params.NcssParamsBean;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.units.TimeDuration;
import ucar.nc2.util.DiskCache2;

public class AbstractWriter {
    protected FeatureDatasetPoint fd;
    protected NcssParamsBean qb;
    protected CalendarDate start;
    protected CalendarDate end;
    protected List<VariableSimpleIF> wantVars;
    protected CalendarDateRange wantRange;
    protected DiskCache2 diskCache;

    protected AbstractWriter(FeatureDatasetPoint fd, NcssParamsBean qb, DiskCache2 diskCache) throws IOException, NcssException {
        CalendarDate endR;
        CalendarDate startR;
        this.fd = fd;
        this.qb = qb;
        this.diskCache = diskCache;
        this.start = fd.getCalendarDateStart();
        this.end = fd.getCalendarDateEnd();
        List dataVars = fd.getDataVariables();
        HashMap<String, VariableSimpleIF> dataVarsMap = new HashMap<String, VariableSimpleIF>();
        for (VariableSimpleIF v : dataVars) {
            dataVarsMap.put(v.getShortName(), v);
        }
        List<String> varNames = qb.getVar();
        if (varNames.equals("all")) {
            this.wantVars = new ArrayList<VariableSimpleIF>(dataVars);
        } else {
            ArrayList allVars = new ArrayList(dataVarsMap.keySet());
            this.wantVars = new ArrayList<VariableSimpleIF>();
            for (String v : varNames) {
                if (allVars.contains(v)) {
                    VariableSimpleIF var = (VariableSimpleIF)dataVarsMap.get(v);
                    this.wantVars.add(var);
                    continue;
                }
                throw new VariableNotContainedInDatasetException("Variable: " + v + " is not contained in the requested dataset");
            }
        }
        if (qb.getTime() != null) {
            startR = CalendarDate.parseISOformat(null, (String)qb.getTime());
            startR = startR.subtract(CalendarPeriod.Hour);
            endR = CalendarDate.parseISOformat(null, (String)qb.getTime());
            endR = endR.add(CalendarPeriod.Hour);
            this.wantRange = CalendarDateRange.of((Date)new Date(startR.getMillis()), (Date)new Date(endR.getMillis()));
        } else if (!qb.isAllTimes()) {
            TimeDuration td;
            if (qb.getTime_start() != null && qb.getTime_end() != null) {
                startR = CalendarDate.parseISOformat(null, (String)qb.getTime_start());
                endR = CalendarDate.parseISOformat(null, (String)qb.getTime_end());
                this.wantRange = CalendarDateRange.of((Date)new Date(startR.getMillis()), (Date)new Date(endR.getMillis()));
            } else if (qb.getTime_start() != null && qb.getTime_duration() != null) {
                startR = CalendarDate.parseISOformat(null, (String)qb.getTime_start());
                td = qb.parseTimeDuration();
                this.wantRange = new CalendarDateRange(startR, (long)td.getValueInSeconds());
            } else if (qb.getTime_end() != null && qb.getTime_duration() != null) {
                CalendarDate endR2 = CalendarDate.parseISOformat(null, (String)qb.getTime_end());
                td = qb.parseTimeDuration();
                this.wantRange = new CalendarDateRange(endR2, (long)td.getValueInSeconds() * -1L);
            }
        }
    }
}

