/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.gridaspoint.netcdf;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.ft.point.writer.CFPointWriter;
import ucar.nc2.ft.point.writer.CFPointWriterUtils;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.Station;

class WriterPointCollectionNoTime
extends CFPointWriter {
    private Variable lat;
    private Variable lon;
    private Variable alt;
    private Variable record;
    private int recno = 0;
    private ArrayDouble.D1 latArray = new ArrayDouble.D1(1);
    private ArrayDouble.D1 lonArray = new ArrayDouble.D1(1);
    private ArrayDouble.D1 altArray = new ArrayDouble.D1(1);
    private int[] origin = new int[1];
    private static Logger log = LoggerFactory.getLogger(WriterPointCollectionNoTime.class);

    protected WriterPointCollectionNoTime(NetcdfFileWriter.Version version, String fileOut, List<Attribute> atts) throws IOException {
        super(fileOut, atts, version, false);
    }

    public void writeHeader(List<Station> stns, List<VariableSimpleIF> vars, String altUnits) throws IOException {
        this.altUnits = altUnits;
        this.createCoordinates();
        this.addDataVariablesClassic(vars);
        this.llbb = CFPointWriterUtils.getBoundingBox(stns);
        this.writer.create();
        this.record = this.writer.addRecordStructure();
    }

    private void createCoordinates() {
        this.writer.addUnlimitedDimension("obs");
        this.lat = this.writer.addVariable(null, "latitude", DataType.DOUBLE, "obs");
        this.writer.addVariableAttribute(this.lat, new Attribute("units", "degrees_north"));
        this.writer.addVariableAttribute(this.lat, new Attribute("long_name", "station latitude"));
        this.lon = this.writer.addVariable(null, "longitude", DataType.DOUBLE, "obs");
        this.writer.addVariableAttribute(this.lon, new Attribute("units", "degrees_east"));
        this.writer.addVariableAttribute(this.lon, new Attribute("long_name", "station longitude"));
        if (this.altUnits != null) {
            this.alt = this.writer.addVariable(null, "altitude", DataType.DOUBLE, "obs");
            this.writer.addVariableAttribute(this.alt, new Attribute("units", this.altUnits));
            this.writer.addVariableAttribute(this.alt, new Attribute("long_name", "altitude"));
        }
    }

    protected void addDataVariablesClassic(List<? extends VariableSimpleIF> dataVars) throws IOException {
        List dims;
        HashSet dimSet = new HashSet(20);
        String coordNames = "latitude longitude";
        if (this.altUnits != null) {
            coordNames = coordNames + " " + "altitude";
        }
        for (VariableSimpleIF variableSimpleIF : dataVars) {
            dims = variableSimpleIF.getDimensions();
            dimSet.addAll(dims);
        }
        for (Dimension dimension : dimSet) {
            if (dimension.isUnlimited()) continue;
            this.writer.addDimension(null, dimension.getShortName(), dimension.getLength(), dimension.isShared(), false, dimension.isVariableLength());
        }
        for (VariableSimpleIF variableSimpleIF : dataVars) {
            dims = variableSimpleIF.getDimensions();
            StringBuilder dimNames = new StringBuilder("obs");
            for (Dimension d : dims) {
                if (d.isUnlimited()) continue;
                dimNames.append(" ").append(d.getShortName());
            }
            Variable newVar = this.writer.addVariable(null, variableSimpleIF.getShortName(), variableSimpleIF.getDataType(), dimNames.toString());
            List atts = variableSimpleIF.getAttributes();
            for (Attribute att : atts) {
                newVar.addAttribute(att);
            }
            newVar.addAttribute(new Attribute("coordinates", coordNames));
        }
    }

    public void writeRecord(EarthLocation loc, StructureData sdata) throws IOException {
        ArrayStructureW sArray = new ArrayStructureW(sdata.getStructureMembers(), new int[]{1});
        sArray.setStructureData(sdata, 0);
        this.latArray.set(0, loc.getLatitude());
        this.lonArray.set(0, loc.getLongitude());
        if (this.altUnits != null) {
            this.altArray.set(0, loc.getAltitude());
        }
        this.origin[0] = this.recno;
        try {
            for (StructureMembers.Member m : sdata.getMembers()) {
                if (this.writer.findVariable(m.getName()) == null) continue;
                Array arr = CFPointWriterUtils.getArrayFromMember((Variable)this.writer.findVariable(m.getName()), (StructureMembers.Member)m);
                this.writer.write(this.writer.findVariable(m.getName()), this.origin, arr);
            }
            this.writer.write(this.lat, this.origin, (Array)this.latArray);
            this.writer.write(this.lon, this.origin, (Array)this.lonArray);
            if (this.altUnits != null) {
                this.writer.write(this.alt, this.origin, (Array)this.altArray);
            }
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        ++this.recno;
    }
}

