/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.radarServer;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import thredds.catalog.query.Station;
import thredds.server.config.TdsContext;
import thredds.server.radarServer.DatasetRepository;
import thredds.server.radarServer.RadarServerException;
import thredds.util.TdsPathUtils;
import ucar.unidata.util.Format;

@Controller
public class StationRadarServerController
extends AbstractController {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String MODEL_KEY = "message";
    private static final String MSG_CODE = "message.create.station";
    @Autowired
    private TdsContext tdsContext;

    protected String getControllerPath() {
        return "/radarServer/";
    }

    @RequestMapping(value={"/radarServer/**/stations.xml"}, method={RequestMethod.GET})
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        DatasetRepository.init(this.tdsContext);
        try {
            DatasetRepository.RadarType radarType;
            int pos;
            String path = TdsPathUtils.extractPath(request, this.getControllerPath());
            if (path == null) {
                path = "";
            }
            String type = (pos = path.indexOf("/")) > 0 ? path.substring(0, pos) : "";
            try {
                radarType = DatasetRepository.RadarType.valueOf(type);
            }
            catch (Exception e) {
                response.sendError(400, "Bad radar type=" + type);
                return null;
            }
            HashMap<String, Object> model = new HashMap<String, Object>();
            this.stationsXML(radarType, path, model);
            if (model.size() == 0) {
                return null;
            }
            return new ModelAndView("stationXml", model);
        }
        catch (RadarServerException e) {
            throw e;
        }
        catch (Throwable e) {
            this.log.error("handleRequestInternal(): Problem handling request.", e);
            throw new RadarServerException("handleRequestInternal(): Problem handling request.", e);
        }
    }

    private void stationsXML(DatasetRepository.RadarType radarType, String path, Map<String, Object> model) throws Exception {
        String[] stations = this.stationsDS(radarType, DatasetRepository.dataLocation.get(path));
        if (path.contains("level3") && stations[0].length() == 4) {
            for (int i = 0; i < stations.length; ++i) {
                stations[i] = stations[i].substring(1);
            }
        }
        this.makeStationDocument(stations, radarType, model);
    }

    private String[] stationsDS(DatasetRepository.RadarType radarType, String path) throws Exception {
        Object stations = null;
        if (path != null) {
            File dir = new File(path);
            stations = dir.list();
            if (path.contains("level3")) {
                dir = null;
                if (radarType.equals((Object)DatasetRepository.RadarType.nexrad)) {
                    for (String var : stations) {
                        if (!var.equals("N0R")) continue;
                        dir = new File(path + "/N0R");
                        break;
                    }
                } else if (radarType.equals((Object)DatasetRepository.RadarType.terminal)) {
                    for (String var : stations) {
                        if (!var.equals("TR0")) continue;
                        dir = new File(path + "/TR0");
                        break;
                    }
                }
                stations = dir != null ? dir.list() : null;
            }
        }
        if (stations != null) {
            ArrayList<String> tmp = new ArrayList<String>();
            for (String station : stations) {
                if (station.startsWith(".")) continue;
                tmp.add(station);
            }
            if (((String[])stations).length != tmp.size()) {
                stations = new String[tmp.size()];
                stations = tmp.toArray((T[])stations);
            }
        }
        if (stations == null || (stations).length == 0) {
            if (stations == null) {
                stations = new String[1];
            }
            stations = radarType.equals((Object)DatasetRepository.RadarType.nexrad) ? DatasetRepository.nexradMap.keySet().toArray((T[])stations) : DatasetRepository.terminalMap.keySet().toArray((T[])stations);
        }
        return stations;
    }

    private void makeStationDocument(String[] stations, DatasetRepository.RadarType radarType, Map<String, Object> model) throws Exception {
        ArrayList<StationEntry> entries = new ArrayList<StationEntry>();
        for (String s : stations) {
            Station stn = this.getStation(s, radarType);
            StationEntry se = new StationEntry();
            if (stn == null) {
                se.setId(s);
                se.setState("XXX");
                se.setCountry("XX");
                se.setName("Unknown");
                se.setLongitude("0.0");
                se.setLatitude("0.0");
                se.setElevation("0.0");
                continue;
            }
            se.setId(s);
            if (stn.getState() != null) {
                se.setState(stn.getState());
            }
            if (stn.getCountry() != null) {
                se.setCountry(stn.getCountry());
            }
            if (stn.getName() != null) {
                se.setName(stn.getName());
            }
            se.setLongitude(Format.d((double)stn.getLocation().getLongitude(), (int)6));
            se.setLatitude(Format.d((double)stn.getLocation().getLatitude(), (int)6));
            if (!Double.isNaN(stn.getLocation().getElevation())) {
                se.setElevation(Format.d((double)stn.getLocation().getElevation(), (int)6));
            }
            entries.add(se);
        }
        model.put("stations", entries);
    }

    public Station getStation(String station, DatasetRepository.RadarType radarType) {
        Station stn = null;
        if (station.length() == 3 && radarType.equals((Object)DatasetRepository.RadarType.terminal)) {
            stn = DatasetRepository.terminalMap.get("T" + station);
        } else if (station.length() == 3) {
            for (Station stn3 : DatasetRepository.nexradList) {
                if (!stn3.getValue().endsWith(station)) continue;
                stn = stn3;
                break;
            }
        } else {
            stn = radarType.equals((Object)DatasetRepository.RadarType.terminal) ? DatasetRepository.terminalMap.get(station) : DatasetRepository.nexradMap.get(station);
        }
        return stn;
    }

    public class StationEntry {
        private String id;
        private String state;
        private String country;
        private String name;
        private String longitude;
        private String latitude;
        private String elevation;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }

        public String getCountry() {
            return this.country;
        }

        public void setCountry(String country) {
            this.country = country;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLongitude() {
            return this.longitude;
        }

        public void setLongitude(String longitude) {
            this.longitude = longitude;
        }

        public String getLatitude() {
            return this.latitude;
        }

        public void setLatitude(String latitude) {
            this.latitude = latitude;
        }

        public String getElevation() {
            return this.elevation;
        }

        public void setElevation(String elevation) {
            this.elevation = elevation;
        }
    }
}

