/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.viewer.dataservice;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import thredds.catalog.InvAccess;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvProperty;
import thredds.catalog.ServiceType;
import thredds.server.viewer.dataservice.ViewerService;
import thredds.server.wms.Godiva2Viewer;
import thredds.servlet.Viewer;
import thredds.servlet.ViewerLinkProvider;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.util.IO;
import ucar.unidata.util.StringUtil2;

@Service
public class ViewerServiceImpl
implements ViewerService {
    private static Logger logger = LoggerFactory.getLogger(ViewerServiceImpl.class);
    private List<Viewer> viewers = new ArrayList<Viewer>();
    private HashMap<String, String> templates = new HashMap();

    public static ViewerLinkProvider getStaticView() {
        return new StaticView();
    }

    @Override
    public List<Viewer> getViewers() {
        return null;
    }

    @Override
    public Viewer getViewer(String viewer) {
        return null;
    }

    @Override
    public boolean registerViewer(Viewer v) {
        return this.viewers.add(v);
    }

    @Override
    public String getViewerTemplate(String path) {
        String template = this.templates.get(path);
        if (template != null) {
            return template;
        }
        try {
            template = IO.readFile((String)path);
        }
        catch (IOException ioe) {
            return null;
        }
        this.templates.put(path, template);
        return template;
    }

    @Override
    public void showViewers(StringBuilder sbuff, InvDatasetImpl dataset, HttpServletRequest req) {
        int count = 0;
        for (Viewer viewer : this.viewers) {
            if (!viewer.isViewable(dataset)) continue;
            ++count;
        }
        if (count == 0) {
            return;
        }
        sbuff.append("<h3>Viewers:</h3><ul>\r\n");
        for (Viewer viewer : this.viewers) {
            if (!viewer.isViewable(dataset)) continue;
            if (viewer instanceof ViewerLinkProvider) {
                List<ViewerLinkProvider.ViewerLink> sp = ((ViewerLinkProvider)viewer).getViewerLinks(dataset, req);
                for (ViewerLinkProvider.ViewerLink vl : sp) {
                    if (!(vl.getUrl() != null & !vl.getUrl().equals(""))) continue;
                    sbuff.append("<li><a href='").append(vl.getUrl()).append("'>").append(vl.getTitle() != null ? vl.getTitle() : vl.getUrl()).append("</a></li>\n");
                }
                continue;
            }
            String viewerLinkHtml = viewer.getViewerLinkHtml(dataset, req);
            if (viewerLinkHtml == null) continue;
            sbuff.append("  <li> ");
            sbuff.append(viewerLinkHtml);
            sbuff.append("</li>\n");
        }
        sbuff.append("</ul>\r\n");
    }

    @PostConstruct
    private void registerViewers() {
        this.registerViewer(new Godiva2Viewer());
        this.registerViewer(new ToolsUI());
        this.registerViewer(new IDV());
        this.registerViewer(new StaticView());
    }

    private static class StaticView
    implements ViewerLinkProvider {
        private final String propertyNamePrefix = "viewer";

        private StaticView() {
        }

        @Override
        public boolean isViewable(InvDatasetImpl ds) {
            return this.hasViewerProperties(ds);
        }

        @Override
        public String getViewerLinkHtml(InvDatasetImpl ds, HttpServletRequest req) {
            List<ViewerLinkProvider.ViewerLink> viewerLinks = this.getViewerLinks(ds, req);
            if (viewerLinks.isEmpty()) {
                return null;
            }
            ViewerLinkProvider.ViewerLink firstLink = viewerLinks.get(0);
            return "<a href='" + firstLink.getUrl() + "'>" + firstLink.getTitle() + "</a>";
        }

        @Override
        public List<ViewerLinkProvider.ViewerLink> getViewerLinks(InvDatasetImpl ds, HttpServletRequest req) {
            List<InvProperty> viewerProperties = this.findViewerProperties(ds);
            if (viewerProperties.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<ViewerLinkProvider.ViewerLink> result = new ArrayList<ViewerLinkProvider.ViewerLink>();
            for (InvProperty p : viewerProperties) {
                ViewerLinkProvider.ViewerLink viewerLink = this.parseViewerPropertyValue(p.getName(), p.getValue(), ds, req);
                if (viewerLink == null) continue;
                result.add(viewerLink);
            }
            return result;
        }

        private ViewerLinkProvider.ViewerLink parseViewerPropertyValue(String viewerName, String viewerValue, InvDatasetImpl ds, HttpServletRequest req) {
            String viewerTitle;
            String viewerUrl;
            int lastCommaLocation = viewerValue.lastIndexOf(",");
            if (lastCommaLocation != -1) {
                viewerUrl = viewerValue.substring(0, lastCommaLocation);
                viewerTitle = viewerValue.substring(lastCommaLocation + 1);
                if (viewerUrl.equals("")) {
                    return null;
                }
                if (viewerTitle.equals("")) {
                    viewerTitle = viewerName;
                }
            } else {
                viewerUrl = viewerValue;
                viewerTitle = viewerName;
            }
            viewerUrl = StringUtil2.quoteHtmlContent((String)this.sub(viewerUrl, ds, req));
            ViewerLinkProvider.ViewerLink viewerLink = new ViewerLinkProvider.ViewerLink(viewerTitle, viewerUrl);
            return viewerLink;
        }

        private boolean hasViewerProperties(InvDatasetImpl ds) {
            for (InvProperty p : ds.getProperties()) {
                if (!p.getName().startsWith("viewer")) continue;
                return true;
            }
            return false;
        }

        private List<InvProperty> findViewerProperties(InvDatasetImpl ds) {
            ArrayList<InvProperty> result = new ArrayList<InvProperty>();
            for (InvProperty p : ds.getProperties()) {
                if (!p.getName().startsWith("viewer")) continue;
                result.add(p);
            }
            return result;
        }

        private String sub(String org, InvDatasetImpl ds, HttpServletRequest req) {
            List access = ds.getAccess();
            if (access.size() == 0) {
                return org;
            }
            for (InvAccess acc : access) {
                String sname = "{" + acc.getService().getServiceType() + "}";
                if (org.indexOf(sname) < 0) continue;
                return StringUtil2.substitute((String)org, (String)sname, (String)acc.getStandardUri().toString());
            }
            String sname = "{url}";
            if (org.indexOf(sname) >= 0 && access.size() > 0) {
                InvAccess acc;
                acc = (InvAccess)access.get(0);
                return StringUtil2.substitute((String)org, (String)sname, (String)acc.getStandardUri().toString());
            }
            return org;
        }
    }

    private static class IDV
    implements Viewer {
        private IDV() {
        }

        @Override
        public boolean isViewable(InvDatasetImpl ds) {
            InvAccess access = this.getOpendapAccess(ds);
            if (access == null) {
                return false;
            }
            FeatureType dt = ds.getDataType();
            return dt == FeatureType.GRID;
        }

        @Override
        public String getViewerLinkHtml(InvDatasetImpl ds, HttpServletRequest req) {
            InvAccess access = this.getOpendapAccess(ds);
            URI dataURI = access.getStandardUri();
            if (dataURI == null) {
                logger.warn("IDVViewer access URL failed on {}", (Object)ds.getName());
                return null;
            }
            if (!dataURI.isAbsolute()) {
                try {
                    URI base = new URI(req.getRequestURL().toString());
                    dataURI = base.resolve(dataURI);
                }
                catch (URISyntaxException e) {
                    logger.error("Resolve URL with " + req.getRequestURL(), (Throwable)e);
                }
            }
            return "<a href='" + req.getContextPath() + "/view/idv.jnlp?url=" + dataURI.toString() + "'>Integrated Data Viewer (IDV) (webstart)</a>";
        }

        private InvAccess getOpendapAccess(InvDatasetImpl ds) {
            InvAccess access = ds.getAccess(ServiceType.DODS);
            if (access == null) {
                access = ds.getAccess(ServiceType.OPENDAP);
            }
            return access;
        }
    }

    private static class ToolsUI
    implements Viewer {
        private ToolsUI() {
        }

        @Override
        public boolean isViewable(InvDatasetImpl ds) {
            String id = ds.getID();
            return id != null && ds.hasAccess();
        }

        @Override
        public String getViewerLinkHtml(InvDatasetImpl ds, HttpServletRequest req) {
            String base = ds.getParentCatalog().getUriString();
            if (base.endsWith(".html")) {
                base = base.substring(0, base.length() - 5) + ".xml";
            }
            Formatter query = new Formatter();
            query.format("<a href='%s/view/ToolsUI.jnlp?", req.getContextPath());
            query.format("catalog=%s&amp;dataset=%s'>NetCDF-Java ToolsUI (webstart)</a>", base, ds.getID());
            return query.toString();
        }
    }
}

