/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.servlet.AbstractServlet;
import thredds.servlet.Annotation;
import thredds.servlet.Debug;
import thredds.servlet.ServletUtil;
import thredds.util.ContentType;
import ucar.nc2.util.IO;

public class AnnotateServlet
extends AbstractServlet {
    @Override
    protected String getPath() {
        return "views/";
    }

    protected void makeDebugActions() {
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            String datasetID;
            String catURL;
            boolean isDefaultCatalog;
            if (Debug.isSet("showRequest")) {
                this.log.debug("**CatalogAnnotate req=" + ServletUtil.getRequest(req));
            }
            if (Debug.isSet("showRequestDetail")) {
                this.log.debug(ServletUtil.showRequestDetail(this, req));
            }
            boolean bl = isDefaultCatalog = (catURL = req.getParameter("catalog")) == null || catURL.length() == 0;
            if (isDefaultCatalog) {
                String reqBase = ServletUtil.getRequestBase(req);
                URI reqURI = new URI(reqBase);
                URI catURI = reqURI.resolve("catalog.xml");
                catURL = catURI.toString();
            }
            if (Debug.isSet("showCatalog")) {
                this.log.debug("CatalogServices: catalog = " + catURL);
            }
            if ((datasetID = req.getParameter("dataset")) == null) {
                this.log.error("CatalogAnnotate: must have dataset query parameter" + ServletUtil.getRequest(req));
                res.sendError(400, "must have dataset query parameter");
                return;
            }
            if (Debug.isSet("showCatalog")) {
                this.log.debug("CatalogAnnotate: dataset = " + datasetID);
            }
            res.setStatus(200);
            res.setContentType(ContentType.html.getContentHeader());
            PrintWriter pw = new PrintWriter((OutputStream)res.getOutputStream());
            pw.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n");
            pw.println("        \"http://www.w3.org/TR/html4/loose.dtd\">\n");
            pw.println("<html>\n");
            pw.println("<head>");
            pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
            pw.println("</head>");
            pw.println("<body bgcolor=\"#FFF0FF\">");
            pw.println("<img src='/thredds/thredds.jpg' >");
            pw.println("<h2> Catalog (" + catURL + ")</h2>");
            pw.println("<h3> Dataset (" + datasetID + ")</h3><ul>");
            List<Annotation> views = Annotation.findAnnotation(catURL, datasetID, "IDV");
            for (Annotation v : views) {
                String href = this.getPath() + v.jnlpFilename;
                pw.println("<li> <a href='" + href + "'>" + v.title + "</a> " + v.desc);
            }
            pw.println("</ul></body></html>");
            pw.flush();
        }
        catch (Throwable t) {
            this.log.error("doGet req= " + ServletUtil.getRequest(req) + " got Exception", t);
            ServletUtil.handleException(t, res);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            String datasetID;
            String catURL;
            boolean isDefaultCatalog;
            if (Debug.isSet("showRequest")) {
                this.log.debug("**CatalogAnnotate post=" + ServletUtil.getRequest(req));
            }
            if (Debug.isSet("showRequestDetail")) {
                this.log.debug(ServletUtil.showRequestDetail(this, req));
            }
            boolean bl = isDefaultCatalog = (catURL = req.getParameter("catalog")) == null || catURL.length() == 0;
            if (isDefaultCatalog) {
                String reqBase = ServletUtil.getRequestBase(req);
                URI reqURI = new URI(reqBase);
                URI catURI = reqURI.resolve("catalog.xml");
                catURL = catURI.toString();
            }
            if (Debug.isSet("showCatalog")) {
                this.log.debug("CatalogServices: catalog = " + catURL);
            }
            if ((datasetID = req.getParameter("dataset")) == null) {
                this.log.error("CatalogAnnotate: must have dataset query parameter" + ServletUtil.getRequest(req));
                res.sendError(400, "must have dataset query parameter");
                return;
            }
            if (Debug.isSet("showCatalog")) {
                this.log.debug("CatalogAnnotate: dataset = " + datasetID);
            }
            InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory((boolean)true);
            try {
                InvCatalogImpl catalog = catFactory.readXML(catURL);
            }
            catch (Exception e) {
                ServletUtil.handleException(e, res);
                return;
            }
            PrintWriter pw = new PrintWriter((OutputStream)res.getOutputStream());
            String jnlpString = req.getParameter("jnlp");
            File dir = new File(this.contentPath);
            try {
                File jnlpFile = File.createTempFile("IDV", ".jnlp", dir);
                IO.writeToFile((String)jnlpString, (File)jnlpFile);
                String title = req.getParameter("title");
                String desc = req.getParameter("description");
                Annotation.add(new Annotation(catURL, datasetID, title, desc, jnlpFile.getName(), "IDV"));
                res.setStatus(200);
                pw.println("\nOK");
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                res.sendError(500, "ERROR= " + ioe);
            }
            pw.flush();
        }
        catch (Throwable t) {
            this.log.error("doPost req= " + ServletUtil.getRequest(req) + " got Exception", t);
            ServletUtil.handleException(t, res);
        }
    }
}

