/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cdmremote;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.cdmremote.StationWriter;
import thredds.server.cdmremote.params.CdmrfQueryBean;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.remote.PointStream;
import ucar.nc2.ft.point.remote.PointStreamProto;
import ucar.nc2.ft.point.writer.WriterCFPointCollection;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamProto;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.units.DateRange;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.xml.Parse;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.util.Format;

public class PointWriter {
    private static Logger log = LoggerFactory.getLogger(StationWriter.class);
    private static final boolean debug = false;
    private static final boolean debugDetail = false;
    private final FeatureDatasetPoint fd;
    private final CdmrfQueryBean qb;
    private PointFeatureCollection pfc;
    private LatLonRect wantBB;
    private DateRange wantRange;
    private List<VariableSimpleIF> wantVars;
    private DiskCache2 diskCache;

    public PointWriter(FeatureDatasetPoint fd, PointFeatureCollection pfc, CdmrfQueryBean qb, DiskCache2 diskCache) throws IOException {
        this.fd = fd;
        this.pfc = pfc;
        this.qb = qb;
        this.diskCache = diskCache;
    }

    public boolean validate(HttpServletResponse res) throws IOException {
        List<String> varNames;
        if (this.qb.getTemporalSelection() == CdmrfQueryBean.TemporalSelection.range) {
            this.wantRange = this.qb.getDateRange();
            DateRange haveRange = this.fd.getDateRange();
            if (!haveRange.intersects(this.wantRange)) {
                res.sendError(400, "ERROR: This dataset does not include the requested time range= " + this.wantRange + "\ndataset time range = " + haveRange);
                return false;
            }
        }
        List dataVars = this.fd.getDataVariables();
        String[] vars = this.qb.getVarNames();
        List<String> list = varNames = vars == null ? null : Arrays.asList(vars);
        if (varNames == null || varNames.size() == 0) {
            this.wantVars = new ArrayList<VariableSimpleIF>(dataVars);
        } else {
            this.wantVars = new ArrayList<VariableSimpleIF>();
            for (VariableSimpleIF v : dataVars) {
                if (!varNames.contains(v.getShortName())) continue;
                this.wantVars.add(v);
            }
            if (this.wantVars.size() == 0) {
                res.sendError(400, "ERROR: This dataset does not include the requested variables= " + this.qb.getVar());
                return false;
            }
        }
        if (this.qb.getSpatialSelection() == CdmrfQueryBean.SpatialSelection.bb) {
            this.wantBB = this.qb.getLatLonRect();
            LatLonRect haveBB = this.pfc.getBoundingBox();
            if (this.wantBB != null && haveBB != null && this.wantBB.intersect(haveBB) == null) {
                res.sendError(400, "ERROR: This dataset does not include the requested bb= " + this.wantBB);
                return false;
            }
        }
        this.pfc = this.wantBB != null || this.wantRange != null ? this.pfc.subset(this.wantBB, this.wantRange) : this.pfc;
        return true;
    }

    public File writeNetcdf() throws IOException {
        WriterNetcdf w = (WriterNetcdf)this.write(null);
        return w.netcdfResult;
    }

    public Writer write(HttpServletResponse res) throws IOException {
        Writer w;
        long start = System.currentTimeMillis();
        Limit counter = new Limit();
        CdmrfQueryBean.ResponseType resType = this.qb.getResponseType();
        if (resType == CdmrfQueryBean.ResponseType.xml) {
            w = new WriterXML(res.getWriter());
        } else if (resType == CdmrfQueryBean.ResponseType.csv) {
            w = new WriterCSV(res.getWriter());
        } else if (resType == CdmrfQueryBean.ResponseType.netcdf) {
            w = new WriterNetcdf();
        } else if (resType == CdmrfQueryBean.ResponseType.ncstream) {
            w = new WriterNcstream((OutputStream)res.getOutputStream());
        } else {
            log.error("Unknown result type = " + (Object)((Object)resType));
            return null;
        }
        Action act = w.getAction();
        w.header();
        this.scan(this.pfc, this.wantRange, null, act, counter);
        w.trailer();
        return w;
    }

    private void scan(PointFeatureCollection collection, DateRange range, Predicate p, Action a, Limit limit) throws IOException {
        collection.resetIteration();
        while (collection.hasNext()) {
            Date obsDate;
            PointFeature pf = collection.next();
            if (range != null && !range.contains(obsDate = pf.getObservationTimeAsDate())) continue;
            ++limit.count;
            StructureData sdata = pf.getDataAll();
            if (p == null || p.match(sdata)) {
                a.act(pf, sdata);
                ++limit.matches;
            }
            if (limit.matches <= limit.limit) continue;
            collection.finish();
            break;
        }
        collection.finish();
    }

    private void scan(StationTimeSeriesFeatureCollection collection, DateRange range, Predicate p, Action a, Limit limit) throws IOException {
        while (collection.hasNext()) {
            StationTimeSeriesFeature sf = collection.next();
            while (sf.hasNext()) {
                Date obsDate;
                PointFeature pf = sf.next();
                if (range != null && !range.contains(obsDate = pf.getObservationTimeAsDate())) continue;
                ++limit.count;
                StructureData sdata = pf.getData();
                if (p == null || p.match(sdata)) {
                    a.act(pf, sdata);
                    ++limit.matches;
                }
                if (limit.matches <= limit.limit) continue;
                sf.finish();
                break;
            }
            if (limit.matches <= limit.limit) continue;
            collection.finish();
            break;
        }
    }

    public static void main(String[] args) throws IOException {
    }

    class WriterCSV
    extends Writer {
        WriterCSV(PrintWriter writer) {
            super(writer);
        }

        @Override
        public void header() {
            this.writer.print("time,station,latitude[unit=\"degrees_north\"],longitude[unit=\"degrees_east\"]");
            for (VariableSimpleIF var : PointWriter.this.wantVars) {
                this.writer.print(",");
                this.writer.print(var.getShortName());
                if (var.getUnitsString() == null) continue;
                this.writer.print("[unit=\"" + var.getUnitsString() + "\"]");
            }
            this.writer.println();
        }

        @Override
        public void trailer() {
            this.writer.flush();
        }

        @Override
        Action getAction() {
            return new Action(){

                @Override
                public void act(PointFeature pf, StructureData sdata) throws IOException {
                    EarthLocation loc = pf.getLocation();
                    WriterCSV.this.writer.print(CalendarDateFormatter.toDateTimeString((CalendarDate)pf.getObservationTimeAsCalendarDate()));
                    WriterCSV.this.writer.print(',');
                    WriterCSV.this.writer.print(Format.dfrac((double)loc.getLatitude(), (int)3));
                    WriterCSV.this.writer.print(',');
                    WriterCSV.this.writer.print(Format.dfrac((double)loc.getLongitude(), (int)3));
                    for (VariableSimpleIF var : PointWriter.this.wantVars) {
                        WriterCSV.this.writer.print(',');
                        Array sdataArray = sdata.getArray(var.getShortName());
                        WriterCSV.this.writer.print(sdataArray.toString());
                    }
                    WriterCSV.this.writer.println();
                    ++WriterCSV.this.count;
                }
            };
        }
    }

    class WriterXML
    extends Writer {
        XMLStreamWriter staxWriter;

        WriterXML(PrintWriter writer) {
            super(writer);
            XMLOutputFactory f = XMLOutputFactory.newInstance();
            try {
                this.staxWriter = f.createXMLStreamWriter(writer);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e.getMessage());
            }
        }

        @Override
        public void header() {
            try {
                this.staxWriter.writeStartDocument("UTF-8", "1.0");
                this.staxWriter.writeCharacters("\n");
                this.staxWriter.writeStartElement("stationFeatureCollection");
                this.staxWriter.writeCharacters("\n ");
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e.getMessage());
            }
        }

        @Override
        public void trailer() {
            try {
                this.staxWriter.writeEndElement();
                this.staxWriter.writeCharacters("\n");
                this.staxWriter.writeEndDocument();
                this.staxWriter.close();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e.getMessage());
            }
            this.writer.flush();
        }

        @Override
        Action getAction() {
            return new Action(){

                @Override
                public void act(PointFeature pf, StructureData sdata) throws IOException {
                    EarthLocation loc = pf.getLocation();
                    try {
                        WriterXML.this.staxWriter.writeStartElement("pointFeature");
                        WriterXML.this.staxWriter.writeAttribute("date", CalendarDateFormatter.toDateTimeString((CalendarDate)pf.getObservationTimeAsCalendarDate()));
                        WriterXML.this.staxWriter.writeCharacters("\n  ");
                        WriterXML.this.staxWriter.writeStartElement("location");
                        WriterXML.this.staxWriter.writeAttribute("latitude", Format.dfrac((double)loc.getLatitude(), (int)3));
                        WriterXML.this.staxWriter.writeAttribute("longitude", Format.dfrac((double)loc.getLongitude(), (int)3));
                        if (!Double.isNaN(loc.getAltitude())) {
                            WriterXML.this.staxWriter.writeAttribute("altitude", Format.dfrac((double)loc.getAltitude(), (int)0));
                        }
                        WriterXML.this.staxWriter.writeEndElement();
                        WriterXML.this.staxWriter.writeCharacters("\n ");
                        for (VariableSimpleIF var : PointWriter.this.wantVars) {
                            WriterXML.this.staxWriter.writeCharacters(" ");
                            WriterXML.this.staxWriter.writeStartElement("data");
                            WriterXML.this.staxWriter.writeAttribute("name", var.getShortName());
                            if (var.getUnitsString() != null) {
                                WriterXML.this.staxWriter.writeAttribute("units", var.getUnitsString());
                            }
                            Array sdataArray = sdata.getArray(var.getShortName());
                            String ss = sdataArray.toString();
                            Class elemType = sdataArray.getElementType();
                            if (elemType == String.class || elemType == Character.TYPE || elemType == StructureData.class) {
                                ss = Parse.cleanCharacterData((String)ss);
                            }
                            WriterXML.this.staxWriter.writeCharacters(ss);
                            WriterXML.this.staxWriter.writeEndElement();
                            WriterXML.this.staxWriter.writeCharacters("\n ");
                        }
                        WriterXML.this.staxWriter.writeEndElement();
                        WriterXML.this.staxWriter.writeCharacters("\n");
                        ++WriterXML.this.count;
                    }
                    catch (XMLStreamException e) {
                        throw new RuntimeException(e.getMessage());
                    }
                }
            };
        }
    }

    class WriterRaw
    extends Writer {
        WriterRaw(PrintWriter writer) {
            super(writer);
        }

        @Override
        public void header() {
        }

        @Override
        public void trailer() {
            this.writer.flush();
        }

        @Override
        Action getAction() {
            return new Action(){

                @Override
                public void act(PointFeature pf, StructureData sdata) throws IOException {
                    WriterRaw.this.writer.print(CalendarDateFormatter.toDateTimeString((CalendarDate)pf.getObservationTimeAsCalendarDate()));
                    WriterRaw.this.writer.print("= ");
                    String report = sdata.getScalarString("report");
                    WriterRaw.this.writer.println(report);
                    ++WriterRaw.this.count;
                }
            };
        }
    }

    class WriterNcstream
    extends Writer {
        OutputStream out;

        WriterNcstream(OutputStream os) throws IOException {
            super(null);
            this.out = os;
        }

        @Override
        public void header() {
        }

        @Override
        public void trailer() {
            try {
                PointStream.writeMagic((OutputStream)this.out, (PointStream.MessageType)PointStream.MessageType.End);
                this.out.flush();
            }
            catch (IOException e) {
                log.error("WriterNcstream.trailer", (Throwable)e);
            }
        }

        @Override
        Action getAction() {
            return new Action(){

                @Override
                public void act(PointFeature pf, StructureData sdata) throws IOException {
                    try {
                        byte[] b;
                        if (WriterNcstream.this.count == 0) {
                            PointStreamProto.PointFeatureCollection proto = PointStream.encodePointFeatureCollection((String)PointWriter.this.fd.getLocation(), (String)PointWriter.this.pfc.getTimeUnit().getTimeUnitString(), (PointFeature)pf);
                            b = proto.toByteArray();
                            PointStream.writeMagic((OutputStream)WriterNcstream.this.out, (PointStream.MessageType)PointStream.MessageType.PointFeatureCollection);
                            NcStream.writeVInt((OutputStream)WriterNcstream.this.out, (int)b.length);
                            WriterNcstream.this.out.write(b);
                        }
                        PointStreamProto.PointFeature pfp = PointStream.encodePointFeature((PointFeature)pf);
                        b = pfp.toByteArray();
                        PointStream.writeMagic((OutputStream)WriterNcstream.this.out, (PointStream.MessageType)PointStream.MessageType.PointFeature);
                        NcStream.writeVInt((OutputStream)WriterNcstream.this.out, (int)b.length);
                        WriterNcstream.this.out.write(b);
                        ++WriterNcstream.this.count;
                    }
                    catch (Throwable t) {
                        String mess = t.getMessage();
                        if (mess == null) {
                            mess = t.getClass().getName();
                        }
                        NcStreamProto.Error err = NcStream.encodeErrorMessage((String)t.getMessage());
                        byte[] b = err.toByteArray();
                        PointStream.writeMagic((OutputStream)WriterNcstream.this.out, (PointStream.MessageType)PointStream.MessageType.Error);
                        NcStream.writeVInt((OutputStream)WriterNcstream.this.out, (int)b.length);
                        WriterNcstream.this.out.write(b);
                        throw new IOException(t);
                    }
                }
            };
        }
    }

    class WriterNetcdf
    extends Writer {
        File netcdfResult;
        WriterCFPointCollection cfWriter;
        boolean headerWritten;

        WriterNetcdf() throws IOException {
            super(null);
            this.headerWritten = false;
            this.netcdfResult = PointWriter.this.diskCache.createUniqueFile("CdmrFeature", ".nc");
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            atts.add(new Attribute("title", "Extracted data from TDS Feature Collection " + PointWriter.this.fd.getLocation()));
            this.cfWriter = null;
        }

        @Override
        public void header() {
        }

        @Override
        public void trailer() {
            try {
                this.cfWriter.finish();
            }
            catch (IOException e) {
                log.error("WriterNetcdf.trailer", (Throwable)e);
            }
        }

        @Override
        Action getAction() {
            return new Action(){

                @Override
                public void act(PointFeature pf, StructureData sdata) throws IOException {
                    if (!WriterNetcdf.this.headerWritten) {
                        try {
                            WriterNetcdf.this.cfWriter.writeHeader(pf);
                            WriterNetcdf.this.headerWritten = true;
                        }
                        catch (IOException e) {
                            log.error("WriterNetcdf.header", (Throwable)e);
                        }
                    }
                    WriterNetcdf.this.cfWriter.writeRecord(pf, sdata);
                    ++WriterNetcdf.this.count;
                }
            };
        }
    }

    public abstract class Writer {
        PrintWriter writer;
        int count = 0;

        abstract void header();

        abstract Action getAction();

        abstract void trailer();

        Writer(PrintWriter writer) {
            this.writer = writer;
        }
    }

    private class Limit {
        int count;
        int limit = Integer.MAX_VALUE;
        int matches;

        private Limit() {
        }
    }

    private static interface Action {
        public void act(PointFeature var1, StructureData var2) throws IOException;
    }

    private static interface Predicate {
        public boolean match(StructureData var1);
    }
}

