/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.format;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import thredds.util.ContentType;

public enum SupportedFormat {
    CSV_STREAM("csv", true, ContentType.csv.toString(), "csv"),
    CSV_FILE("csv_file", false, ContentType.csv.toString(), "csv_file"),
    XML_STREAM("xml", true, ContentType.xml.toString(), "xml"),
    XML_FILE("xml_file", false, ContentType.xml.toString(), "xml_file"),
    NETCDF3("netcdf", false, ContentType.netcdf.toString(), "netcdf"),
    NETCDF4("netcdf4", false, ContentType.netcdf4.toString(), "netcdf4"),
    JSON("json", false, ContentType.json.toString(), "json", "geojson"),
    WKT("wkt", false, ContentType.text.toString(), "wkt"),
    WATERML2("waterml2", true, ContentType.xml.toString(), "waterml2");

    private final List<String> aliases;
    private final String formatName;
    private final boolean isStream;

    private SupportedFormat(String formatName, boolean isStream, String ... aliases) {
        this.formatName = formatName;
        this.isStream = isStream;
        ArrayList aliasesList = new ArrayList();
        Collections.addAll(aliasesList, aliases);
        this.aliases = Collections.unmodifiableList(aliasesList);
    }

    public String getFormatName() {
        return this.formatName;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public boolean isAlias(String want) {
        for (String have : this.aliases) {
            if (!have.equalsIgnoreCase(want)) continue;
            return true;
        }
        return false;
    }

    public String getResponseContentType() {
        return this.aliases.get(0);
    }

    public boolean isStream() {
        return this.isStream;
    }

    public boolean isBinary() {
        return this.formatName.equals("netcdf") || this.formatName.equals("netcdf4");
    }

    public boolean isText() {
        return !this.isBinary();
    }
}

