/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.format;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import thredds.server.config.FormatsAvailabilityService;
import thredds.server.ncss.exception.UnsupportedResponseFormatException;
import thredds.server.ncss.format.SupportedFormat;

public final class SupportedOperation
extends Enum<SupportedOperation> {
    public static final /* enum */ SupportedOperation DATASET_INFO_REQUEST = new SupportedOperation("Dataset info request", SupportedFormat.XML_FILE);
    public static final /* enum */ SupportedOperation DATASET_BOUNDARIES_REQUEST = new SupportedOperation("Dataset grid boundaries request", SupportedFormat.WKT, SupportedFormat.JSON);
    public static final /* enum */ SupportedOperation GRID_REQUEST = new SupportedOperation("Grid data request", SupportedFormat.NETCDF3, SupportedFormat.NETCDF4);
    public static final /* enum */ SupportedOperation POINT_REQUEST = new SupportedOperation("Point data request", SupportedFormat.XML_STREAM, SupportedFormat.XML_FILE, SupportedFormat.CSV_STREAM, SupportedFormat.CSV_FILE, SupportedFormat.NETCDF3, SupportedFormat.NETCDF4);
    public static final /* enum */ SupportedOperation STATION_REQUEST = new SupportedOperation("Station data request", SupportedFormat.XML_STREAM, SupportedFormat.XML_FILE, SupportedFormat.CSV_STREAM, SupportedFormat.CSV_FILE, SupportedFormat.NETCDF3, SupportedFormat.NETCDF4, SupportedFormat.WATERML2);
    private final String operationName;
    private final List<SupportedFormat> supportedFormats;
    private static final /* synthetic */ SupportedOperation[] $VALUES;

    public static SupportedOperation[] values() {
        return (SupportedOperation[])$VALUES.clone();
    }

    public static SupportedOperation valueOf(String name) {
        return Enum.valueOf(SupportedOperation.class, name);
    }

    private SupportedOperation(String operationName, SupportedFormat ... formats) {
        this.operationName = operationName;
        this.supportedFormats = Collections.unmodifiableList(Arrays.asList(formats));
        assert (this.supportedFormats.size() > 0);
    }

    public String getName() {
        return this.operationName;
    }

    public List<SupportedFormat> getSupportedFormats() {
        return this.supportedFormats;
    }

    public SupportedFormat getDefaultFormat() {
        return this.supportedFormats.get(0);
    }

    public SupportedFormat getSupportedFormat(String want) throws UnsupportedResponseFormatException {
        if (want == null || want.equals("")) {
            return this.getDefaultFormat();
        }
        for (SupportedFormat f : this.getSupportedFormats()) {
            if (!f.isAlias(want) || !FormatsAvailabilityService.isFormatAvailable(f)) continue;
            return f;
        }
        throw new UnsupportedResponseFormatException("Format " + want + " is not supported for " + this.getName());
    }

    static {
        $VALUES = new SupportedOperation[]{DATASET_INFO_REQUEST, DATASET_BOUNDARIES_REQUEST, GRID_REQUEST, POINT_REQUEST, STATION_REQUEST};
    }
}

