/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg.station;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.springframework.http.HttpHeaders;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.params.NcssParamsBean;
import thredds.server.ncss.util.NcssRequestUtils;
import thredds.server.ncss.view.dsg.station.AbstractStationSubsetWriter;
import thredds.util.ContentType;
import ucar.ma2.Array;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.unidata.util.Format;

public class StationSubsetWriterCSV
extends AbstractStationSubsetWriter {
    private final PrintWriter writer;

    public StationSubsetWriterCSV(FeatureDatasetPoint fdPoint, NcssParamsBean ncssParams, OutputStream out) throws NcssException, IOException {
        super(fdPoint, ncssParams);
        this.writer = new PrintWriter(out);
    }

    @Override
    public HttpHeaders getHttpHeaders(String datasetPath, boolean isStream) {
        HttpHeaders httpHeaders = new HttpHeaders();
        if (!isStream) {
            httpHeaders.set("Content-Location", datasetPath);
            httpHeaders.set("Content-Disposition", "attachment; filename=\"" + NcssRequestUtils.nameFromPathInfo(datasetPath) + ".csv\"");
            httpHeaders.add("Content-Type", ContentType.csv.getContentHeader());
        } else {
            httpHeaders.add("Content-Type", ContentType.text.getContentHeader());
        }
        return httpHeaders;
    }

    @Override
    protected void writeHeader(StationPointFeature stationPointFeat) throws IOException {
        this.writer.print("time,station,latitude[unit=\"degrees_north\"],longitude[unit=\"degrees_east\"]");
        for (VariableSimpleIF wantedVar : this.wantedVariables) {
            this.writer.print(",");
            this.writer.print(wantedVar.getShortName());
            if (wantedVar.getUnitsString() == null) continue;
            this.writer.print("[unit=\"" + wantedVar.getUnitsString() + "\"]");
        }
        this.writer.println();
    }

    @Override
    protected void writeStationPointFeature(StationPointFeature stationPointFeat) throws IOException {
        StationFeature station = stationPointFeat.getStation();
        this.writer.print(CalendarDateFormatter.toDateTimeString((CalendarDate)stationPointFeat.getObservationTimeAsCalendarDate()));
        this.writer.print(',');
        this.writer.print(station.getName());
        this.writer.print(',');
        this.writer.print(Format.dfrac((double)station.getLatitude(), (int)3));
        this.writer.print(',');
        this.writer.print(Format.dfrac((double)station.getLongitude(), (int)3));
        for (VariableSimpleIF wantedVar : this.wantedVariables) {
            this.writer.print(',');
            Array dataArray = stationPointFeat.getData().getArray(wantedVar.getShortName());
            this.writer.print(dataArray.toString().trim());
        }
        this.writer.println();
    }

    @Override
    protected void writeFooter() throws IOException {
        this.writer.flush();
    }
}

