/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.gridaspoint;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import thredds.server.ncss.controller.GridDatasetResponder;
import thredds.server.ncss.format.SupportedFormat;
import thredds.server.ncss.view.gridaspoint.PointDataWriter;
import thredds.server.ncss.view.gridaspoint.netcdf.CFPointWriterWrapper;
import thredds.server.ncss.view.gridaspoint.netcdf.CFPointWriterWrapperFactory;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.constants.CF;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.IO;
import ucar.unidata.geoloc.LatLonPoint;

public class NetCDFPointDataWriter
implements PointDataWriter {
    private static Logger log = LoggerFactory.getLogger(NetCDFPointDataWriter.class);
    private OutputStream outputStream;
    private DiskCache2 diskCache;
    private File netcdfResult;
    private NetcdfFileWriter.Version version;
    private CF.FeatureType featureType;
    private CFPointWriterWrapper pointWriterWrapper;
    private HttpHeaders httpHeaders = new HttpHeaders();

    public static NetCDFPointDataWriter factory(NetcdfFileWriter.Version version, OutputStream outputStream, DiskCache2 diskCache) {
        return new NetCDFPointDataWriter(version, outputStream, diskCache);
    }

    public static String getFileNameForResponse(NetcdfFileWriter.Version version, String pathInfo) {
        String[] tmp = pathInfo.split("/");
        StringBuilder sb = new StringBuilder();
        sb.append(tmp[tmp.length - 2]).append("_").append(tmp[tmp.length - 1]);
        String filename = sb.toString().split("\\.")[0] + version.getSuffix();
        return filename;
    }

    private NetCDFPointDataWriter(NetcdfFileWriter.Version version, OutputStream outputStream, DiskCache2 diskCache) {
        this.outputStream = outputStream;
        this.version = version;
        this.diskCache = diskCache;
        this.netcdfResult = diskCache.createUniqueFile("ncss", ".nc");
    }

    @Override
    public boolean header(Map<String, List<String>> groupedVars, GridDataset gridDataset, List<CalendarDate> wDates, List<Attribute> timeDimAtts, LatLonPoint point, Double vertCoord) {
        boolean headerDone = false;
        if (groupedVars.size() > 1 && !wDates.isEmpty()) {
            this.featureType = CF.FeatureType.timeSeriesProfile;
        } else {
            ArrayList<String> keys = new ArrayList<String>(groupedVars.keySet());
            List<String> varsForRequest = groupedVars.get(keys.get(0));
            CoordinateAxis1D zAxis = gridDataset.findGridDatatype(varsForRequest.get(0)).getCoordinateSystem().getVerticalAxis();
            this.featureType = wDates.isEmpty() ? CF.FeatureType.point : (zAxis == null ? CF.FeatureType.timeSeries : CF.FeatureType.timeSeriesProfile);
        }
        try {
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            atts.add(new Attribute("title", "Extract Points data from Grid file " + gridDataset.getLocationURI()));
            this.pointWriterWrapper = CFPointWriterWrapperFactory.getWriterForFeatureType(this.version, this.featureType, this.netcdfResult.getAbsolutePath(), atts);
            headerDone = this.pointWriterWrapper.header(groupedVars, gridDataset, wDates, timeDimAtts, point, vertCoord);
        }
        catch (IOException ioe) {
            log.error("Error writing header", (Throwable)ioe);
        }
        return headerDone;
    }

    @Override
    public boolean write(Map<String, List<String>> groupedVars, GridDataset gds, List<CalendarDate> wDates, LatLonPoint point, Double vertCoord) throws InvalidRangeException {
        if (wDates.isEmpty()) {
            return this.write(groupedVars, gds, CalendarDate.of((Date)new Date()), point, vertCoord);
        }
        Iterator<CalendarDate> it = wDates.iterator();
        boolean pointRead = true;
        while (pointRead && it.hasNext()) {
            CalendarDate date = it.next();
            pointRead = this.write(groupedVars, gds, date, point, vertCoord);
        }
        return pointRead;
    }

    private boolean write(Map<String, List<String>> groupedVars, GridDataset gridDataset, CalendarDate date, LatLonPoint point, Double targetLevel) throws InvalidRangeException {
        boolean allWrite = this.pointWriterWrapper.write(groupedVars, gridDataset, date, point, targetLevel);
        return allWrite;
    }

    @Override
    public boolean trailer() {
        boolean allDone = false;
        this.pointWriterWrapper.trailer();
        try {
            IO.copyFileB((File)this.netcdfResult, (OutputStream)this.outputStream, (int)60000);
            allDone = true;
        }
        catch (IOException ioe) {
            log.error("Error copying result to the output stream", (Throwable)ioe);
        }
        return allDone;
    }

    @Override
    public HttpHeaders getResponseHeaders() {
        return this.httpHeaders;
    }

    @Override
    public void setHTTPHeaders(GridDataset gridDataset, String pathInfo, boolean isStream) {
        String fileName = NetCDFPointDataWriter.getFileNameForResponse(this.version, pathInfo);
        String url = GridDatasetResponder.buildCacheUrl(this.netcdfResult.getName());
        String contentType = SupportedFormat.NETCDF3.getResponseContentType();
        if (this.version == NetcdfFileWriter.Version.netcdf4) {
            contentType = SupportedFormat.NETCDF4.getResponseContentType();
        }
        this.httpHeaders.set("Content-Type", contentType);
        this.httpHeaders.set("Content-Location", url);
        this.httpHeaders.set("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
    }
}

