/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.root;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.LastModified;
import thredds.server.config.TdsContext;
import thredds.util.RequestForwardUtils;
import thredds.util.TdsPathUtils;

@Controller
public class RootController
implements LastModified {
    @Autowired
    private TdsContext tdsContext;

    @RequestMapping(value={"/"})
    public String getRootPage() {
        return "redirect:/catalog.html";
    }

    @RequestMapping(value={"*.css", "*.gif"})
    public ModelAndView checkPublicDirectory(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String path = TdsPathUtils.extractPath(req, null);
        File file = this.tdsContext.getPublicDocFileSource().getFile(path);
        if (file == null) {
            RequestForwardUtils.forwardRequest(path, this.tdsContext.getDefaultRequestDispatcher(), req, res);
            return null;
        }
        return new ModelAndView("threddsFileView", "file", (Object)file);
    }

    public long getLastModified(HttpServletRequest req) {
        String path = TdsPathUtils.extractPath(req, null);
        File file = this.tdsContext.getPublicDocFileSource().getFile(path);
        if (file == null) {
            return -1L;
        }
        long lastModTime = file.lastModified();
        if (lastModTime == 0L) {
            return -1L;
        }
        return lastModTime;
    }
}

