/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.util.Log4jWebConfigurer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.catalog.InvDatasetScan;
import thredds.inventory.CollectionUpdater;
import thredds.server.config.HtmlConfig;
import thredds.server.config.TdsConfigMapper;
import thredds.server.config.TdsServerInfo;
import thredds.server.config.WmsConfig;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsConfig;
import thredds.util.filesource.BasicDescendantFileSource;
import thredds.util.filesource.BasicWithExclusionsDescendantFileSource;
import thredds.util.filesource.ChainedFileSource;
import thredds.util.filesource.DescendantFileSource;
import thredds.util.filesource.FileSource;
import ucar.nc2.util.IO;
import ucar.unidata.util.StringUtil2;

@Component(value="tdsContext")
public final class TdsContext
implements ServletContextAware,
InitializingBean,
DisposableBean {
    private String webappName;
    private String contextPath;
    @Value(value="${tds.version}")
    private String webappVersion;
    @Value(value="${tds.version.builddate}")
    private String webappVersionBuildDate;
    @Value(value="${tds.content.root.path}")
    private String contentRootPath;
    @Value(value="${tds.content.path}")
    private String contentPath;
    @Value(value="${tds.content.idd.path}")
    private String iddContentPath;
    @Value(value="${tds.content.motherlode.path}")
    private String motherlodeContentPath;
    @Value(value="${tds.config.file}")
    private String tdsConfigFileName;
    @Value(value="${tds.content.startup.path}")
    private String startupContentPath;
    private String webinfPath;
    private File rootDirectory;
    private File contentDirectory;
    private File publicContentDirectory;
    private File tomcatLogDir;
    private File startupContentDirectory;
    private DescendantFileSource rootDirSource;
    private DescendantFileSource contentDirSource;
    private DescendantFileSource publicContentDirSource;
    private DescendantFileSource startupContentDirSource;
    private FileSource configSource;
    private FileSource publicDocSource;
    private RequestDispatcher defaultRequestDispatcher;
    private RequestDispatcher jspRequestDispatcher;
    @Autowired
    private HtmlConfig htmlConfig;
    @Autowired
    private TdsServerInfo serverInfo;
    @Autowired
    private WmsConfig wmsConfig;
    private ServletContext servletContext;
    private Logger logServerStartup = LoggerFactory.getLogger((String)"serverStartup");

    private TdsContext() {
    }

    public void setWebappVersion(String verFull) {
        this.webappVersion = verFull;
    }

    public void setWebappVersionBuildDate(String buildDateString) {
        this.webappVersionBuildDate = buildDateString;
    }

    public void setContentRootPath(String contentRootPath) {
        this.contentRootPath = contentRootPath;
    }

    public String getContentRootPath() {
        return this.contentRootPath;
    }

    public String getContentRootPathAbsolute() {
        File abs = new File(this.contentRootPath);
        return abs.getAbsolutePath();
    }

    public void setContentPath(String contentPath) {
        this.contentPath = contentPath;
    }

    public void setStartupContentPath(String startupContentPath) {
        this.startupContentPath = startupContentPath;
    }

    public void setIddContentPath(String iddContentPath) {
        this.iddContentPath = iddContentPath;
    }

    public void setMotherlodeContentPath(String motherlodeContentPath) {
        this.motherlodeContentPath = motherlodeContentPath;
    }

    public void setTdsConfigFileName(String filename) {
        this.tdsConfigFileName = filename;
    }

    public String getTdsConfigFileName() {
        return this.tdsConfigFileName;
    }

    public void setServerInfo(TdsServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }

    public TdsServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public void setHtmlConfig(HtmlConfig htmlConfig) {
        this.htmlConfig = htmlConfig;
    }

    public HtmlConfig getHtmlConfig() {
        return this.htmlConfig;
    }

    public WmsConfig getWmsConfig() {
        return this.wmsConfig;
    }

    public void setWmsConfig(WmsConfig wmsConfig) {
        this.wmsConfig = wmsConfig;
    }

    public void destroy() {
        this.logServerStartup.info("TdsContext: releasing resources");
        this.logServerStartup.info("TdsContext: Shutting down collection manager");
        CollectionUpdater.INSTANCE.shutdown();
        this.logServerStartup.info("TdsContext: shutdownLogging()");
        Log4jWebConfigurer.shutdownLogging((ServletContext)this.servletContext);
    }

    public void afterPropertiesSet() {
        String msg;
        String msg2;
        if (this.servletContext == null) {
            throw new IllegalArgumentException("ServletContext must not be null.");
        }
        ServletUtil.initDebugging(this.servletContext);
        this.webappName = this.servletContext.getServletContextName();
        String tmpContextPath = this.servletContext.getInitParameter("ContextPath");
        if (tmpContextPath == null) {
            tmpContextPath = "thredds";
        }
        this.contextPath = "/" + tmpContextPath;
        ServletUtil.setContextPath(this.contextPath);
        String rootPath = this.servletContext.getRealPath("/");
        if (rootPath == null) {
            String msg3 = "Webapp [" + this.webappName + "] must run with exploded deployment directory (not from .war).";
            this.logServerStartup.error("TdsContext.init(): " + msg3);
            throw new IllegalStateException(msg3);
        }
        this.rootDirectory = new File(rootPath);
        this.rootDirSource = new BasicDescendantFileSource(this.rootDirectory);
        this.rootDirectory = this.rootDirSource.getRootDirectory();
        ServletUtil.setRootPath(this.rootDirSource.getRootDirectoryPath());
        this.startupContentDirectory = new File(this.rootDirectory, this.startupContentPath);
        this.startupContentDirSource = new BasicDescendantFileSource(this.startupContentDirectory);
        this.startupContentDirectory = this.startupContentDirSource.getRootDirectory();
        this.webinfPath = this.rootDirectory + "/WEB-INF";
        try {
            String base = System.getProperty("catalina.base");
            if (base != null) {
                this.tomcatLogDir = new File(base, "logs").getCanonicalFile();
                if (!this.tomcatLogDir.exists()) {
                    msg2 = "'catalina.base' directory not found";
                    this.logServerStartup.error("TdsContext.init(): " + msg2);
                }
            } else {
                msg2 = "'catalina.base' property not found - probably not a tomcat server";
                this.logServerStartup.warn("TdsContext.init(): " + msg2);
            }
        }
        catch (IOException e) {
            msg2 = "tomcatLogDir could not be created";
            System.out.println("WARN - TdsContext.init(): " + msg2);
        }
        File contentRootDir = new File(this.contentRootPath);
        if (!contentRootDir.isAbsolute()) {
            this.contentDirectory = new File(new File(this.rootDirectory, this.contentRootPath), this.contentPath);
        } else if (contentRootDir.isDirectory()) {
            this.contentDirectory = new File(contentRootDir, this.contentPath);
        } else {
            msg2 = "Content root directory [" + this.contentRootPath + "] not a directory.";
            System.out.println("ERROR - TdsContext.init(): " + msg2);
            throw new IllegalStateException(msg2);
        }
        if (TdsContext.isFirstDeployment(this.contentDirectory)) {
            try {
                this.logServerStartup.info("Initial TDS deployment. Copying conents of {} to {}.", (Object)this.startupContentDirectory.getPath(), (Object)this.contentDirectory.getPath());
                IO.copyDirTree((String)this.startupContentDirectory.getPath(), (String)this.contentDirectory.getPath());
            }
            catch (IOException e) {
                String tmpMsg = "Content directory does not exist and could not be created";
                System.out.println("ERROR - TdsContext.init(): " + tmpMsg + " [" + this.contentDirectory.getAbsolutePath() + "].");
                throw new IllegalStateException(tmpMsg);
            }
        }
        if (!this.contentDirectory.isDirectory()) {
            String tmpMsg = "Content directory not a directory";
            System.out.println("ERROR - TdsContext.init(): " + tmpMsg + " [" + this.contentDirectory.getAbsolutePath() + "].");
            throw new IllegalStateException(tmpMsg);
        }
        this.contentDirSource = new BasicDescendantFileSource(StringUtils.cleanPath((String)this.contentDirectory.getAbsolutePath()));
        this.contentDirectory = this.contentDirSource.getRootDirectory();
        ServletUtil.setContentPath(this.contentDirSource.getRootDirectoryPath());
        File logDir = new File(this.contentDirectory, "logs");
        if (!logDir.exists() && !logDir.mkdirs()) {
            String msg4 = "Couldn't create TDS log directory [" + logDir.getPath() + "].";
            this.logServerStartup.error("TdsContext.init(): " + msg4);
            throw new IllegalStateException(msg4);
        }
        String loggingDirectory = StringUtil2.substitute((String)logDir.getPath(), (String)"\\", (String)"/");
        System.setProperty("tds.log.dir", loggingDirectory);
        this.logServerStartup.info("TdsContext version= " + this.getVersionInfo());
        Map<String, String> latestVersionInfo = this.getLatestVersionInfo();
        for (String versionType : latestVersionInfo.keySet()) {
            this.logServerStartup.info("TdsContext latest " + versionType + " version = " + latestVersionInfo.get(versionType));
        }
        this.logServerStartup.info("TdsContext intialized logging in " + logDir.getPath());
        File tdsConfigFile = this.contentDirSource.getFile(this.getTdsConfigFileName());
        if (tdsConfigFile == null) {
            tdsConfigFile = new File(this.contentDirSource.getRootDirectory(), this.getTdsConfigFileName());
            msg = "TDS configuration file doesn't exist: " + tdsConfigFile;
            this.logServerStartup.error("TdsContext.init(): " + msg);
            throw new IllegalStateException(msg);
        }
        ThreddsConfig.init(tdsConfigFile.getPath());
        this.publicContentDirectory = new File(this.contentDirectory, "public");
        if (!this.publicContentDirectory.exists() && !this.publicContentDirectory.mkdirs()) {
            msg = "Couldn't create TDS public directory [" + this.publicContentDirectory.getPath() + "].";
            this.logServerStartup.error("TdsContext.init(): " + msg);
            throw new IllegalStateException(msg);
        }
        this.publicContentDirSource = new BasicDescendantFileSource(this.publicContentDirectory);
        ArrayList<DescendantFileSource> chain = new ArrayList<DescendantFileSource>();
        BasicWithExclusionsDescendantFileSource contentMinusPublicSource = new BasicWithExclusionsDescendantFileSource(this.contentDirectory, Collections.singletonList("public"));
        chain.add(contentMinusPublicSource);
        this.configSource = new ChainedFileSource(chain);
        this.publicDocSource = this.publicContentDirSource;
        InvDatasetScan.setContext((String)this.contextPath);
        InvDatasetScan.setCatalogServletName((String)"/catalog");
        InvDatasetFeatureCollection.setContext((String)this.contextPath);
        this.jspRequestDispatcher = this.servletContext.getNamedDispatcher("jsp");
        this.defaultRequestDispatcher = this.servletContext.getNamedDispatcher("default");
        TdsConfigMapper tdsConfigMapper = new TdsConfigMapper();
        tdsConfigMapper.setTdsServerInfo(this.serverInfo);
        tdsConfigMapper.setHtmlConfig(this.htmlConfig);
        tdsConfigMapper.setWmsConfig(this.wmsConfig);
        tdsConfigMapper.init(this);
    }

    private static boolean isFirstDeployment(File contentDirectory) {
        if (!contentDirectory.exists()) {
            return true;
        }
        File[] contents = contentDirectory.listFiles();
        if (contents.length != 1) {
            return false;
        }
        File content = contents[0];
        return content.isDirectory() && content.getName().equals("logs");
    }

    public String getWebappName() {
        return this.webappName;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getWebinfPath() {
        return this.webinfPath;
    }

    public String getWebappVersion() {
        return this.webappVersion;
    }

    public String getWebappVersionBuildDate() {
        return this.webappVersionBuildDate;
    }

    public String getVersionInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getWebappVersion());
        if (this.getWebappVersionBuildDate() != null) {
            sb.append(" - ");
            sb.append(this.getWebappVersionBuildDate());
        }
        return sb.toString();
    }

    private Map<String, String> getLatestVersionInfo() {
        HashMap<String, String> latestVersionInfo = new HashMap<String, String>();
        String versionUrl = "http://www.unidata.ucar.edu/software/thredds/latest.xml";
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet request = new HttpGet(versionUrl);
        request.setHeader("User-Agent", "TDS_" + this.getVersionInfo().replace(" ", ""));
        HttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            InputStream content = entity.getContent();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(content);
            Element docEle = dom.getDocumentElement();
            NodeList versionElements = docEle.getElementsByTagName("version");
            if (versionElements != null && versionElements.getLength() > 0) {
                for (int i = 0; i < versionElements.getLength(); ++i) {
                    Element versionElement = (Element)versionElements.item(i);
                    String verType = versionElement.getAttribute("name");
                    String verStr = versionElement.getAttribute("value");
                    latestVersionInfo.put(verType, verStr);
                }
            }
        }
        catch (IOException e) {
            this.logServerStartup.warn("TdsContext - Could not get latest version information from Unidata.");
        }
        catch (ParserConfigurationException e) {
            this.logServerStartup.error("TdsContext - Error configuring latest version xml parser" + e.getMessage() + ".");
        }
        catch (SAXException e) {
            this.logServerStartup.error("TdsContext - Could not parse latest version information.");
        }
        return latestVersionInfo;
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public File getTomcatLogDirectory() {
        return this.tomcatLogDir;
    }

    public File getContentDirectory() {
        return this.contentDirectory;
    }

    public File getStartupContentDirectory() {
        return this.startupContentDirectory;
    }

    public FileSource getConfigFileSource() {
        return this.configSource;
    }

    public FileSource getPublicDocFileSource() {
        return this.publicDocSource;
    }

    public RequestDispatcher getDefaultRequestDispatcher() {
        return this.defaultRequestDispatcher;
    }

    public RequestDispatcher getJspRequestDispatcher() {
        return this.jspRequestDispatcher;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TdsContext{");
        sb.append("webappName='").append(this.webappName).append('\'');
        sb.append("\n  contextPath='").append(this.contextPath).append('\'');
        sb.append("\n  webappVersion='").append(this.webappVersion).append('\'');
        sb.append("\n  webappVersionBuildDate='").append(this.webappVersionBuildDate).append('\'');
        sb.append("\n  contentRootPath='").append(this.contentRootPath).append('\'');
        sb.append("\n  contentPath='").append(this.contentPath).append('\'');
        sb.append("\n  iddContentPath='").append(this.iddContentPath).append('\'');
        sb.append("\n  motherlodeContentPath='").append(this.motherlodeContentPath).append('\'');
        sb.append("\n  tdsConfigFileName='").append(this.tdsConfigFileName).append('\'');
        sb.append("\n  startupContentPath='").append(this.startupContentPath).append('\'');
        sb.append("\n  webinfPath='").append(this.webinfPath).append('\'');
        sb.append("\n  rootDirectory=").append(this.rootDirectory);
        sb.append("\n  contentDirectory=").append(this.contentDirectory);
        sb.append("\n  publicContentDirectory=").append(this.publicContentDirectory);
        sb.append("\n  tomcatLogDir=").append(this.tomcatLogDir);
        sb.append("\n  startupContentDirectory=").append(this.startupContentDirectory);
        sb.append("\n  rootDirSource=").append(this.rootDirSource);
        sb.append("\n  contentDirSource=").append(this.contentDirSource);
        sb.append("\n  publicContentDirSource=").append(this.publicContentDirSource);
        sb.append("\n  startupContentDirSource=").append(this.startupContentDirSource);
        sb.append("\n  configSource=").append(this.configSource);
        sb.append("\n  publicDocSource=").append(this.publicDocSource);
        sb.append('}');
        return sb.toString();
    }
}

