/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import thredds.server.config.TdsContext;
import thredds.server.ncss.exception.OutOfBoundariesException;
import thredds.server.ncss.exception.TimeOutOfWindowException;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridAsPointDataset;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.vertical.VerticalTransform;

@Component
public final class NcssRequestUtils
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    private NcssRequestUtils() {
    }

    public static GridAsPointDataset buildGridAsPointDataset(GridDataset gds, List<String> vars) {
        ArrayList<GridDatatype> grids = new ArrayList<GridDatatype>();
        for (String gridName : vars) {
            GridDatatype grid = gds.findGridDatatype(gridName);
            if (grid == null) continue;
            grids.add(grid);
        }
        return new GridAsPointDataset(grids);
    }

    public static List<String> getAllVarsAsList(GridDataset gds) {
        ArrayList<String> vars = new ArrayList<String>();
        List allVars = gds.getDataVariables();
        for (VariableSimpleIF var : allVars) {
            vars.add(var.getShortName());
        }
        return vars;
    }

    public static List<CalendarDate> wantedDates(GridAsPointDataset gap, CalendarDateRange dates, long timeWindow) throws TimeOutOfWindowException, OutOfBoundariesException {
        CalendarDate start = dates.getStart();
        CalendarDate end = dates.getEnd();
        List gdsDates = gap.getDates();
        if (start.isAfter((CalendarDate)gdsDates.get(gdsDates.size() - 1)) || end.isBefore((CalendarDate)gdsDates.get(0))) {
            throw new OutOfBoundariesException("Requested time range does not intersect the Data Time Range = " + gdsDates.get(0) + " to " + gdsDates.get(gdsDates.size() - 1));
        }
        ArrayList<CalendarDate> wantDates = new ArrayList<CalendarDate>();
        if (dates.isPoint()) {
            int best_index = 0;
            long best_diff = Long.MAX_VALUE;
            for (int i = 0; i < gdsDates.size(); ++i) {
                CalendarDate date = (CalendarDate)gdsDates.get(i);
                long diff = Math.abs(date.getDifferenceInMsecs(start));
                if (diff >= best_diff) continue;
                best_index = i;
                best_diff = diff;
            }
            if (timeWindow > 0L && best_diff > timeWindow) {
                throw new TimeOutOfWindowException("There is not time within the provided time window");
            }
            wantDates.add((CalendarDate)gdsDates.get(best_index));
        } else {
            for (CalendarDate date : gdsDates) {
                boolean tooEarly = date.isBefore(start);
                boolean tooLate = date.isAfter(end);
                if (tooEarly || tooLate) continue;
                wantDates.add(date);
            }
        }
        return wantDates;
    }

    public static List<VariableSimpleIF> wantedVars2VariableSimple(List<String> wantedVars, GridDataset gds, NetcdfDataset ncfile) {
        ArrayList<VariableSimpleIF> varList = new ArrayList<VariableSimpleIF>(wantedVars.size());
        for (String var : wantedVars) {
            VariableDS ve = gds.findGridDatatype(var).getVariable();
            String dims = "";
            VariableDS want = new VariableDS(ncfile, null, null, ve.getShortName(), ve.getDataType(), dims, ve.getUnitsString(), ve.getDescription());
            varList.add((VariableSimpleIF)want);
        }
        return varList;
    }

    public static GridDatatype getTimeGrid(Map<String, List<String>> groupedVars, GridDataset gridDataset) {
        ArrayList<String> keys = new ArrayList<String>(groupedVars.keySet());
        GridDatatype timeGrid = null;
        ArrayList allVars = new ArrayList();
        for (String key : keys) {
            allVars.addAll(groupedVars.get(key));
        }
        Iterator it = allVars.iterator();
        while (timeGrid == null && it.hasNext()) {
            String var = (String)it.next();
            if (!gridDataset.findGridDatatype(var).getCoordinateSystem().hasTimeAxis()) continue;
            timeGrid = gridDataset.findGridDatatype(var);
        }
        return timeGrid;
    }

    public static Double getTimeCoordValue(GridDatatype grid, CalendarDate date, CalendarDate origin) {
        Double coordVal;
        CoordinateAxis1DTime tAxis = grid.getCoordinateSystem().getTimeAxis1D();
        if (tAxis == null) {
            return -1.0;
        }
        Integer wIndex = tAxis.findTimeIndexFromCalendarDate(date);
        if (tAxis.getDataType() == DataType.STRING) {
            CalendarDate wanted = tAxis.getCalendarDate(wIndex.intValue());
            coordVal = (double)wanted.getDifferenceInMsecs(origin) / 1000.0;
        } else {
            coordVal = tAxis.getCoordValue(wIndex.intValue());
        }
        return coordVal;
    }

    public static Double getTargetLevelForVertCoord(CoordinateAxis1D zAxis, Double vertLevel) {
        Double targetLevel = vertLevel;
        if (zAxis.getSize() == 1L) {
            targetLevel = 0.0;
        } else {
            int coordLevel = zAxis.findCoordElementBounded(vertLevel.doubleValue());
            if (coordLevel > 0) {
                targetLevel = zAxis.getCoordValue(coordLevel);
            }
        }
        return targetLevel;
    }

    public static double getActualVertLevel(GridDatatype grid, CalendarDate date, LatLonPoint point, double targetLevel) throws IOException, InvalidRangeException {
        double actualLevel = -9999.9;
        GridCoordSystem cs = grid.getCoordinateSystem();
        VerticalTransform vt = cs.getVerticalTransform();
        if (vt != null) {
            int[] result = new int[2];
            cs.findXYindexFromLatLon(point.getLatitude(), point.getLongitude(), result);
            CoordinateAxis1DTime timeAxis = cs.getTimeAxis1D();
            int vertCoord = cs.getVerticalAxis().findCoordElement(targetLevel);
            int timeIndex = 0;
            if (timeAxis != null) {
                timeIndex = timeAxis.findTimeIndexFromCalendarDate(date);
            }
            ArrayDouble.D1 actualLevels = vt.getCoordinateArray1D(timeIndex, result[0], result[1]);
            actualLevel = actualLevels.get(vertCoord);
        }
        return actualLevel;
    }

    public static String nameFromPathInfo(String pathInfo) {
        String[] pathInfoStr = pathInfo.split("/");
        return pathInfoStr[pathInfoStr.length - 1];
    }

    public static TdsContext getTdsContext() {
        return (TdsContext)applicationContext.getBean(TdsContext.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        NcssRequestUtils.applicationContext = applicationContext;
    }
}

