/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg.point;

import java.io.IOException;
import java.util.List;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.params.NcssParamsBean;
import thredds.server.ncss.view.dsg.AbstractDsgSubsetWriter;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;

public abstract class AbstractPointSubsetWriter
extends AbstractDsgSubsetWriter {
    protected final PointFeatureCollection pointFeatureCollection;
    private boolean headerDone;

    public AbstractPointSubsetWriter(FeatureDatasetPoint fdPoint, NcssParamsBean ncssParams) throws NcssException, IOException {
        super(fdPoint, ncssParams);
        List featColList = fdPoint.getPointFeatureCollectionList();
        assert (featColList.size() == 1) : "Is there ever a case when this is NOT 1?";
        assert (featColList.get(0) instanceof PointFeatureCollection) : "This class only deals with PointFeatureCollections.";
        this.pointFeatureCollection = (PointFeatureCollection)featColList.get(0);
    }

    public abstract void writeHeader(PointFeature var1) throws Exception;

    public abstract void writePoint(PointFeature var1) throws Exception;

    public abstract void writeFooter() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write() throws Exception {
        PointFeatureCollection subsettedPointFeatColl = this.pointFeatureCollection.subset(this.ncssParams.getBoundingBox(), this.wantedRange);
        subsettedPointFeatColl.resetIteration();
        try {
            while (subsettedPointFeatColl.hasNext()) {
                PointFeature pointFeat = subsettedPointFeatColl.next();
                if (!this.headerDone) {
                    this.writeHeader(pointFeat);
                    this.headerDone = true;
                }
                this.writePoint(pointFeat);
            }
        }
        finally {
            subsettedPointFeatColl.finish();
        }
        this.writeFooter();
    }
}

