/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import opendap.dap.BaseType;
import opendap.dap.NoSuchVariableException;
import opendap.servers.CEEvaluator;
import opendap.servers.DAP2ServerSideException;
import opendap.servers.SDStructure;
import opendap.servers.ServerMethods;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.opendap.HasNetcdfVariable;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Structure;
import ucar.nc2.Variable;

public class NcSDStructure
extends SDStructure {
    private static Logger log = LoggerFactory.getLogger(NcSDStructure.class);
    private Structure ncVar = null;
    protected List<BaseType> memberBTlist;
    protected NcSDStructure org;
    protected StructureData sdata;

    public NcSDStructure(Structure s, List<BaseType> list) {
        super(Variable.getDAPName((Variable)s));
        this.ncVar = s;
        for (BaseType aList : list) {
            this.addVariable(aList, 0);
        }
        this.memberBTlist = list;
    }

    public NcSDStructure(NcSDStructure org, StructureData sdata) {
        super(org.getEncodedName());
        this.org = org;
        this.sdata = sdata;
    }

    public Variable getVariable() {
        return this.ncVar;
    }

    public boolean read(String datasetName, Object specialO) throws NoSuchVariableException, IOException {
        StructureData sdata = this.ncVar.readStructure();
        this.setData(sdata);
        return false;
    }

    public void setData(StructureData sdata) {
        int count = 0;
        StructureMembers sm = sdata.getStructureMembers();
        Enumeration vars = this.getVariables();
        while (vars.hasMoreElements()) {
            HasNetcdfVariable hasNetcdf = (HasNetcdfVariable)vars.nextElement();
            StructureMembers.Member m = sm.getMember(count++);
            Array data = sdata.getArray(m);
            hasNetcdf.setData(data);
        }
        this.setRead(true);
    }

    public void serialize(String dataset, DataOutputStream sink, CEEvaluator ce, Object specialO) throws NoSuchVariableException, DAP2ServerSideException, IOException {
        if (this.org == null) {
            super.serialize(dataset, sink, ce, specialO);
            return;
        }
        Enumeration vars = this.org.getVariables();
        StructureMembers sm = this.sdata.getStructureMembers();
        int count = 0;
        while (vars.hasMoreElements()) {
            HasNetcdfVariable sm_org = (HasNetcdfVariable)vars.nextElement();
            boolean isProjected = ((ServerMethods)sm_org).isProject();
            if (isProjected) {
                StructureMembers.Member m = sm.getMember(count);
                sm_org.serialize(sink, this.sdata, m);
            }
            ++count;
        }
    }
}

