/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.radarServer;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.query.Station;
import thredds.server.radarServer.QueryParams;
import thredds.server.radarServer.RadarServer;
import thredds.server.radarServer.ServerMethods;
import thredds.servlet.ServletUtil;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.unidata.util.Format;

public class RadarMethods {
    public static final String nexradStations = "RadarNexradStations.xml";
    public static final String terminalStations = "RadarTerminalStations.xml";
    public static List<Station> nexradList = new ArrayList<Station>();
    public static List<Station> terminalList = new ArrayList<Station>();
    public static HashMap<String, Station> nexradMap;
    public static HashMap<String, Station> terminalMap;
    public static final ArrayList<String> nexradVars;
    public static final ArrayList<String> terminalVars;
    private static final String serviceName = "OPENDAP";
    private static final String serviceType = "OPENDAP";
    private ServerMethods sm;
    private boolean debug = false;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public RadarMethods() {
    }

    public RadarMethods(String contentPath, Logger log) {
        this.sm = new ServerMethods(log);
        if (nexradList.size() == 0) {
            nexradList = this.sm.getStations(contentPath + this.getPath() + nexradStations);
            terminalList = this.sm.getStations(contentPath + this.getPath() + terminalStations);
            if (nexradList == null || terminalList == null) {
                log.error("Station initialization problem using " + contentPath + this.getPath() + nexradStations + " " + contentPath + this.getPath() + terminalStations);
                return;
            }
            nexradMap = this.sm.getStationMap(nexradList);
            terminalMap = this.sm.getStationMap(terminalList);
            nexradVars.add("N0R");
            nexradVars.add("N1R");
            nexradVars.add("N2R");
            nexradVars.add("N3R");
            nexradVars.add("DPA");
            nexradVars.add("DHR");
            nexradVars.add("DSP");
            nexradVars.add("N1P");
            nexradVars.add("N0S");
            nexradVars.add("N1S");
            nexradVars.add("N2S");
            nexradVars.add("N3S");
            nexradVars.add("N0V");
            nexradVars.add("N1V");
            nexradVars.add("N0Z");
            nexradVars.add("NCR");
            nexradVars.add("NET");
            nexradVars.add("NMD");
            nexradVars.add("NTP");
            nexradVars.add("NVL");
            nexradVars.add("NVW");
            nexradVars.add("N0Q");
            nexradVars.add("NAQ");
            nexradVars.add("N1Q");
            nexradVars.add("NBQ");
            nexradVars.add("N2Q");
            nexradVars.add("N3Q");
            nexradVars.add("N0U");
            nexradVars.add("NAU");
            nexradVars.add("N1U");
            nexradVars.add("NBU");
            nexradVars.add("N2U");
            nexradVars.add("N3U");
            nexradVars.add("DVL");
            nexradVars.add("EET");
            nexradVars.add("N0X");
            nexradVars.add("NAX");
            nexradVars.add("N1X");
            nexradVars.add("NBX");
            nexradVars.add("N2X");
            nexradVars.add("N3X");
            nexradVars.add("N0C");
            nexradVars.add("NAC");
            nexradVars.add("N1C");
            nexradVars.add("NBC");
            nexradVars.add("N2C");
            nexradVars.add("N3C");
            nexradVars.add("N0K");
            nexradVars.add("NAK");
            nexradVars.add("N1K");
            nexradVars.add("NBK");
            nexradVars.add("N2K");
            nexradVars.add("N3K");
            nexradVars.add("N0H");
            nexradVars.add("NAH");
            nexradVars.add("N1H");
            nexradVars.add("NBH");
            nexradVars.add("N2H");
            nexradVars.add("N3H");
            nexradVars.add("N0M");
            nexradVars.add("NAM");
            nexradVars.add("N1M");
            nexradVars.add("NBM");
            nexradVars.add("N2M");
            nexradVars.add("N3M");
            nexradVars.add("DPR");
            nexradVars.add("HHC");
            nexradVars.add("OHA");
            nexradVars.add("DAA");
            nexradVars.add("PTA");
            nexradVars.add("DTA");
            nexradVars.add("DU3");
            nexradVars.add("DU6");
            nexradVars.add("DOD");
            nexradVars.add("DSD");
            nexradVars.add("BREF1");
            nexradVars.add("BREF2");
            nexradVars.add("BREF248");
            nexradVars.add("BREF3");
            nexradVars.add("BREF4");
            nexradVars.add("LREF1");
            nexradVars.add("LREF2");
            nexradVars.add("LREF3");
            nexradVars.add("CREF");
            nexradVars.add("BVEL1");
            nexradVars.add("BVEL2");
            nexradVars.add("VEL1");
            nexradVars.add("VEL2");
            nexradVars.add("VEL3");
            nexradVars.add("VEL4");
            nexradVars.add("LREF1");
            nexradVars.add("PRECIP1");
            nexradVars.add("PRECIPTOT");
            nexradVars.add("SRMV1");
            nexradVars.add("SRMV2");
            nexradVars.add("SRVEL1");
            nexradVars.add("SRVEL2");
            nexradVars.add("SRVEL3");
            nexradVars.add("SRVEL4");
            nexradVars.add("TOPS");
            nexradVars.add("VIL");
            nexradVars.add("PRE1");
            nexradVars.add("PRET");
            nexradVars.add("PREA");
            nexradVars.add("VAD");
            terminalVars.add("TR0");
            terminalVars.add("TR1");
            terminalVars.add("TR2");
            terminalVars.add("TV0");
            terminalVars.add("TV1");
            terminalVars.add("TV2");
            terminalVars.add("TZL");
            terminalVars.add("DHR");
            terminalVars.add("NCR");
            terminalVars.add("NET");
            terminalVars.add("NVW");
            terminalVars.add("NVL");
            terminalVars.add("NST");
            terminalVars.add("NHI");
            terminalVars.add("NTV");
            terminalVars.add("FTM");
            terminalVars.add("N1P");
            terminalVars.add("NTP");
            terminalVars.add("DPA");
            terminalVars.add("SPD");
            terminalVars.add("DSP");
            terminalVars.add("NMD");
            terminalVars.add("RSL");
            terminalVars.add("GSM");
        }
    }

    public Document stationsXML(RadarServer.RadarType radarType, Document doc, Element rootElem, String path) throws Exception {
        String[] stations = this.stationsDS(radarType, RadarServer.dataLocation.get(path));
        if (path.contains("level3") && stations[0].length() == 4) {
            for (int i = 0; i < stations.length; ++i) {
                stations[i] = stations[i].substring(1);
            }
        }
        doc = this.makeStationDocument(doc, rootElem, stations, radarType);
        return doc;
    }

    protected String getPath() {
        return "servers/";
    }

    public void radarQuery(RadarServer.RadarType radarType, HttpServletRequest req, HttpServletResponse res, PrintWriter pw) throws ServletException, IOException {
        String radarDir = null;
        try {
            String serviceBase;
            String pathInfo = req.getPathInfo();
            if (pathInfo == null) {
                pathInfo = "";
            }
            if (pathInfo.startsWith("/")) {
                pathInfo = pathInfo.substring(1);
            }
            Boolean level2 = pathInfo.contains("level2");
            radarDir = RadarServer.dataLocation.get(pathInfo);
            if (radarDir == null) {
                radarDir = RadarServer.dataLocation.get("nexrad/level2/IDD");
            }
            QueryParams qp = new QueryParams();
            if (!qp.parseQuery(req, res, new String[]{"application/xml", "text/html", "text/plain", "application/x-netcdf"})) {
                return;
            }
            if (!this.checkQueryParms(radarType, qp, level2).booleanValue()) {
                this.log.error("checkQueryParms Failed " + req.getQueryString());
                throw new Exception("checkQueryParms Failed " + req.getQueryString());
            }
            qp.acceptType = qp.acceptType.replaceFirst(".*/", "");
            if (ServerMethods.p_html_i.matcher(qp.acceptType).find()) {
                res.setContentType(qp.acceptType);
                serviceBase = pathInfo + "/";
            } else {
                serviceBase = "/thredds/dodsC/" + pathInfo + "/";
            }
            if (!this.writeHeader(radarType, qp, pathInfo, pw).booleanValue()) {
                this.log.error("Write Header Failed " + req.getQueryString());
                throw new Exception("Write Header Failed " + req.getQueryString());
            }
            boolean dataFound = this.processQuery(radarDir, qp, pw, serviceBase, radarType);
            if (ServerMethods.p_xml_i.matcher(qp.acceptType).find()) {
                if (!dataFound) {
                    pw.println("      <documentation>No data available for station(s) and time range</documentation>");
                }
                pw.println("    </dataset>");
                pw.println("</catalog>");
            } else if (ServerMethods.p_html_i.matcher(qp.acceptType).find()) {
                pw.println("  </table>");
                if (!dataFound) {
                    pw.println("<p>No data available for station(s) and time range " + req.getQueryString() + "</p>");
                }
                pw.println("</html>");
            }
        }
        catch (Throwable t) {
            this.log.error("Query error " + req.getQueryString());
            ServletUtil.handleException(t, res);
        }
    }

    private Boolean checkQueryParms(RadarServer.RadarType radarType, QueryParams qp, Boolean level2) throws IOException {
        try {
            boolean useAllStations;
            if (qp.hasBB) {
                qp.stns = radarType.equals((Object)RadarServer.RadarType.nexrad) ? this.sm.getStationNames(qp.getBB(), nexradList) : this.sm.getStationNames(qp.getBB(), terminalList);
                if (!level2.booleanValue()) {
                    qp.stns = this.sm.convert4to3stations(qp.stns);
                }
                if (qp.stns.size() == 0) {
                    this.log.error("Bounding Box contains no stations ");
                    throw new Exception("Bounding Box contains no stations ");
                }
            }
            if (qp.hasStns && this.isStationListEmpty(qp.stns, radarType)) {
                this.log.error("No valid stations specified 1");
                throw new Exception("No valid stations specified");
            }
            if (qp.hasLatlonPoint) {
                qp.stns = new ArrayList<String>();
                if (radarType.equals((Object)RadarServer.RadarType.nexrad)) {
                    qp.stns.add(this.sm.findClosestStation(qp.lat, qp.lon, nexradList));
                } else {
                    qp.stns.add(this.sm.findClosestStation(qp.lat, qp.lon, terminalList));
                }
                if (!level2.booleanValue()) {
                    qp.stns = this.sm.convert4to3stations(qp.stns);
                }
            } else if (qp.fatal) {
                this.log.error("No valid stations specified 2");
                throw new Exception("No valid stations specified");
            }
            if (useAllStations = qp.stns.get(0).toUpperCase().equals("ALL")) {
                qp.stns = radarType.equals((Object)RadarServer.RadarType.nexrad) ? this.sm.getStationNames(nexradList) : this.sm.getStationNames(terminalList);
                if (!level2.booleanValue()) {
                    qp.stns = this.sm.convert4to3stations(qp.stns);
                }
            }
            if (qp.hasTimePoint) {
                if (qp.time.isPresent()) {
                    try {
                        qp.time_end = new DateType("present", null, null);
                        qp.time_start = new DateType("1970-01-01T00:00:00", null, null);
                    }
                    catch (ParseException e) {
                        this.log.error("Illegal param= 'time' must be valid ISO Duration");
                        throw new Exception("Illegal param= 'time' must be valid ISO Duration");
                    }
                } else {
                    qp.time_end = qp.time;
                    qp.time_start = qp.time;
                }
            } else if (qp.hasDateRange) {
                DateRange dr = qp.getCalendarDateRange().toDateRange();
                qp.time_start = dr.getStart();
                qp.time_end = dr.getEnd();
            } else {
                try {
                    qp.time = new DateType("present", null, null);
                    qp.time_end = new DateType("present", null, null);
                    qp.time_start = new DateType("1970-01-01T00:00:00", null, null);
                }
                catch (ParseException e) {
                    this.log.error("Illegal param= 'time' must be valid ISO Duration");
                    throw new Exception("Illegal param= 'time' must be valid ISO Duration");
                }
            }
            if (level2.booleanValue()) {
                qp.vars = null;
            } else if (qp.vars != null) {
                ArrayList<String> tmp = new ArrayList<String>();
                for (String var : qp.vars) {
                    tmp.add(var.replaceFirst("/.*", ""));
                }
                qp.vars = tmp;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private Boolean writeHeader(RadarServer.RadarType radarType, QueryParams qp, String pathInfo, PrintWriter pw) throws IOException {
        try {
            Boolean level2 = pathInfo.contains("level2");
            int level = level2 != false ? 2 : 3;
            String serviceBase = "";
            if (ServerMethods.p_xml_i.matcher(qp.acceptType).find()) {
                serviceBase = "/thredds/dodsC/" + pathInfo + "/";
                pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                pw.print("<catalog xmlns=\"http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0\"");
                pw.println(" xmlns:xlink=\"http://www.w3.org/1999/xlink\" name=\"Radar Level" + level + " datasets in near real time\" version=\"" + "1.0.1\">");
                pw.println("");
                pw.print("  <service name=\"OPENDAP\" serviceType=\"OPENDAP\"");
                pw.println(" base=\"" + serviceBase + "\"/>");
                pw.print("    <dataset name=\"RadarLevel" + level + " datasets for available stations and times\" collectionType=\"TimeSeries\" ID=\"" + "accept=" + qp.acceptType + "&amp;");
                if (!level2.booleanValue() && qp.vars != null) {
                    pw.print("var=");
                    for (int i = 0; i < qp.vars.size(); ++i) {
                        pw.print(qp.vars.get(i));
                        if (i >= qp.vars.size() - 1) continue;
                        pw.print(",");
                    }
                    pw.print("&amp;");
                }
                if (qp.stns.get(0).toUpperCase().equals("ALL")) {
                    pw.print("stn=ALL&amp;");
                } else if (qp.hasStns) {
                    for (String station : qp.stns) {
                        pw.print("stn=" + station + "&amp;");
                    }
                } else if (qp.hasBB) {
                    pw.print("south=" + qp.south + "&amp;north=" + qp.north + "&amp;");
                    pw.print("west=" + qp.west + "&amp;east=" + qp.east + "&amp;");
                }
                if (qp.hasDateRange) {
                    if (qp.time_start.getDate() == null || qp.time_start.isBlank() || qp.time_end.getDate() == null || qp.time_end.isBlank()) {
                        pw.println("time_start=" + qp.time_start.toString() + "&amp;time_end=" + qp.time_end.toString() + "\">");
                        pw.println("<documentation>need ISO time</documentation>\n");
                        pw.println("    </dataset>");
                        pw.println("</catalog>");
                        return false;
                    }
                    pw.println("time_start=" + qp.time_start.toDateTimeStringISO() + "&amp;time_end=" + qp.time_end.toDateTimeStringISO() + "\">");
                } else if (qp.time.isPresent()) {
                    pw.println("time=present\">");
                } else if (qp.hasTimePoint) {
                    if (qp.time.getDate() == null || qp.time.isBlank()) {
                        pw.println("time=" + qp.time.toString() + "\">");
                        pw.println("<documentation>need ISO time</documentation>\n");
                        pw.println("    </dataset>");
                        pw.println("</catalog>");
                        return false;
                    }
                    pw.println("time=" + qp.time.toDateTimeStringISO() + "\">");
                } else {
                    pw.println("\">");
                }
                pw.println("    <metadata inherited=\"true\">");
                pw.println("      <dataType>Radial</dataType>");
                pw.print("      <dataFormat>");
                if (level2.booleanValue()) {
                    pw.print("NEXRAD2");
                } else if (radarType.equals((Object)RadarServer.RadarType.nexrad)) {
                    pw.print("NIDS");
                } else {
                    pw.print("TDWR");
                }
                pw.println("</dataFormat>");
                pw.println("      <serviceName>OPENDAP</serviceName>");
                pw.println("    </metadata>");
                pw.println();
            } else if (ServerMethods.p_html_i.matcher(qp.acceptType).find()) {
                pw.println("<Head><Title>THREDDS RadarNexrad Server</Title></Head>");
                pw.println("<body>");
                pw.println("<center><H1>Nexrad Level" + level + " Radar Results</H1></center>");
                pw.println("  <table align=\"center\" border cellpadding=\"5\" width=\"90%\">");
                pw.println("    <tr>");
                pw.println("    <th scope=\"col\"><u>OPENDAP</u></th>");
                pw.println("    <th scope=\"col\"><u>HTTPServer</u></th>");
                pw.println("    </tr>");
                serviceBase = pathInfo + "/";
            } else if (ServerMethods.p_ascii_i.matcher(qp.acceptType).find()) {
                pw.println("<documentation>\n");
                pw.println("Request not implemented: " + pathInfo);
                pw.println("</documentation>\n");
                pw.println("<documentation>need ISO time</documentation>\n");
                pw.println("    </dataset>");
                pw.println("</catalog>");
                return false;
            }
            if (this.isStationListEmpty(qp.stns, radarType)) {
                pw.println("      <documentation>No data available for station(s) and time range</documentation>");
                pw.println("    </dataset>");
                pw.println("</catalog>");
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private Boolean processQuery(String tdir, QueryParams qp, PrintWriter pw, String serviceBase, RadarServer.RadarType radarType) throws IOException {
        int numProds = 0;
        try {
            String yyyymmddStart = qp.time_start.toDateString();
            yyyymmddStart = yyyymmddStart.replace("-", "");
            String yyyymmddEnd = qp.time_end.toDateString();
            yyyymmddEnd = yyyymmddEnd.replace("-", "");
            String dateStart = yyyymmddStart + "_" + this.sm.hhmm(qp.time_start.toDateTimeString());
            String dateEnd = yyyymmddEnd + "_" + this.sm.hhmm(qp.time_end.toDateTimeString());
            File files = new File(tdir);
            String[] tdirs = files.list();
            if (tdirs == null) {
                return false;
            }
            ArrayList<String> tmp = new ArrayList<String>();
            for (String name : tdirs) {
                if (name.startsWith(".")) continue;
                tmp.add(name);
            }
            if (tdirs.length != tmp.size()) {
                tdirs = new String[tmp.size()];
                tdirs = tmp.toArray(tdirs);
            }
            Boolean isStns = this.isStation(tdirs[0], radarType);
            Boolean isDates = ServerMethods.p_yyyymmdd.matcher(tdirs[0]).find();
            Boolean isVars = this.isVar(tdirs[0].toUpperCase(), radarType);
            if (!(isStns.booleanValue() || isDates.booleanValue() || isVars.booleanValue())) {
                this.log.error("processQuery error, no valid stn, date, or var " + qp.toString());
                pw.println("<documentation>\n");
                pw.println("Query can't be satisfied :<![CDATA[" + qp.toString() + "]]>\n");
                pw.println("</documentation>\n");
                return numProds > 0;
            }
            if (isStns.booleanValue()) {
                block3: for (String station : qp.stns) {
                    String[] sdirs;
                    String sDir = tdir + '/' + station;
                    files = new File(sDir);
                    if (!files.exists() || (sdirs = files.list()) == null) continue;
                    File file = new File(sDir + "/" + sdirs[0]);
                    if (file.isFile()) {
                        numProds += this.processProducts(sdirs, sDir.substring(tdir.length() + 1), dateStart, dateEnd, qp, pw, serviceBase);
                        continue;
                    }
                    if (ServerMethods.p_yyyymmdd.matcher(sdirs[0]).find()) {
                        Arrays.sort(sdirs, new CompareKeyDescend());
                        for (int j = 0; j < sdirs.length; ++j) {
                            if (!this.sm.isValidDay(sdirs[j], yyyymmddStart, yyyymmddEnd)) continue;
                            String dDir = sDir + "/" + sdirs[j];
                            files = new File(dDir);
                            String[] ndirs = files.list();
                            file = new File(dDir + "/" + ndirs[0]);
                            if (file.isFile()) {
                                numProds += this.processProducts(ndirs, dDir.substring(tdir.length() + 1), dateStart, dateEnd, qp, pw, serviceBase);
                                if (!qp.hasTimePoint) continue;
                                continue block3;
                            }
                            if (!nexradVars.contains(ndirs[0].toUpperCase())) continue;
                        }
                        continue;
                    }
                    if (!nexradVars.contains(sdirs[0].toUpperCase()) && !terminalVars.contains(sdirs[0].toUpperCase())) continue;
                    if (qp.vars == null) {
                        return false;
                    }
                    for (String variable : qp.vars) {
                        String vDir = sDir + '/' + variable;
                        files = new File(vDir);
                        String[] vdirs = files.list();
                        file = new File(vDir + "/" + vdirs[0]);
                        if (!file.isFile()) continue;
                        numProds += this.processProducts(vdirs, vDir.substring(tdir.length() + 1), dateStart, dateEnd, qp, pw, serviceBase);
                    }
                }
            } else if (!isDates.booleanValue()) {
                if (isVars.booleanValue()) {
                    if (qp.vars == null) {
                        return false;
                    }
                    for (String variable : qp.vars) {
                        String vDir = tdir + '/' + variable;
                        files = new File(vDir);
                        String[] vdirs = files.list();
                        File file = new File(vDir + "/" + vdirs[0]);
                        if (file.isFile()) {
                            numProds += this.processProducts(vdirs, vDir.substring(tdir.length() + 1), dateStart, dateEnd, qp, pw, serviceBase);
                            continue;
                        }
                        if (!this.isStation(vdirs[0], radarType)) continue;
                        block7: for (String station : qp.stns) {
                            String[] sdirs;
                            String sDir = vDir + '/' + station;
                            files = new File(sDir);
                            if (!files.exists() || (sdirs = files.list()) == null) continue;
                            file = new File(sDir + "/" + sdirs[0]);
                            if (file.isFile()) {
                                numProds += this.processProducts(sdirs, sDir.substring(tdir.length() + 1), dateStart, dateEnd, qp, pw, serviceBase);
                                continue;
                            }
                            if (!ServerMethods.p_yyyymmdd.matcher(sdirs[0]).find()) continue;
                            Arrays.sort(sdirs, new CompareKeyDescend());
                            for (int k = 0; k < sdirs.length; ++k) {
                                if (!this.sm.isValidDay(sdirs[k], yyyymmddStart, yyyymmddEnd)) continue;
                                String dDir = sDir + "/" + sdirs[k];
                                files = new File(dDir);
                                String[] ddirs = files.list();
                                numProds += this.processProducts(ddirs, dDir.substring(tdir.length() + 1), dateStart, dateEnd, qp, pw, serviceBase);
                                if (qp.hasTimePoint) continue block7;
                            }
                        }
                    }
                } else {
                    return numProds > 0;
                }
            }
            return numProds > 0;
        }
        catch (Exception e) {
            this.log.error("radarServer processQuery error");
            pw.println("<documentation>\n");
            pw.println("Query can't be satisfied :<![CDATA[" + qp.toString() + "]]>\n");
            pw.println("</documentation>\n");
            return numProds > 0;
        }
    }

    private int processProducts(String[] products, String rPath, String dateStart, String dateEnd, QueryParams qp, PrintWriter pw, String serviceBase) throws Exception {
        Boolean latest = qp.hasTimePoint;
        boolean allTimes = !qp.hasTimePoint && !qp.hasDateRange;
        Arrays.sort(products, new CompareKeyDescend());
        int numProducts = 0;
        if (ServerMethods.p_xml_i.matcher(qp.acceptType).find()) {
            for (int t = 0; t < products.length; ++t) {
                if (products[t].startsWith(".") || !allTimes && !this.sm.isValidDate(products[t], dateStart, dateEnd)) continue;
                ++numProducts;
                this.XMLdataset(products[t], rPath, pw);
                if (!latest.booleanValue()) {
                    continue;
                }
                break;
            }
        } else {
            for (int t = 0; t < products.length; ++t) {
                if (products[t].startsWith(".") || !allTimes && !this.sm.isValidDate(products[t], dateStart, dateEnd)) continue;
                ++numProducts;
                this.HTMLdataset(products[t], rPath, pw, serviceBase);
                if (!latest.booleanValue()) {
                    continue;
                }
                break;
            }
        }
        return numProducts;
    }

    public void XMLdataset(String product, String rPath, PrintWriter pw) throws IOException {
        pw.println("      <dataset name=\"" + product + "\" ID=\"" + product.hashCode() + "\"");
        String pDate = this.sm.getObTimeISO(product);
        pw.print("        urlPath=\"");
        pw.println(rPath + "/" + product + "\">");
        pw.println("        <date type=\"start of ob\">" + pDate + "</date>");
        pw.println("      </dataset>");
    }

    public void HTMLdataset(String product, String rPath, PrintWriter pw, String serviceBase) throws IOException {
        pw.println("  <tr>");
        pw.println("    <td align=center valign=center><a href=\"/thredds/dodsC/" + serviceBase + rPath + "/" + product + ".html\">" + product + "</a></td>");
        pw.println("    <td align=center valign=center><a href=\"/thredds/fileServer/" + serviceBase + rPath + "/" + product + "\">" + product + "</a></td>");
        pw.println("  </tr>");
    }

    public Document makeStationDocument(Document doc, Element rootElem, String[] stations, RadarServer.RadarType radarType) throws Exception {
        for (String s : stations) {
            Station stn = this.getStation(s, radarType);
            Element sElem = new Element("station");
            if (stn == null) {
                sElem.setAttribute("id", s);
                sElem.setAttribute("state", "XXX");
                sElem.setAttribute("country", "XX");
                sElem.addContent((Content)new Element("name").addContent("Unknown"));
                sElem.addContent((Content)new Element("longitude").addContent("0.0"));
                sElem.addContent((Content)new Element("latitude").addContent("0.0"));
                sElem.addContent((Content)new Element("elevation").addContent("0"));
                rootElem.addContent((Content)sElem);
                continue;
            }
            sElem.setAttribute("id", s);
            if (stn.getState() != null) {
                sElem.setAttribute("state", stn.getState());
            }
            if (stn.getCountry() != null) {
                sElem.setAttribute("country", stn.getCountry());
            }
            if (stn.getName() != null) {
                sElem.addContent((Content)new Element("name").addContent(stn.getName()));
            }
            sElem.addContent((Content)new Element("longitude").addContent(Format.d((double)stn.getLocation().getLongitude(), (int)6)));
            sElem.addContent((Content)new Element("latitude").addContent(Format.d((double)stn.getLocation().getLatitude(), (int)6)));
            if (!Double.isNaN(stn.getLocation().getElevation())) {
                sElem.addContent((Content)new Element("elevation").addContent(Format.d((double)stn.getLocation().getElevation(), (int)6)));
            }
            rootElem.addContent((Content)sElem);
        }
        return doc;
    }

    public String[] stationsDS(RadarServer.RadarType radarType, String path) throws Exception {
        String[] stations = null;
        if (path != null) {
            File files = new File(path);
            stations = files.list();
            ArrayList<String> tmp = new ArrayList<String>();
            for (String station : stations) {
                if (station.startsWith(".")) continue;
                tmp.add(station);
            }
            if (stations.length != tmp.size()) {
                stations = new String[tmp.size()];
                stations = tmp.toArray(stations);
            }
            if (this.isVar(stations[0].toUpperCase(), radarType)) {
                if (radarType.equals((Object)RadarServer.RadarType.nexrad)) {
                    path = path + "/" + nexradVars.get(0);
                    files = new File(path);
                    stations = files.list();
                } else {
                    path = path + "/" + terminalVars.get(0);
                    files = new File(path);
                    stations = files.list();
                }
            }
        }
        if (stations == null || stations.length == 0) {
            stations = new String[1];
            stations = radarType.equals((Object)RadarServer.RadarType.nexrad) ? nexradMap.keySet().toArray(stations) : terminalMap.keySet().toArray(stations);
        }
        return stations;
    }

    public void printStations(String[] stations, PrintWriter pw, RadarServer.RadarType radarType) throws Exception {
        for (String s : stations) {
            Station stn = this.getStation(s, radarType);
            if (stn == null) {
                pw.println("   <station id=\"" + s + "\" state=\"XX\" country=\"XX\">");
                pw.println("      <name>Unknown</name>");
                pw.println("      <latitude>0.0</latitude>");
                pw.println("      <longitude>0.0</longitude>");
                pw.println("      <elevation>0.0</elevation>");
                pw.println("   </station>");
                continue;
            }
            pw.println("   <station id=\"" + s + "\" state=\"" + stn.getState() + "\" country=\"" + stn.getCountry() + "\">");
            pw.println("      <name>" + stn.getName() + "</name>");
            pw.println("      <latitude>" + Format.d((double)stn.getLocation().getLatitude(), (int)6) + "</latitude>");
            pw.println("      <longitude>" + Format.d((double)stn.getLocation().getLongitude(), (int)6) + "</longitude>");
            if (!Double.isNaN(stn.getLocation().getElevation())) {
                pw.println("      <elevation>" + Format.d((double)stn.getLocation().getElevation(), (int)6) + "</elevation>");
            }
            pw.println("   </station>");
        }
    }

    public boolean isStationListEmpty(List<String> stations, RadarServer.RadarType radarType) {
        if (stations.get(0).toUpperCase().equals("ALL")) {
            return false;
        }
        for (String s : stations) {
            if (!this.isStation(s, radarType)) continue;
            return false;
        }
        return true;
    }

    public boolean isStation(String station, RadarServer.RadarType radarType) {
        if (station.toUpperCase().equals("ALL")) {
            return true;
        }
        Station stn = null;
        if (station.length() == 3 && radarType.equals((Object)RadarServer.RadarType.terminal)) {
            stn = terminalMap.get("T" + station);
        } else if (station.length() == 3) {
            for (Station stn3 : nexradList) {
                if (!stn3.getValue().endsWith(station)) continue;
                stn = stn3;
                break;
            }
        } else {
            stn = radarType.equals((Object)RadarServer.RadarType.terminal) ? terminalMap.get(station) : nexradMap.get(station);
        }
        return stn != null;
    }

    public Station getStation(String station, RadarServer.RadarType radarType) {
        Station stn = null;
        if (station.length() == 3 && radarType.equals((Object)RadarServer.RadarType.terminal)) {
            stn = terminalMap.get("T" + station);
        } else if (station.length() == 3) {
            for (Station stn3 : nexradList) {
                if (!stn3.getValue().endsWith(station)) continue;
                stn = stn3;
                break;
            }
        } else {
            stn = radarType.equals((Object)RadarServer.RadarType.terminal) ? terminalMap.get(station) : nexradMap.get(station);
        }
        return stn;
    }

    public String[] getStations(RadarServer.RadarType radarType) {
        String[] stn = null;
        if (radarType.equals((Object)RadarServer.RadarType.nexrad)) {
            stn = new String[nexradList.size()];
            stn = nexradList.toArray(stn);
        } else if (radarType.equals((Object)RadarServer.RadarType.terminal)) {
            stn = new String[terminalList.size()];
            stn = terminalList.toArray(stn);
        }
        return stn;
    }

    public boolean isVar(String var, RadarServer.RadarType radarType) {
        if (var.toUpperCase().equals("ALL")) {
            return true;
        }
        if (nexradVars.contains(var)) {
            return true;
        }
        return terminalVars.contains(var);
    }

    public String getStartDateTime(String path) throws Exception {
        String timeDir = RadarServer.dataLocation.get(path);
        this.log.debug("timeDir =" + timeDir);
        if (path.contains("level3")) {
            timeDir = timeDir + "/N0R/TLX";
        } else if (path.contains("level2")) {
            timeDir = timeDir + "/KTLX";
        }
        File dir = new File(timeDir);
        String[] files = dir.list();
        Arrays.sort(files, new CompareKeyDescend());
        String year = files[files.length - 1].substring(0, 4);
        String month = files[files.length - 1].substring(4, 6);
        String day = files[files.length - 1].substring(6, 8);
        this.log.debug(year + "-" + month + "-" + day + "T:00:00:00Z");
        return year + "-" + month + "-" + day + "T:00:00:00Z";
    }

    public static void main(String[] args) throws IOException {
        try {
            DateType dte = new DateType("present", null, null);
            DateType dts = new DateType("1970-01-01T00:00:00", null, null);
            System.out.println("DateType = (" + dts.toString() + ")");
            System.out.println("Date = (" + dts.getDate() + ")");
        }
        catch (ParseException e) {
            System.out.println("Illegal param= 'time' must be valid ISO Duration\n");
        }
    }

    static {
        nexradVars = new ArrayList();
        terminalVars = new ArrayList();
    }

    protected class CompareKeyDescend
    implements Comparator<String> {
        protected CompareKeyDescend() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s2.compareTo(s1);
        }
    }
}

