/*
 * Decompiled with CFR 0.152.
 */
package thredds.util.filesource;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.StringUtils;
import thredds.util.filesource.BasicDescendantFileSource;
import thredds.util.filesource.DescendantFileSource;

public class BasicWithExclusionsDescendantFileSource
implements DescendantFileSource {
    private final BasicDescendantFileSource root;
    private final List<BasicDescendantFileSource> exclusions;

    public BasicWithExclusionsDescendantFileSource(String rootDirectoryPath, List<String> exclusions) {
        if (exclusions == null) {
            throw new IllegalArgumentException("Exclusion list must not be null.");
        }
        if (exclusions.isEmpty()) {
            throw new IllegalArgumentException("Exclusion list must not be empty.");
        }
        this.root = new BasicDescendantFileSource(rootDirectoryPath);
        this.exclusions = this.initExclusions(exclusions);
    }

    public BasicWithExclusionsDescendantFileSource(File rootDirectory, List<String> exclusions) {
        if (exclusions == null) {
            throw new IllegalArgumentException("Exclusion list must not be null.");
        }
        if (exclusions.isEmpty()) {
            throw new IllegalArgumentException("Exclusion list must not be empty.");
        }
        this.root = new BasicDescendantFileSource(rootDirectory);
        this.exclusions = this.initExclusions(exclusions);
    }

    private List<BasicDescendantFileSource> initExclusions(List<String> exclusions) {
        ArrayList<BasicDescendantFileSource> list = new ArrayList<BasicDescendantFileSource>();
        for (String curDfsRdp : exclusions) {
            if (curDfsRdp == null) {
                throw new IllegalArgumentException("Exclusion list may not contain null items.");
            }
            BasicDescendantFileSource bdfs = (BasicDescendantFileSource)this.root.getDescendant(curDfsRdp);
            if (bdfs == null) {
                throw new IllegalArgumentException("Exclusion [" + curDfsRdp + "] was null, not relative, or not descendant of root.");
            }
            list.add(bdfs);
        }
        return list;
    }

    @Override
    public File getFile(String path) {
        File file = this.root.getFile(path);
        for (BasicDescendantFileSource curBdfs : this.exclusions) {
            if (!curBdfs.getRootDirectory().equals(file) && !curBdfs.isDescendant(file)) continue;
            return null;
        }
        return file;
    }

    @Override
    public DescendantFileSource getDescendant(String relativePath) {
        DescendantFileSource dfs = this.root.getDescendant(relativePath);
        for (BasicDescendantFileSource curBdfs : this.exclusions) {
            if (!curBdfs.getRootDirectory().equals(dfs.getRootDirectory()) && !curBdfs.isDescendant(dfs.getRootDirectory())) continue;
            return null;
        }
        return dfs;
    }

    @Override
    public File getRootDirectory() {
        return this.root.getRootDirectory();
    }

    @Override
    public String getRootDirectoryPath() {
        return this.root.getRootDirectoryPath();
    }

    @Override
    public boolean isDescendant(File file) {
        if (!this.root.isDescendant(file)) {
            return false;
        }
        for (BasicDescendantFileSource curBdfs : this.exclusions) {
            if (!curBdfs.getRootDirectory().equals(this.getCleanAbsoluteFile(file)) && !curBdfs.isDescendant(file)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDescendant(String filePath) {
        return filePath != null && this.isDescendant(new File(filePath));
    }

    @Override
    public String getRelativePath(File file) {
        for (BasicDescendantFileSource curBdfs : this.exclusions) {
            if (!curBdfs.getRootDirectory().equals(this.getCleanAbsoluteFile(file)) && !curBdfs.isDescendant(file)) continue;
            return null;
        }
        return this.root.getRelativePath(file);
    }

    @Override
    public String getRelativePath(String filePath) {
        if (filePath == null) {
            return null;
        }
        return this.getRelativePath(new File(filePath));
    }

    private File getCleanAbsoluteFile(File file) {
        return new File(StringUtils.cleanPath((String)file.getAbsolutePath()).trim());
    }
}

