/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.dataservice;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.transform.JDOMResult;
import org.jdom2.transform.JDOMSource;
import org.jdom2.xpath.XPath;
import org.springframework.stereotype.Service;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.support.ServletContextResource;
import thredds.server.config.FormatsAvailabilityService;
import thredds.server.ncss.dataservice.NcssShowFeatureDatasetInfo;
import thredds.server.ncss.format.SupportedFormat;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.grid.GridDatasetInfo;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.point.writer.FeatureDatasetPointXML;

@Service
public class NcssShowDatasetInfoImpl
implements NcssShowFeatureDatasetInfo,
ServletContextAware {
    private ServletContext servletContext;

    @Override
    public String showForm(FeatureDataset fd, String datasetUrlPath, boolean wantXml, boolean isPoint) throws IOException, TransformerException, JDOMException {
        FeatureType ft = fd.getFeatureType();
        String strResponse = "";
        switch (ft) {
            case GRID: {
                strResponse = this.showGridForm((GridDataset)fd, datasetUrlPath, wantXml, isPoint);
                break;
            }
            case STATION: {
                strResponse = this.showPointForm((FeatureDatasetPoint)fd, datasetUrlPath, wantXml, "/WEB-INF/xsl/ncssSobs.xsl");
                break;
            }
            case POINT: {
                strResponse = this.showPointForm((FeatureDatasetPoint)fd, datasetUrlPath, wantXml, "/WEB-INF/xsl/ncssPobs.xsl");
                break;
            }
        }
        return strResponse;
    }

    private String showPointForm(FeatureDatasetPoint fp, String datasetUrlPath, boolean wantXml, String xslt) throws IOException, TransformerException, JDOMException {
        FeatureDatasetPointXML xmlWriter = new FeatureDatasetPointXML(fp, datasetUrlPath);
        Document doc = xmlWriter.getCapabilitiesDocument();
        if (FormatsAvailabilityService.isFormatAvailable(SupportedFormat.NETCDF4)) {
            String xPathForGridElement = "capabilities/AcceptList";
            this.addElement(doc, xPathForGridElement, new Element("accept").addContent("netcdf4").setAttribute("displayName", "CF/NetCDF-4"));
        }
        if (wantXml) {
            XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
            return fmt.outputString(doc);
        }
        InputStream is = this.getXSLT(xslt);
        Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(is));
        String context = this.servletContext.getContextPath();
        transformer.setParameter("tdsContext", context);
        JDOMSource in = new JDOMSource(doc);
        JDOMResult out = new JDOMResult();
        transformer.transform((Source)in, (Result)out);
        Document html = out.getDocument();
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        return fmt.outputString(html);
    }

    private String showGridForm(GridDataset gds, String datsetUrlPath, boolean wantXml, boolean isPoint) throws IOException, TransformerException, JDOMException {
        boolean formatAvailable = FormatsAvailabilityService.isFormatAvailable(SupportedFormat.NETCDF4);
        GridDatasetInfo writer = new GridDatasetInfo(gds, "path");
        if (wantXml) {
            Document datasetDescription = writer.makeDatasetDescription();
            Element root = datasetDescription.getRootElement();
            root.setAttribute("location", datsetUrlPath);
            if (formatAvailable) {
                this.addNetcdf4Format(datasetDescription, "/gridDataset");
            }
            return writer.writeXML(datasetDescription);
        }
        InputStream xslt = this.getXSLT(isPoint ? "/WEB-INF/xsl/ncssGridAsPoint.xsl" : "/WEB-INF/xsl/ncssGrid.xsl");
        Document doc = writer.makeGridForm();
        if (formatAvailable) {
            this.addNetcdf4Format(doc, "/gridForm");
        }
        Element root = doc.getRootElement();
        root.setAttribute("location", datsetUrlPath);
        Transformer xslTransformer = TransformerFactory.newInstance().newTransformer(new StreamSource(xslt));
        String context = this.servletContext.getContextPath();
        xslTransformer.setParameter("tdsContext", context);
        xslTransformer.setParameter("gridWKT", writer.getDatasetBoundariesWKT());
        JDOMSource in = new JDOMSource(doc);
        JDOMResult out = new JDOMResult();
        xslTransformer.transform((Source)in, (Result)out);
        Document html = out.getDocument();
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        return fmt.outputString(html);
    }

    private InputStream getXSLT(String xslName) throws IOException {
        ServletContextResource r = new ServletContextResource(this.servletContext, xslName);
        return r.getInputStream();
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    private void addNetcdf4Format(Document datasetDescriptionDoc, String rootElementName) throws JDOMException {
        String xPathForGridElement = rootElementName + "/AcceptList/Grid";
        this.addElement(datasetDescriptionDoc, xPathForGridElement, new Element("accept").addContent("netcdf4").setAttribute("displayName", "netcdf4"));
        String xPathForGridAsPointElement = rootElementName + "/AcceptList/GridAsPoint";
        this.addElement(datasetDescriptionDoc, xPathForGridAsPointElement, new Element("accept").addContent("netcdf4").setAttribute("displayName", "netcdf4"));
    }

    private void addElement(Document datasetDescriptionDoc, String xPath, Element element) throws JDOMException {
        XPath gridXpath = XPath.newInstance((String)xPath);
        Element acceptListParent = (Element)gridXpath.selectSingleNode((Object)datasetDescriptionDoc);
        acceptListParent.addContent((Content)element);
    }
}

