/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cdmremote;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.LastModified;
import thredds.server.AbstractController;
import thredds.server.cdmremote.CdmRemoteQueryBean;
import thredds.server.config.TdsContext;
import thredds.servlet.DataRootHandler;
import thredds.servlet.DatasetHandler;
import thredds.servlet.ServletUtil;
import thredds.util.ContentType;
import thredds.util.TdsPathUtils;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.stream.NcStreamWriter;
import ucar.nc2.util.EscapeStrings;

@Controller
@RequestMapping(value={"/cdmremote"})
public class CdmRemoteController
extends AbstractController
implements LastModified {
    private static final Logger log = LoggerFactory.getLogger(CdmRemoteController.class);
    private static final boolean debug = false;
    private static final boolean showReq = false;
    @Autowired
    TdsContext tdsContext;
    private boolean allow = true;

    public void setTdsContext(TdsContext tdsContext) {
        this.tdsContext = tdsContext;
    }

    public void setAllow(boolean allow) {
        this.allow = allow;
    }

    @Override
    protected String getControllerPath() {
        return "/cdmremote/";
    }

    @Override
    protected String[] getEndings() {
        return new String[0];
    }

    public long getLastModified(HttpServletRequest req) {
        String path = TdsPathUtils.extractPath(req, "wcs/");
        File file = DataRootHandler.getInstance().getCrawlableDatasetAsFile(path);
        if (file != null && file.exists()) {
            return file.lastModified();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"**"})
    public void handleRequest(HttpServletRequest req, HttpServletResponse res, @Valid CdmRemoteQueryBean qb, BindingResult validationResult) throws IOException {
        if (!this.allow) {
            res.sendError(403, "Service not supported");
            return;
        }
        String datasetPath = this.getDatasetPath(req);
        String absPath = this.getAbsolutePath(req);
        if (!qb.validate()) {
            res.sendError(400, qb.getErrorMessage());
            return;
        }
        NetcdfFile ncfile = null;
        try {
            ncfile = DatasetHandler.getNetcdfFile(req, res, datasetPath);
            if (ncfile == null) {
                res.setStatus(404);
                log.debug("DatasetHandler.FAIL path={}", (Object)datasetPath);
                return;
            }
            long size = -1L;
            switch (qb.getRequestType()) {
                case capabilities: {
                    res.setContentType(ContentType.xml.getContentHeader());
                    PrintWriter pw = res.getWriter();
                    FeatureType ftFromMetadata = FeatureDatasetFactoryManager.findFeatureType((NetcdfFile)ncfile);
                    this.sendCapabilities(pw, ftFromMetadata, absPath);
                    res.flushBuffer();
                    return;
                }
                case form: 
                case cdl: {
                    res.setContentType(ContentType.text.getContentHeader());
                    PrintWriter pw = res.getWriter();
                    ncfile.setLocation(datasetPath);
                    String cdl = ncfile.toString();
                    res.setContentLength(cdl.length());
                    pw.write(cdl);
                    size = cdl.length();
                    break;
                }
                case ncml: {
                    res.setContentType(ContentType.xml.getContentHeader());
                    PrintWriter pw = res.getWriter();
                    ncfile.writeNcML((Writer)pw, absPath);
                    break;
                }
                case header: {
                    res.setContentType(ContentType.binary.getContentHeader());
                    res.setHeader("Content-Description", "ncstream");
                    BufferedOutputStream out = new BufferedOutputStream((OutputStream)res.getOutputStream(), 10000);
                    NcStreamWriter ncWriter = new NcStreamWriter(ncfile, ServletUtil.getRequestBase(req));
                    size = ncWriter.sendHeader((OutputStream)out);
                    ((OutputStream)out).flush();
                    break;
                }
                default: {
                    res.setContentType(ContentType.binary.getContentHeader());
                    res.setHeader("Content-Description", "ncstream");
                    size = 0L;
                    NcStreamWriter ncWriter = new NcStreamWriter(ncfile, ServletUtil.getRequestBase(req));
                    String query = qb.getVar() != null ? qb.getVar() : req.getQueryString();
                    if (query == null || query.length() == 0) {
                        res.sendError(400, "must have query string");
                        return;
                    }
                    BufferedOutputStream out = new BufferedOutputStream((OutputStream)res.getOutputStream(), 10000);
                    query = EscapeStrings.unescapeURLQuery((String)query);
                    StringTokenizer stoke = new StringTokenizer(query, ";");
                    while (stoke.hasMoreTokens()) {
                        ParsedSectionSpec cer = ParsedSectionSpec.parseVariableSection((NetcdfFile)ncfile, (String)stoke.nextToken());
                        size += ncWriter.sendData(cer.v, cer.section, (OutputStream)out, false);
                    }
                    ((OutputStream)out).flush();
                }
            }
            res.flushBuffer();
        }
        catch (FileNotFoundException e) {
            log.debug("FAIL", (Throwable)e);
            res.sendError(404, e.getMessage());
        }
        catch (IllegalArgumentException | InvalidRangeException e) {
            res.sendError(400, e.getMessage());
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            res.sendError(500, e.getMessage());
        }
        finally {
            if (null != ncfile) {
                try {
                    ncfile.close();
                }
                catch (IOException ioe) {
                    log.error("Failed to close = " + datasetPath);
                }
            }
        }
    }

    private void sendCapabilities(PrintWriter pw, FeatureType ft, String absPath) throws IOException {
        Element rootElem = new Element("cdmRemoteCapabilities");
        Document doc = new Document(rootElem);
        rootElem.setAttribute("location", absPath);
        Element elem = new Element("featureDataset");
        if (ft != null) {
            elem.setAttribute("type", ft.toString());
        }
        elem.setAttribute("url", absPath);
        rootElem.addContent((Content)elem);
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        fmt.output(doc, (Writer)pw);
    }
}

