/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.gridaspoint;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import thredds.server.ncss.util.NcssRequestUtils;
import thredds.server.ncss.view.gridaspoint.PointDataWriter;
import thredds.util.ContentType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridAsPointDataset;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.geoloc.LatLonPoint;

class XMLPointDataWriter
implements PointDataWriter {
    private static Logger log = LoggerFactory.getLogger(XMLPointDataWriter.class);
    private Map<String, List<String>> allVars;
    private Map<String, GridAsPointDataset> gridAsPointDatasets = new HashMap<String, GridAsPointDataset>();
    private XMLStreamWriter xmlStreamWriter;
    private HttpHeaders httpHeaders = new HttpHeaders();

    public static XMLPointDataWriter factory(OutputStream os) {
        return new XMLPointDataWriter(os);
    }

    private XMLPointDataWriter(OutputStream os) {
        this.xmlStreamWriter = this.createXMLStreamWriter(os);
    }

    @Override
    public boolean header(Map<String, List<String>> groupedVars, GridDataset gridDataset, List<CalendarDate> wDates, List<Attribute> timeDimAtts, LatLonPoint point, Double vertCoord) {
        this.allVars = groupedVars;
        for (Map.Entry<String, List<String>> entry : groupedVars.entrySet()) {
            this.gridAsPointDatasets.put(entry.getKey(), NcssRequestUtils.buildGridAsPointDataset(gridDataset, entry.getValue()));
        }
        boolean headerWritten = false;
        try {
            this.xmlStreamWriter.writeStartDocument("UTF-8", "1.0");
            this.xmlStreamWriter.writeStartElement("grid");
            this.xmlStreamWriter.writeAttribute("dataset", gridDataset.getLocationURI());
            headerWritten = true;
        }
        catch (XMLStreamException xse) {
            log.error("Error writting xml header", (Throwable)xse);
        }
        return headerWritten;
    }

    private boolean write(List<String> groupsKeys, GridDataset gridDataset, CalendarDate date, LatLonPoint point, Double targetLevel) throws InvalidRangeException {
        boolean allDone = true;
        for (String key : groupsKeys) {
            List<String> varsGroup = this.allVars.get(key);
            GridAsPointDataset gap = this.gridAsPointDatasets.get(key);
            CoordinateAxis1D verticalAxisForGroup = gridDataset.findGridDatatype(varsGroup.get(0)).getCoordinateSystem().getVerticalAxis();
            if (verticalAxisForGroup == null) {
                allDone = allDone && this.write(varsGroup, gridDataset, gap, date, point);
                continue;
            }
            if (targetLevel != null) {
                Double vertCoord = NcssRequestUtils.getTargetLevelForVertCoord(verticalAxisForGroup, targetLevel);
                allDone = this.write(varsGroup, gridDataset, gap, date, point, vertCoord, verticalAxisForGroup.getUnitsString());
                continue;
            }
            double[] arr$ = verticalAxisForGroup.getCoordValues();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Double vertCoord = arr$[i$];
                if (verticalAxisForGroup.getCoordValues().length == 1) {
                    vertCoord = NcssRequestUtils.getTargetLevelForVertCoord(verticalAxisForGroup, vertCoord);
                }
                allDone = allDone && this.write(varsGroup, gridDataset, gap, date, point, vertCoord, verticalAxisForGroup.getUnitsString());
            }
        }
        return allDone;
    }

    @Override
    public boolean write(Map<String, List<String>> groupedVars, GridDataset gds, List<CalendarDate> wDates, LatLonPoint point, Double vertCoord) throws InvalidRangeException {
        Iterator<CalendarDate> it = wDates.iterator();
        boolean pointRead = true;
        ArrayList<String> keysAsList = new ArrayList<String>(groupedVars.keySet());
        if (wDates.isEmpty()) {
            pointRead = this.write(keysAsList, gds, point, vertCoord);
        } else {
            while (pointRead && it.hasNext()) {
                CalendarDate date = it.next();
                pointRead = this.write(keysAsList, gds, date, point, vertCoord);
            }
        }
        return pointRead;
    }

    private boolean write(List<String> groupsKeys, GridDataset gds, LatLonPoint point, Double targetLevel) {
        boolean allDone = true;
        for (String key : groupsKeys) {
            List<String> varsGroup = this.allVars.get(key);
            GridAsPointDataset gap = this.gridAsPointDatasets.get(key);
            CoordinateAxis1D verticalAxisForGroup = gds.findGridDatatype(varsGroup.get(0)).getCoordinateSystem().getVerticalAxis();
            if (verticalAxisForGroup == null) {
                allDone = allDone && this.write(varsGroup, gds, gap, point);
                continue;
            }
            if (targetLevel != null) {
                Double vertCoord = NcssRequestUtils.getTargetLevelForVertCoord(verticalAxisForGroup, targetLevel);
                allDone = this.write(varsGroup, gds, gap, point, vertCoord, verticalAxisForGroup.getUnitsString());
                continue;
            }
            double[] arr$ = verticalAxisForGroup.getCoordValues();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Double vertCoord = arr$[i$];
                if (verticalAxisForGroup.getCoordValues().length == 1) {
                    vertCoord = NcssRequestUtils.getTargetLevelForVertCoord(verticalAxisForGroup, vertCoord);
                }
                allDone = allDone && this.write(varsGroup, gds, gap, point, vertCoord, verticalAxisForGroup.getUnitsString());
            }
        }
        return allDone;
    }

    private boolean write(List<String> vars, GridDataset gridDataset, GridAsPointDataset gap, CalendarDate date, LatLonPoint point, Double targetLevel, String zUnits) throws InvalidRangeException {
        Iterator<String> itVars = vars.iterator();
        boolean pointDone = false;
        try {
            this.xmlStreamWriter.writeStartElement("point");
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("name", "date");
            this.writeDataTag(this.xmlStreamWriter, attributes, date.toString());
            attributes.clear();
            int contVars = 0;
            while (itVars.hasNext()) {
                String varName = itVars.next();
                GridDatatype grid = gridDataset.findGridDatatype(varName);
                CoordinateAxis1D ensembleAxis = grid.getCoordinateSystem().getEnsembleAxis();
                boolean hasEnsembleDim = false;
                double[] ensCoords = new double[]{-1.0};
                if (ensembleAxis != null) {
                    ensCoords = ensembleAxis.getCoordValues();
                    hasEnsembleDim = true;
                }
                double actualLevel = NcssRequestUtils.getActualVertLevel(grid, date, point, targetLevel);
                for (double ensCoord : ensCoords) {
                    if (gap.hasTime(grid, date) && gap.hasVert(grid, targetLevel.doubleValue())) {
                        GridAsPointDataset.Point p = gap.readData(grid, date, ensCoord, targetLevel.doubleValue(), point.getLatitude(), point.getLongitude());
                        if (contVars == 0) {
                            this.writeCoordinates(this.xmlStreamWriter, point.getLatitude(), point.getLongitude());
                            attributes.put("name", "vertCoord");
                            attributes.put("units", zUnits);
                            this.writeDataTag(this.xmlStreamWriter, attributes, Double.valueOf(p.z).toString());
                            attributes.clear();
                            if (actualLevel != -9999.9) {
                                attributes.put("name", "vertCoord");
                                attributes.put("units", grid.getCoordinateSystem().getVerticalTransform().getUnitString());
                                this.writeDataTag(this.xmlStreamWriter, attributes, Double.valueOf(actualLevel).toString());
                                attributes.clear();
                            }
                        }
                        attributes.put("name", varName);
                        attributes.put("units", grid.getUnitsString());
                        if (hasEnsembleDim) {
                            attributes.put("ensMember", Double.valueOf(p.ens).toString());
                        }
                        this.writeDataTag(this.xmlStreamWriter, attributes, Double.valueOf(p.dataValue).toString());
                        attributes.clear();
                    } else {
                        if (contVars == 0) {
                            this.writeCoordinates(this.xmlStreamWriter, point.getLatitude(), point.getLongitude());
                        }
                        attributes.put("name", varName);
                        attributes.put("units", grid.getUnitsString());
                        this.writeDataTag(this.xmlStreamWriter, attributes, Double.valueOf(gap.getMissingValue(grid)).toString());
                        attributes.clear();
                    }
                    ++contVars;
                }
            }
            this.xmlStreamWriter.writeEndElement();
            pointDone = true;
        }
        catch (XMLStreamException xse) {
            log.error("Error writting tag point", (Throwable)xse);
        }
        catch (IOException ioe) {
            log.error("Error reading point data", (Throwable)ioe);
        }
        return pointDone;
    }

    private boolean write(List<String> vars, GridDataset gridDataset, GridAsPointDataset gap, LatLonPoint point, Double targetLevel, String zUnits) {
        Iterator<String> itVars = vars.iterator();
        boolean pointDone = false;
        try {
            this.xmlStreamWriter.writeStartElement("point");
            HashMap<String, String> attributes = new HashMap<String, String>();
            int contVars = 0;
            while (itVars.hasNext()) {
                String varName = itVars.next();
                GridDatatype grid = gridDataset.findGridDatatype(varName);
                if (gap.hasVert(grid, targetLevel.doubleValue())) {
                    GridAsPointDataset.Point p = gap.readData(grid, null, targetLevel.doubleValue(), point.getLatitude(), point.getLongitude());
                    if (contVars == 0) {
                        this.writeCoordinates(this.xmlStreamWriter, point.getLatitude(), point.getLongitude());
                        attributes.put("name", "vertCoord");
                        attributes.put("units", zUnits);
                        this.writeDataTag(this.xmlStreamWriter, attributes, Double.valueOf(p.z).toString());
                        attributes.clear();
                    }
                    attributes.put("name", varName);
                    attributes.put("units", grid.getUnitsString());
                    this.writeDataTag(this.xmlStreamWriter, attributes, Double.valueOf(p.dataValue).toString());
                    attributes.clear();
                } else {
                    if (contVars == 0) {
                        this.writeCoordinates(this.xmlStreamWriter, point.getLatitude(), point.getLongitude());
                    }
                    attributes.put("name", varName);
                    attributes.put("units", grid.getUnitsString());
                    this.writeDataTag(this.xmlStreamWriter, attributes, Double.valueOf(gap.getMissingValue(grid)).toString());
                    attributes.clear();
                }
                ++contVars;
            }
            this.xmlStreamWriter.writeEndElement();
            pointDone = true;
        }
        catch (XMLStreamException xse) {
            log.error("Error writting tag point", (Throwable)xse);
        }
        catch (IOException ioe) {
            log.error("Error reading point data", (Throwable)ioe);
        }
        return pointDone;
    }

    private boolean write(List<String> vars, GridDataset gridDataset, GridAsPointDataset gap, LatLonPoint point) {
        Iterator<String> itVars = vars.iterator();
        boolean pointDone = false;
        try {
            this.xmlStreamWriter.writeStartElement("point");
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.clear();
            int contVars = 0;
            while (itVars.hasNext()) {
                String varName = itVars.next();
                GridDatatype grid = gridDataset.findGridDatatype(varName);
                GridAsPointDataset.Point p = gap.readData(grid, null, point.getLatitude(), point.getLongitude());
                if (contVars == 0) {
                    this.writeCoordinates(this.xmlStreamWriter, point.getLatitude(), point.getLongitude());
                    attributes.clear();
                }
                attributes.put("name", varName);
                attributes.put("units", grid.getUnitsString());
                this.writeDataTag(this.xmlStreamWriter, attributes, Double.valueOf(p.dataValue).toString());
                attributes.clear();
                ++contVars;
            }
            this.xmlStreamWriter.writeEndElement();
            pointDone = true;
        }
        catch (XMLStreamException xse) {
            log.error("Error writting tag point", (Throwable)xse);
        }
        catch (IOException ioe) {
            log.error("Error reading point data", (Throwable)ioe);
        }
        return pointDone;
    }

    private boolean write(List<String> vars, GridDataset gridDataset, GridAsPointDataset gap, CalendarDate date, LatLonPoint point) {
        Iterator<String> itVars = vars.iterator();
        boolean pointDone = false;
        try {
            this.xmlStreamWriter.writeStartElement("point");
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("name", "date");
            this.writeDataTag(this.xmlStreamWriter, attributes, date.toString());
            attributes.clear();
            int contVars = 0;
            while (itVars.hasNext()) {
                String varName = itVars.next();
                GridDatatype grid = gridDataset.findGridDatatype(varName);
                CoordinateAxis1D ensembleAxis = grid.getCoordinateSystem().getEnsembleAxis();
                boolean hasEnsembleDim = false;
                double[] ensCoords = new double[]{-1.0};
                if (ensembleAxis != null) {
                    ensCoords = ensembleAxis.getCoordValues();
                    hasEnsembleDim = true;
                }
                for (double ensCoord : ensCoords) {
                    if (gap.hasTime(grid, date)) {
                        GridAsPointDataset.Point p = gap.readData(grid, date, ensCoord, -1.0, point.getLatitude(), point.getLongitude());
                        if (contVars == 0) {
                            this.writeCoordinates(this.xmlStreamWriter, point.getLatitude(), point.getLongitude());
                            attributes.clear();
                        }
                        attributes.put("name", varName);
                        attributes.put("units", grid.getUnitsString());
                        if (hasEnsembleDim) {
                            attributes.put("ensMember", Double.valueOf(p.ens).toString());
                        }
                        this.writeDataTag(this.xmlStreamWriter, attributes, Double.valueOf(p.dataValue).toString());
                        attributes.clear();
                    } else {
                        if (contVars == 0) {
                            this.writeCoordinates(this.xmlStreamWriter, point.getLatitude(), point.getLongitude());
                        }
                        attributes.put("name", varName);
                        attributes.put("units", grid.getUnitsString());
                        this.writeDataTag(this.xmlStreamWriter, attributes, Double.valueOf(gap.getMissingValue(grid)).toString());
                        attributes.clear();
                    }
                    ++contVars;
                }
            }
            this.xmlStreamWriter.writeEndElement();
            pointDone = true;
        }
        catch (XMLStreamException xse) {
            log.error("Error writting tag point", (Throwable)xse);
        }
        catch (IOException ioe) {
            log.error("Error reading point data", (Throwable)ioe);
        }
        return pointDone;
    }

    @Override
    public boolean trailer() {
        boolean endDocument = false;
        try {
            this.xmlStreamWriter.writeEndElement();
            this.xmlStreamWriter.writeEndDocument();
            endDocument = true;
        }
        catch (XMLStreamException xse) {
            log.error("Error writing end document", (Throwable)xse);
        }
        return endDocument;
    }

    @Override
    public HttpHeaders getResponseHeaders() {
        return this.httpHeaders;
    }

    private XMLStreamWriter createXMLStreamWriter(OutputStream os) {
        XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
        XMLStreamWriter writer = null;
        try {
            writer = outputFactory.createXMLStreamWriter(os, "UTF-8");
        }
        catch (XMLStreamException xse) {
            log.error(xse.getMessage());
        }
        return writer;
    }

    @Override
    public void setHTTPHeaders(GridDataset gds, String pathInfo, boolean isStream) {
        if (!isStream) {
            this.httpHeaders.set("Content-Location", pathInfo);
            String fileName = NcssRequestUtils.getFileNameForResponse(pathInfo, ".xml");
            this.httpHeaders.set("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        }
        this.httpHeaders.set("Content-Type", ContentType.xml.getContentHeader());
    }

    private void writeDataTag(XMLStreamWriter writer, Map<String, String> attributes, String content) throws XMLStreamException {
        writer.writeStartElement("data");
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            writer.writeAttribute(entry.getKey(), entry.getValue());
        }
        writer.writeCharacters(content);
        writer.writeEndElement();
    }

    private void writeCoordinates(XMLStreamWriter writer, Double lat, Double lon) throws XMLStreamException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("name", "lat");
        attributes.put("units", "degrees_north");
        this.writeDataTag(writer, attributes, lat.toString());
        attributes.clear();
        attributes.put("name", "lon");
        attributes.put("units", "degrees_east");
        this.writeDataTag(writer, attributes, lon.toString());
        attributes.clear();
    }
}

