/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.gridaspoint.netcdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.CF;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.writer.CFPointWriter;
import ucar.nc2.ft.point.writer.CFPointWriterUtils;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.geoloc.Station;

class WriterCFStationCollection
extends CFPointWriter {
    private static Logger log = LoggerFactory.getLogger(WriterCFStationCollection.class);
    private static final String stationDimName = "station";
    private static final String idName = "station_id";
    private static final String descName = "station_description";
    private static final String wmoName = "wmo_id";
    private static final String stationIndexName = "stationIndex";
    private static final boolean debug = false;
    private GridDataset gds = null;
    private int name_strlen = 1;
    private int desc_strlen = 1;
    private int wmo_strlen = 1;
    private Variable lat;
    private Variable lon;
    private Variable alt;
    private Variable time;
    private Variable id;
    private Variable wmoId;
    private Variable desc;
    private Variable stationIndex;
    private Variable ensVar;
    private double currentTimeCoordValue = -1.0;
    private List<Dimension> stationDims = new ArrayList<Dimension>(1);
    private boolean useAlt = false;
    private boolean useWmoId = false;
    private HashMap<String, Integer> stationMap;
    private int recno = -1;
    private ArrayDouble.D1 timeArray = new ArrayDouble.D1(1);
    private ArrayInt.D1 parentArray = new ArrayInt.D1(1);
    private int[] origin = new int[1];

    WriterCFStationCollection(NetcdfFileWriter.Version version, String fileOut, List<Attribute> atts) throws IOException {
        super(fileOut, atts, version);
        this.writer.addGroupAttribute(null, new Attribute("featureType", CF.FeatureType.timeSeries.name()));
    }

    protected void makeFeatureVariables(StructureData featureData, boolean isExtended) throws IOException {
    }

    void writeHeader(List<Station> stns, List<VariableSimpleIF> vars, GridDataset gds, List<Attribute> timeDimAtts, String altUnits) throws IOException {
        this.gds = gds;
        this.altUnits = altUnits;
        this.createStations(stns);
        this.createObsVariables(timeDimAtts);
        this.addDataVariablesClassic(vars);
        this.writer.create();
        this.writeStationData(stns);
    }

    private void createStations(List<Station> stnList) throws IOException {
        int nstns = stnList.size();
        for (Station stn : stnList) {
            if (!Double.isNaN(stn.getAltitude())) {
                this.useAlt = true;
            }
            if (stn.getWmoId() == null || stn.getWmoId().trim().length() <= 0) continue;
            this.useWmoId = true;
        }
        for (Station station : stnList) {
            this.name_strlen = Math.max(this.name_strlen, station.getName().length());
            this.desc_strlen = Math.max(this.desc_strlen, station.getDescription().length());
            if (!this.useWmoId) continue;
            this.wmo_strlen = Math.max(this.wmo_strlen, station.getWmoId().length());
        }
        this.llbb = CFPointWriterUtils.getBoundingBox(stnList);
        this.writer.addUnlimitedDimension("obs");
        Dimension stationDim = this.writer.addDimension(null, stationDimName, nstns);
        this.stationDims.add(stationDim);
        this.lat = this.writer.addVariable(null, "latitude", DataType.DOUBLE, stationDimName);
        this.writer.addVariableAttribute(this.lat, new Attribute("units", "degrees_north"));
        this.writer.addVariableAttribute(this.lat, new Attribute("long_name", "station latitude"));
        this.lon = this.writer.addVariable(null, "longitude", DataType.DOUBLE, stationDimName);
        this.writer.addVariableAttribute(this.lon, new Attribute("units", "degrees_east"));
        this.writer.addVariableAttribute(this.lon, new Attribute("long_name", "station longitude"));
        if (this.useAlt) {
            this.alt = this.writer.addVariable(null, "altitude", DataType.DOUBLE, stationDimName);
            this.writer.addVariableAttribute(this.alt, new Attribute("units", "meters"));
            this.writer.addVariableAttribute(this.alt, new Attribute("positive", "up"));
            this.writer.addVariableAttribute(this.alt, new Attribute("long_name", "station altitude"));
            this.writer.addVariableAttribute(this.alt, new Attribute("standard_name", "surface_altitude"));
        }
        this.id = this.writer.addStringVariable(null, idName, this.stationDims, this.name_strlen);
        this.writer.addVariableAttribute(this.id, new Attribute("long_name", "station identifier"));
        this.writer.addVariableAttribute(this.id, new Attribute("cf_role", "timeseries_id"));
        this.desc = this.writer.addStringVariable(null, descName, this.stationDims, this.desc_strlen);
        this.writer.addVariableAttribute(this.desc, new Attribute("long_name", "station description"));
        this.writer.addVariableAttribute(this.desc, new Attribute("standard_name", "platform_name"));
        if (this.useWmoId) {
            this.wmoId = this.writer.addStringVariable(null, wmoName, this.stationDims, this.wmo_strlen);
            this.writer.addVariableAttribute(this.wmoId, new Attribute("long_name", "station WMO id"));
            this.writer.addVariableAttribute(this.wmoId, new Attribute("standard_name", "platform_id"));
        }
    }

    private void createObsVariables(List<Attribute> timeDimAtts) throws IOException {
        this.time = this.writer.addVariable(null, "time", DataType.DOUBLE, "obs");
        for (Attribute att : timeDimAtts) {
            this.writer.addVariableAttribute(this.time, att);
        }
        this.stationIndex = this.writer.addVariable(null, stationIndexName, DataType.INT, "obs");
        this.writer.addVariableAttribute(this.stationIndex, new Attribute("long_name", "station index for this observation record"));
        this.writer.addVariableAttribute(this.stationIndex, new Attribute("instance_dimension", stationDimName));
    }

    protected void addDataVariablesClassic(List<? extends VariableSimpleIF> dataVars) throws IOException {
        HashSet<Dimension> dimSet = new HashSet<Dimension>(20);
        String coordNames = "latitude longitude altitude time";
        if (!this.useAlt) {
            coordNames = "latitude longitude time";
        }
        for (VariableSimpleIF variableSimpleIF : dataVars) {
            List dims = variableSimpleIF.getDimensions();
            dimSet.addAll(dims);
        }
        for (Dimension dimension : dimSet) {
            if (dimension.isUnlimited()) continue;
            this.writer.addDimension(null, dimension.getShortName(), dimension.getLength(), dimension.isShared(), false, dimension.isVariableLength());
        }
        CoordinateAxis1D ensAxis = this.gds.findGridDatatype(dataVars.get(0).getShortName()).getCoordinateSystem().getEnsembleAxis();
        Object var5_8 = null;
        if (ensAxis != null) {
            Dimension dimension = this.writer.addDimension(null, ensAxis.getShortName(), ensAxis.getCoordValues().length);
            dimSet.add(dimension);
            ArrayList<Dimension> ensDim = new ArrayList<Dimension>();
            ensDim.add(dimension);
            this.ensVar = this.writer.addVariable(null, ensAxis.getShortName(), DataType.DOUBLE, ensDim);
        }
        ArrayList<VariableSimpleIF> useDataVars = new ArrayList<VariableSimpleIF>(dataVars.size());
        for (VariableSimpleIF variableSimpleIF : dataVars) {
            if (this.writer.findVariable(variableSimpleIF.getShortName()) != null) continue;
            useDataVars.add(variableSimpleIF);
        }
        for (VariableSimpleIF variableSimpleIF : useDataVars) {
            StringBuilder dimNames = new StringBuilder("obs");
            for (Dimension d : dimSet) {
                if (d.isUnlimited()) continue;
                dimNames.append(" ").append(d.getShortName());
            }
            Variable newVar = this.writer.addVariable(null, variableSimpleIF.getShortName(), variableSimpleIF.getDataType(), dimNames.toString());
            List atts = variableSimpleIF.getAttributes();
            for (Attribute att : atts) {
                newVar.addAttribute(att);
            }
            newVar.addAttribute(new Attribute("coordinates", coordNames));
        }
    }

    private void writeStationData(List<Station> stnList) throws IOException {
        int nstns = stnList.size();
        this.stationMap = new HashMap(2 * nstns);
        ArrayDouble.D1 latArray = new ArrayDouble.D1(nstns);
        ArrayDouble.D1 lonArray = new ArrayDouble.D1(nstns);
        ArrayDouble.D1 altArray = new ArrayDouble.D1(nstns);
        ArrayObject.D1 idArray = new ArrayObject.D1(String.class, nstns);
        ArrayObject.D1 descArray = new ArrayObject.D1(String.class, nstns);
        ArrayObject.D1 wmoArray = new ArrayObject.D1(String.class, nstns);
        for (int i = 0; i < stnList.size(); ++i) {
            Station stn = stnList.get(i);
            this.stationMap.put(stn.getName(), i);
            latArray.set(i, stn.getLatitude());
            lonArray.set(i, stn.getLongitude());
            if (this.useAlt) {
                altArray.set(i, stn.getAltitude());
            }
            idArray.set(i, (Object)stn.getName());
            descArray.set(i, (Object)stn.getDescription());
            if (!this.useWmoId) continue;
            wmoArray.set(i, (Object)stn.getWmoId());
        }
        try {
            this.writer.write(this.lat, (Array)latArray);
            this.writer.write(this.lon, (Array)lonArray);
            if (this.useAlt) {
                this.writer.write(this.alt, (Array)altArray);
            }
            this.writer.writeStringData(this.id, (Array)idArray);
            this.writer.writeStringData(this.desc, (Array)descArray);
            if (this.useWmoId) {
                this.writer.writeStringData(this.wmoId, (Array)wmoArray);
            }
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    void writeRecord(Station s, PointFeature sobs, StructureData sdata) throws IOException {
        this.writeRecord(s.getName(), sobs.getObservationTime(), sobs.getObservationTimeAsCalendarDate(), sdata);
    }

    void writeRecord(String stnName, double timeCoordValue, CalendarDate obsDate, StructureData sdata) throws IOException {
        Integer parentIndex;
        this.trackBB(null, obsDate);
        if (this.recno < 0) {
            this.recno = 0;
        }
        if ((parentIndex = this.stationMap.get(stnName)) == null) {
            throw new RuntimeException("Cant find station " + stnName);
        }
        ArrayStructureW sArray = new ArrayStructureW(sdata.getStructureMembers(), new int[]{1});
        sArray.setStructureData(sdata, 0);
        this.timeArray.set(0, timeCoordValue);
        this.parentArray.set(0, parentIndex.intValue());
        this.origin[0] = this.recno;
        try {
            this.writer.write(this.time, this.origin, (Array)this.timeArray);
            this.writer.write(this.stationIndex, this.origin, (Array)this.parentArray);
            StructureMembers sm = sdata.getStructureMembers();
            for (StructureMembers.Member m : sm.getMembers()) {
                Variable v = this.writer.findVariable(m.getName());
                if (v == null || v.getShortName().equals("longitude") || v.getShortName().equals("latitude") || v.getShortName().equals("time")) continue;
                Array arr = CFPointWriterUtils.getArrayFromMember((Variable)v, (StructureMembers.Member)m);
                this.writer.write(v, this.origin, arr);
            }
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        ++this.recno;
    }

    void writeRecord(String stnName, double timeCoordValue, CalendarDate obsDate, double ensCoord, StructureData sdata) throws IOException {
        Integer parentIndex;
        this.trackBB(null, obsDate);
        if (this.currentTimeCoordValue != timeCoordValue) {
            ++this.recno;
            this.currentTimeCoordValue = timeCoordValue;
        }
        if ((parentIndex = this.stationMap.get(stnName)) == null) {
            throw new RuntimeException("Cant find station " + stnName);
        }
        ArrayStructureW sArray = new ArrayStructureW(sdata.getStructureMembers(), new int[]{1});
        sArray.setStructureData(sdata, 0);
        this.timeArray.set(0, timeCoordValue);
        this.parentArray.set(0, parentIndex.intValue());
        this.origin[0] = this.recno;
        int[] twoDIdx = new int[]{this.recno, (int)ensCoord};
        try {
            this.writer.write(this.time, this.origin, (Array)this.timeArray);
            this.writer.write(this.stationIndex, this.origin, (Array)this.parentArray);
            StructureMembers sm = sdata.getStructureMembers();
            for (StructureMembers.Member m : sm.getMembers()) {
                Variable v = this.writer.findVariable(m.getName());
                if (v == null || v.getShortName().equals("longitude") || v.getShortName().equals("latitude") || v.getShortName().equals("time")) continue;
                Array arr = CFPointWriterUtils.getArrayFromMember((Variable)v, (StructureMembers.Member)m);
                this.writer.write(v, twoDIdx, arr);
            }
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    void writeEnsCoord(int ensIdx, double ensCoord) throws IOException {
        ArrayDouble.D1 tmpArray = new ArrayDouble.D1(1);
        tmpArray.setDouble(0, ensCoord);
        int[] idx = new int[]{ensIdx};
        try {
            this.writer.write(this.ensVar, idx, (Array)tmpArray);
        }
        catch (InvalidRangeException ire) {
            log.error("Error writing data: " + (Object)((Object)ire));
        }
    }
}

