/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.views;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.view.AbstractView;
import thredds.servlet.Debug;
import thredds.servlet.ServletUtil;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.IO;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.nc2.util.cache.FileCacheable;
import ucar.nc2.util.cache.FileFactory;
import ucar.unidata.io.RandomAccessFile;

public class FileView
extends AbstractView {
    private static Logger log = LoggerFactory.getLogger(FileView.class);
    private static final FileFactory fileFactory = new FileFactory(){

        public FileCacheable open(String location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
            return new RandomAccessFile(location, "r");
        }
    };
    private FileCacheIF fileCacheRaf;

    public void setFileCacheRaf(FileCacheIF fileCacheRaf) {
        this.fileCacheRaf = fileCacheRaf;
    }

    public void init() {
        if (this.fileCacheRaf == null) {
            this.fileCacheRaf = ServletUtil.getFileCache();
        }
        if (this.fileCacheRaf == null) {
            throw new IllegalStateException("FileCacheRaf not configured.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderMergedOutputModel(Map model, HttpServletRequest req, HttpServletResponse res) throws Exception {
        long fileSize;
        int pos2;
        int pos;
        if (model == null || model.isEmpty()) {
            throw new IllegalArgumentException("Model must not be null or empty.");
        }
        if (!model.containsKey("file")) {
            throw new IllegalArgumentException("Model must contain \"file\" key.");
        }
        Object o = model.get("file");
        if (!(o instanceof File)) {
            throw new IllegalArgumentException("Object mapped by \"file\" key  must be a File.");
        }
        File file = (File)o;
        if (!file.isFile()) {
            res.sendError(400);
            return;
        }
        String contentType = null;
        if (model.containsKey("contentType") && (o = model.get("contentType")) instanceof String) {
            contentType = (String)o;
        }
        String characterEncoding = null;
        if (model.containsKey("characterEncoding") && (o = model.get("characterEncoding")) instanceof String) {
            characterEncoding = (String)o;
        }
        String filename = file.getPath();
        if (null == contentType && (contentType = filename.endsWith(".html") ? "text/html; charset=utf-8" : (filename.endsWith(".xml") ? "application/xml; charset=utf-8" : (filename.endsWith(".txt") || filename.endsWith(".log") || filename.endsWith(".out") ? "text/plain; charset=utf-8" : (filename.indexOf(".log.") > 0 ? "text/plain; charset=utf-8" : (filename.endsWith(".nc") ? "application/x-netcdf" : this.getServletContext().getMimeType(filename)))))) == null) {
            contentType = "application/octet-stream";
        }
        if (characterEncoding == null && !contentType.contains("charset=") && (contentType.startsWith("text/") || contentType.startsWith("application/xml"))) {
            characterEncoding = "utf-8";
        }
        res.setContentType(contentType);
        if (characterEncoding != null) {
            res.setCharacterEncoding(characterEncoding);
        }
        boolean isRangeRequest = false;
        long startPos = 0L;
        long endPos = Long.MAX_VALUE;
        String rangeRequest = req.getHeader("Range");
        if (rangeRequest != null && (pos = rangeRequest.indexOf("=")) > 0 && (pos2 = rangeRequest.indexOf("-")) > 0) {
            String startString = rangeRequest.substring(pos + 1, pos2);
            String endString = rangeRequest.substring(pos2 + 1);
            startPos = Long.parseLong(startString);
            if (endString.length() > 0) {
                endPos = Long.parseLong(endString) + 1L;
            }
            isRangeRequest = true;
        }
        long contentLength = fileSize = file.length();
        if (isRangeRequest) {
            endPos = Math.min(endPos, fileSize);
            contentLength = endPos - startPos;
        }
        res.setContentLength((int)contentLength);
        boolean debugRequest = Debug.isSet("returnFile");
        if (debugRequest) {
            log.debug("renderMergedOutputModel(): filename = " + filename + " contentType = " + contentType + " contentLength = " + contentLength);
        }
        if (!isRangeRequest) {
            res.addHeader("Accept-Ranges", "bytes");
        }
        if (req.getMethod().equals("HEAD")) {
            return;
        }
        try {
            if (isRangeRequest) {
                res.addHeader("Content-Range", "bytes " + startPos + "-" + (endPos - 1L) + "/" + fileSize);
                res.setStatus(206);
                RandomAccessFile craf = null;
                try {
                    craf = (RandomAccessFile)this.fileCacheRaf.acquire(fileFactory, filename);
                    IO.copyRafB((RandomAccessFile)craf, (long)startPos, (long)contentLength, (OutputStream)res.getOutputStream(), (byte[])new byte[60000]);
                    return;
                }
                finally {
                    if (craf != null) {
                        this.fileCacheRaf.release((FileCacheable)craf);
                    }
                }
            }
            ServletOutputStream out = res.getOutputStream();
            IO.copyFileB((File)file, (OutputStream)out, (int)60000);
            res.flushBuffer();
            out.close();
            if (debugRequest) {
                log.debug("renderMergedOutputModel(): file response ok = " + filename);
            }
        }
        catch (FileNotFoundException e) {
            log.error("returnFile(): FileNotFoundException= " + filename);
            if (!res.isCommitted()) {
                res.sendError(404);
            }
        }
        catch (SocketException e) {
            log.info("returnFile(): SocketException sending file: " + filename + " " + e.getMessage());
        }
        catch (IOException e) {
            String eName = e.getClass().getName();
            if (eName.equals("org.apache.catalina.connector.ClientAbortException")) {
                log.info("returnFile(): ClientAbortException while sending file: " + filename + " " + e.getMessage());
                return;
            }
            log.error("returnFile(): IOException (" + e.getClass().getName() + ") sending file ", (Throwable)e);
            res.sendError(500, "Problem sending file");
        }
    }
}

