/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.dap4;

import dap4.servlet.DSPFactory;
import dap4.servlet.DapCache;
import dap4.servlet.DapRequest;
import dap4.servlet.DapServlet;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import thredds.server.dap4.ThreddsDSP;
import thredds.servlet.DatasetHandler;
import thredds.servlet.ThreddsConfig;
import ucar.nc2.constants.CDM;

public class Dap4Servlet
extends DapServlet {
    static final boolean DEBUG = false;
    static final boolean PARSEDEBUG = false;

    protected void doFavicon(DapRequest drq) throws IOException {
        throw new UnsupportedOperationException("Favicon");
    }

    protected void doCapabilities(DapRequest drq) throws IOException {
        this.addCommonHeaders(drq);
        OutputStream out = drq.getOutputStream();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(out, CDM.utf8Charset));
        pw.println("Capabilities page not yet supported");
        pw.flush();
    }

    protected String getResourcePath(DapRequest drq) throws IOException {
        String datasetpath = drq.getDataset();
        if (datasetpath.startsWith("/")) {
            datasetpath = datasetpath.substring(1);
        }
        datasetpath = DatasetHandler.getNetcdfFilePath(drq.getRequest(), datasetpath);
        return datasetpath;
    }

    protected long getBinaryWriteLimit() {
        int mblimit = ThreddsConfig.getInt("Dap4.binaryLimit", 100);
        return mblimit * 1000000;
    }

    static {
        DapCache.setFactory((DSPFactory)new Dap4Factory());
    }

    static class Dap4Factory
    extends DSPFactory {
        public Dap4Factory() {
            this.registerDSP(ThreddsDSP.class, true);
        }
    }
}

