/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.controller;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import thredds.server.ncss.exception.NcssException;

public class AbstractNcssController {
    protected static final String servletPath = "/ncss/";
    protected static final String servletCachePath = "/cache/ncss";
    private static final Logger logger = LoggerFactory.getLogger(AbstractNcssController.class);
    private static final String[] endings = new String[]{"/dataset.xml", "/dataset.html", "/pointDataset.html", "/pointDataset.xml", "/datasetBoundaries.xml", "/station.xml"};

    protected void handleValidationErrorsResponse(HttpServletResponse response, int status, BindingResult validationResult) {
        List errors = validationResult.getAllErrors();
        response.setStatus(status);
        StringBuilder responseStr = new StringBuilder();
        responseStr.append("Validation errors: ");
        for (ObjectError err : errors) {
            responseStr.append(err.getDefaultMessage());
            responseStr.append("  -- ");
        }
        try {
            PrintWriter pw = response.getWriter();
            pw.write(responseStr.toString());
            pw.flush();
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage());
        }
    }

    protected void handleValidationErrorMessage(HttpServletResponse response, int status, String errorMessage) {
        response.setStatus(status);
        try {
            PrintWriter pw = response.getWriter();
            pw.write(errorMessage);
            pw.flush();
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage());
        }
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={NcssException.class})
    public void handle(NcssException e) {
        logger.debug("NcssException", (Throwable)e);
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="Unknown Dataset")
    @ExceptionHandler(value={FileNotFoundException.class})
    public void handle(FileNotFoundException e) {
        logger.debug("Not Found", (Throwable)e);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={UnsupportedOperationException.class})
    public void handle(UnsupportedOperationException e) {
        logger.debug("UnsupportedOperationException", (Throwable)e);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Throwable.class})
    public void handle(Throwable t) {
        logger.error("Uncaught exception", t);
    }

    public static String getNCSSServletPath() {
        return servletPath;
    }

    public static String getServletCachePath() {
        return servletCachePath;
    }

    public static String getDatasetPath(HttpServletRequest req) {
        return AbstractNcssController.getDatasetPath(req.getServletPath());
    }

    public static String getDatasetPath(String path) {
        if (path.startsWith(servletPath)) {
            path = path.substring(servletPath.length());
        }
        for (String ending : endings) {
            if (!path.endsWith(ending)) continue;
            int len = path.length() - ending.length();
            path = path.substring(0, len);
            break;
        }
        return path;
    }
}

