/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg.station;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import thredds.server.ncss.exception.FeaturesNotFoundException;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.params.NcssParamsBean;
import thredds.server.ncss.view.dsg.AbstractDsgSubsetWriter;
import thredds.server.ncss.view.dsg.FilteredPointFeatureIterator;
import ucar.ma2.StructureData;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft.point.StationTimeSeriesFeatureImpl;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateType;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public abstract class AbstractStationSubsetWriter
extends AbstractDsgSubsetWriter {
    protected final StationTimeSeriesFeatureCollection stationFeatureCollection;
    protected final List<StationFeature> wantedStations;
    protected boolean headerDone = false;

    public AbstractStationSubsetWriter(FeatureDatasetPoint fdPoint, NcssParamsBean ncssParams) throws NcssException, IOException {
        super(fdPoint, ncssParams);
        List featColList = fdPoint.getPointFeatureCollectionList();
        assert (featColList.size() == 1) : "Is there ever a case when this is NOT 1?";
        assert (featColList.get(0) instanceof StationTimeSeriesFeatureCollection) : "This class only deals with StationTimeSeriesFeatureCollections.";
        this.stationFeatureCollection = (StationTimeSeriesFeatureCollection)featColList.get(0);
        this.wantedStations = AbstractStationSubsetWriter.getStationsInSubset(this.stationFeatureCollection, ncssParams);
        if (this.wantedStations.isEmpty()) {
            throw new FeaturesNotFoundException("No stations found in subset.");
        }
    }

    protected abstract void writeHeader(StationPointFeature var1) throws Exception;

    protected abstract void writeStationPointFeature(StationPointFeature var1) throws Exception;

    protected abstract void writeFooter() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write() throws Exception {
        StationTimeSeriesFeatureCollection subsettedStationFeatCol = this.stationFeatureCollection.subsetFeatures(this.wantedStations);
        subsettedStationFeatCol.resetIteration();
        try {
            while (subsettedStationFeatCol.hasNext()) {
                StationTimeSeriesFeature stationFeat = subsettedStationFeatCol.next();
                Object subsettedStationFeat = stationFeat.subset(this.wantedRange);
                if (this.ncssParams.getTime() != null) {
                    DateType wantedDateType = new DateType(this.ncssParams.getTime(), null, null);
                    CalendarDate wantedTime = wantedDateType.getCalendarDate();
                    subsettedStationFeat = new ClosestTimeStationFeatureSubset((StationTimeSeriesFeatureImpl)subsettedStationFeat, wantedTime);
                }
                this.writeStationTimeSeriesFeature((StationTimeSeriesFeature)subsettedStationFeat);
            }
        }
        finally {
            subsettedStationFeatCol.finish();
        }
        this.writeFooter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeStationTimeSeriesFeature(StationTimeSeriesFeature stationFeat) throws Exception {
        stationFeat.resetIteration();
        try {
            while (stationFeat.hasNext()) {
                PointFeature pointFeat = stationFeat.next();
                assert (pointFeat instanceof StationPointFeature) : "Expected pointFeat to be a StationPointFeature, not a " + pointFeat.getClass().getSimpleName();
                if (!this.headerDone) {
                    this.writeHeader((StationPointFeature)pointFeat);
                    this.headerDone = true;
                }
                this.writeStationPointFeature((StationPointFeature)pointFeat);
            }
        }
        finally {
            stationFeat.finish();
        }
    }

    public static List<StationFeature> getStationsInSubset(StationTimeSeriesFeatureCollection stationFeatCol, NcssParamsBean ncssParams) throws IOException {
        List wantedStations;
        if (ncssParams.hasStations()) {
            List<String> stnNames = ncssParams.getStns();
            wantedStations = stnNames.get(0).equals("all") ? stationFeatCol.getStationFeatures() : stationFeatCol.getStationFeatures(stnNames);
        } else if (ncssParams.hasLatLonBB()) {
            LatLonRect llrect = ncssParams.getBoundingBox();
            wantedStations = stationFeatCol.getStationFeatures(llrect);
        } else if (ncssParams.hasLatLonPoint()) {
            Station closestStation = AbstractStationSubsetWriter.findClosestStation(stationFeatCol, (LatLonPoint)new LatLonPointImpl(ncssParams.getLatitude().doubleValue(), ncssParams.getLongitude().doubleValue()));
            ArrayList<String> stnList = new ArrayList<String>();
            stnList.add(closestStation.getName());
            wantedStations = stationFeatCol.getStationFeatures(stnList);
        } else {
            wantedStations = stationFeatCol.getStationFeatures();
        }
        return wantedStations;
    }

    public static Station findClosestStation(StationTimeSeriesFeatureCollection stationFeatCol, LatLonPoint pt) throws IOException {
        double lat = pt.getLatitude();
        double lon = pt.getLongitude();
        double cos = Math.cos(Math.toRadians(lat));
        List stations = stationFeatCol.getStations();
        Station min_station = (Station)stations.get(0);
        double min_dist = Double.MAX_VALUE;
        for (Station s : stations) {
            double dx;
            double lat1 = s.getLatitude();
            double lon1 = LatLonPointImpl.lonNormal((double)s.getLongitude(), (double)lon);
            double dy = Math.toRadians(lat - lat1);
            double dist = dy * dy + (dx = cos * Math.toRadians(lon - lon1)) * dx;
            if (!(dist < min_dist)) continue;
            min_dist = dist;
            min_station = s;
        }
        return min_station;
    }

    protected static class ClosestTimeStationFeatureSubset
    extends StationTimeSeriesFeatureImpl {
        private final StationTimeSeriesFeature stationFeat;
        private CalendarDate closestTime;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ClosestTimeStationFeatureSubset(StationTimeSeriesFeatureImpl stationFeat, CalendarDate wantedTime) throws IOException {
            super((Station)stationFeat, stationFeat.getTimeUnit(), stationFeat.getAltUnits(), -1);
            this.stationFeat = stationFeat;
            this.dateRange = stationFeat.getCalendarDateRange();
            long smallestDiff = Long.MAX_VALUE;
            stationFeat.resetIteration();
            try {
                while (stationFeat.hasNext()) {
                    PointFeature pointFeat = stationFeat.next();
                    CalendarDate obsTime = pointFeat.getObservationTimeAsCalendarDate();
                    long diff = Math.abs(obsTime.getMillis() - wantedTime.getMillis());
                    if (diff >= smallestDiff) continue;
                    this.closestTime = obsTime;
                }
            }
            finally {
                stationFeat.finish();
            }
        }

        public StructureData getFeatureData() throws IOException {
            return this.stationFeat.getFeatureData();
        }

        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            if (this.closestTime == null) {
                return this.stationFeat.getPointFeatureIterator(bufferSize);
            }
            return new FilteredPointFeatureIterator(this.stationFeat.getPointFeatureIterator(bufferSize), new TimeFilter(this.closestTime));
        }

        protected static class TimeFilter
        implements PointFeatureIterator.Filter {
            private final CalendarDate wantedTime;

            protected TimeFilter(CalendarDate wantedTime) {
                this.wantedTime = wantedTime;
            }

            public boolean filter(PointFeature pointFeature) {
                return pointFeature.getObservationTimeAsCalendarDate().equals((Object)this.wantedTime);
            }
        }
    }
}

