/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.gridaspoint;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import thredds.server.ncss.util.NcssRequestUtils;
import thredds.server.ncss.view.gridaspoint.PointDataWriter;
import thredds.util.ContentType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridAsPointDataset;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.vertical.VerticalTransform;

class CSVPointDataWriter
implements PointDataWriter {
    private static Logger log = LoggerFactory.getLogger(CSVPointDataWriter.class);
    private PrintStream printWriter;
    private Map<String, List<String>> allVars;
    private Map<String, GridAsPointDataset> gridAsPointDatasets = new HashMap<String, GridAsPointDataset>();
    private boolean headersSet = false;
    private HttpHeaders httpHeaders;

    public static CSVPointDataWriter factory(OutputStream os) {
        return new CSVPointDataWriter(os);
    }

    private CSVPointDataWriter(OutputStream os) {
        try {
            this.printWriter = new PrintStream(os, false, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("CSVPointDataWriter", (Throwable)e);
        }
    }

    @Override
    public boolean header(Map<String, List<String>> groupedVars, GridDataset gridDataset, List<CalendarDate> wDates, List<Attribute> timeDimAtts, LatLonPoint point, Double vertCoord) {
        this.allVars = groupedVars;
        for (Map.Entry<String, List<String>> entry : groupedVars.entrySet()) {
            this.gridAsPointDatasets.put(entry.getKey(), NcssRequestUtils.buildGridAsPointDataset(gridDataset, entry.getValue()));
        }
        return true;
    }

    @Override
    public boolean write(Map<String, List<String>> groupedVars, GridDataset gds, List<CalendarDate> wDates, LatLonPoint point, Double vertCoord) throws InvalidRangeException {
        boolean allDone = true;
        ArrayList<String> keys = new ArrayList<String>(groupedVars.keySet());
        int contKeys = 1;
        for (String key : keys) {
            List<String> varsGroup = groupedVars.get(key);
            boolean hasEnsembleDim = gds.findGridByShortName(varsGroup.get(0)).getEnsembleDimension() != null;
            this.writeGroupHeader(varsGroup, gds, hasEnsembleDim, !wDates.isEmpty());
            boolean pointRead = true;
            if (wDates.isEmpty()) {
                pointRead = this.write(key, gds, point, vertCoord);
            } else {
                Iterator<CalendarDate> it = wDates.iterator();
                while (pointRead && it.hasNext()) {
                    CalendarDate date = it.next();
                    pointRead = this.write(key, gds, date, point, vertCoord);
                }
            }
            if (contKeys != keys.size()) {
                this.printWriter.println();
            }
            ++contKeys;
        }
        return allDone;
    }

    private boolean write(String keyVarsGroup, GridDataset gridDataset, LatLonPoint point, Double targetLevel) {
        boolean allDone = true;
        List<String> varsGroup = this.allVars.get(keyVarsGroup);
        GridAsPointDataset gap = this.gridAsPointDatasets.get(keyVarsGroup);
        CoordinateAxis1D verticalAxisForGroup = gridDataset.findGridDatatype(varsGroup.get(0)).getCoordinateSystem().getVerticalAxis();
        if (verticalAxisForGroup == null) {
            allDone = allDone && this.write(varsGroup, gridDataset, gap, point);
        } else if (targetLevel != null) {
            Double vertCoord = NcssRequestUtils.getTargetLevelForVertCoord(verticalAxisForGroup, targetLevel);
            allDone = this.write(varsGroup, gridDataset, gap, point, vertCoord, verticalAxisForGroup.getUnitsString());
        } else {
            double[] arr$ = verticalAxisForGroup.getCoordValues();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Double vertCoord = arr$[i$];
                if (verticalAxisForGroup.getCoordValues().length == 1) {
                    vertCoord = NcssRequestUtils.getTargetLevelForVertCoord(verticalAxisForGroup, vertCoord);
                }
                allDone = allDone && this.write(varsGroup, gridDataset, gap, point, vertCoord, verticalAxisForGroup.getUnitsString());
            }
        }
        return allDone;
    }

    private boolean write(String keyVarsGroup, GridDataset gridDataset, CalendarDate date, LatLonPoint point, Double targetLevel) throws InvalidRangeException {
        boolean allDone = true;
        List<String> varsGroup = this.allVars.get(keyVarsGroup);
        GridAsPointDataset gap = this.gridAsPointDatasets.get(keyVarsGroup);
        CoordinateAxis1D verticalAxisForGroup = gridDataset.findGridDatatype(varsGroup.get(0)).getCoordinateSystem().getVerticalAxis();
        GridDatatype refGrid = gridDataset.findGridDatatype(varsGroup.get(0));
        CoordinateAxis1D ensembleAxisForGroup = refGrid.getCoordinateSystem().getEnsembleAxis();
        double[] ensCoords = new double[]{-1.0};
        if (ensembleAxisForGroup != null) {
            ensCoords = ensembleAxisForGroup.getCoordValues();
        }
        for (double ensCoord : ensCoords) {
            if (verticalAxisForGroup == null) {
                allDone = allDone && this.write(varsGroup, gridDataset, gap, date, point, ensCoord);
                continue;
            }
            if (targetLevel != null) {
                Double vertCoord = NcssRequestUtils.getTargetLevelForVertCoord(verticalAxisForGroup, targetLevel);
                allDone = this.write(varsGroup, gridDataset, gap, date, point, ensCoord, vertCoord, verticalAxisForGroup.getUnitsString());
                continue;
            }
            double[] arr$ = verticalAxisForGroup.getCoordValues();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Double vertCoord = arr$[i$];
                if (verticalAxisForGroup.getCoordValues().length == 1) {
                    vertCoord = NcssRequestUtils.getTargetLevelForVertCoord(verticalAxisForGroup, vertCoord);
                }
                allDone = allDone && this.write(varsGroup, gridDataset, gap, date, point, ensCoord, vertCoord, verticalAxisForGroup.getUnitsString());
            }
        }
        return allDone;
    }

    private void writeGroupHeader(List<String> varGroup, GridDataset gridDataset, boolean hasEnsAxis, boolean hasTimeAxis) {
        VerticalTransform vt;
        GridCoordSystem coordSystem;
        CoordinateAxis1D zAxis;
        StringBuilder sb = new StringBuilder();
        if (hasTimeAxis) {
            sb.append("date,");
        }
        sb.append("lat[unit=\"degrees_north\"],");
        sb.append("lon[unit=\"degrees_east\"],");
        if (hasEnsAxis) {
            sb.append("ensMember,");
        }
        if ((zAxis = (coordSystem = gridDataset.findGridDatatype(varGroup.get(0)).getCoordinateSystem()).getVerticalAxis()) != null) {
            sb.append("vertCoord[unit=\"").append(zAxis.getUnitsString()).append("\"],");
        }
        if ((vt = coordSystem.getVerticalTransform()) != null) {
            sb.append("vertCoord[unit=\"").append(vt.getUnitString()).append("\"],");
        }
        Iterator<String> it = varGroup.iterator();
        while (it.hasNext()) {
            GridDatatype grid = gridDataset.findGridDatatype(it.next());
            sb.append(grid.getName());
            if (grid.getUnitsString() != null) {
                sb.append("[unit=\"").append(grid.getUnitsString()).append("\"]");
            }
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        this.printWriter.print(sb.toString());
        this.printWriter.println();
    }

    private boolean write(List<String> vars, GridDataset gridDataset, GridAsPointDataset gap, LatLonPoint point, Double targetLevel, String zUnits) {
        boolean allDone = false;
        int contVars = 0;
        Iterator<String> itVars = vars.iterator();
        try {
            while (itVars.hasNext()) {
                GridDatatype grid = gridDataset.findGridDatatype(itVars.next());
                if (gap.hasVert(grid, targetLevel.doubleValue())) {
                    GridAsPointDataset.Point p = gap.readData(grid, null, targetLevel.doubleValue(), point.getLatitude(), point.getLongitude());
                    if (contVars == 0) {
                        this.printWriter.print(point.getLatitude());
                        this.printWriter.print(",");
                        this.printWriter.print(point.getLongitude());
                        this.printWriter.print(",");
                        this.printWriter.print(p.z);
                        this.printWriter.print(",");
                    }
                    this.printWriter.print(p.dataValue);
                    if (itVars.hasNext()) {
                        this.printWriter.print(",");
                    }
                } else {
                    if (contVars == 0) {
                        this.printWriter.print(point.getLatitude());
                        this.printWriter.print(",");
                        this.printWriter.print(point.getLongitude());
                        this.printWriter.print(",");
                        this.printWriter.print(targetLevel);
                        this.printWriter.print(",");
                    }
                    this.printWriter.print(gap.getMissingValue(grid));
                    if (itVars.hasNext()) {
                        this.printWriter.print(",");
                    }
                }
                ++contVars;
            }
            allDone = true;
        }
        catch (IOException ioe) {
            log.error("Error reading data", (Throwable)ioe);
        }
        this.printWriter.println();
        return allDone;
    }

    private boolean write(List<String> vars, GridDataset gridDataset, GridAsPointDataset gap, CalendarDate date, LatLonPoint point, Double ensCoord, Double targetLevel, String zUnits) throws InvalidRangeException {
        boolean allDone = false;
        this.printWriter.print(date.toString());
        this.printWriter.print(",");
        int contVars = 0;
        Iterator<String> itVars = vars.iterator();
        try {
            while (itVars.hasNext()) {
                GridDatatype grid = gridDataset.findGridDatatype(itVars.next());
                double actualLevel = NcssRequestUtils.getActualVertLevel(grid, date, point, targetLevel);
                if (gap.hasTime(grid, date) && gap.hasVert(grid, targetLevel.doubleValue())) {
                    GridAsPointDataset.Point p = gap.readData(grid, date, ensCoord.doubleValue(), targetLevel.doubleValue(), point.getLatitude(), point.getLongitude());
                    if (contVars == 0) {
                        this.printWriter.print(point.getLatitude());
                        this.printWriter.print(",");
                        this.printWriter.print(point.getLongitude());
                        this.printWriter.print(",");
                        if (ensCoord >= 0.0) {
                            this.printWriter.print(p.ens);
                            this.printWriter.print(",");
                        }
                        this.printWriter.print(p.z);
                        this.printWriter.print(",");
                        if (Double.compare(actualLevel, -9999.9) != 0) {
                            this.printWriter.print(actualLevel);
                            this.printWriter.print(",");
                        }
                    }
                    this.printWriter.print(p.dataValue);
                    if (itVars.hasNext()) {
                        this.printWriter.print(",");
                    }
                } else {
                    if (contVars == 0) {
                        this.printWriter.print(point.getLatitude());
                        this.printWriter.print(",");
                        this.printWriter.print(point.getLongitude());
                        this.printWriter.print(",");
                        this.printWriter.print(targetLevel);
                    }
                    this.printWriter.print(gap.getMissingValue(grid));
                    if (itVars.hasNext()) {
                        this.printWriter.print(",");
                    }
                }
                ++contVars;
            }
            allDone = true;
        }
        catch (IOException ioe) {
            log.error("Error reading data", (Throwable)ioe);
        }
        this.printWriter.println();
        return allDone;
    }

    private boolean write(List<String> vars, GridDataset gridDataset, GridAsPointDataset gap, LatLonPoint point) {
        boolean allDone = false;
        int contVars = 0;
        Iterator<String> itVars = vars.iterator();
        try {
            while (itVars.hasNext()) {
                GridDatatype grid = gridDataset.findGridDatatype(itVars.next());
                GridAsPointDataset.Point p = gap.readData(grid, null, point.getLatitude(), point.getLongitude());
                if (contVars == 0) {
                    this.printWriter.print(point.getLatitude());
                    this.printWriter.print(",");
                    this.printWriter.print(point.getLongitude());
                    this.printWriter.print(",");
                }
                this.printWriter.print(p.dataValue);
                if (itVars.hasNext()) {
                    this.printWriter.print(",");
                }
                ++contVars;
            }
            allDone = true;
        }
        catch (IOException ioe) {
            log.error("Error reading data", (Throwable)ioe);
        }
        this.printWriter.println();
        return allDone;
    }

    private boolean write(List<String> vars, GridDataset gridDataset, GridAsPointDataset gap, CalendarDate date, LatLonPoint point, Double ensCoord) {
        boolean allDone = false;
        this.printWriter.print(date.toString());
        this.printWriter.print(",");
        int contVars = 0;
        Iterator<String> itVars = vars.iterator();
        try {
            while (itVars.hasNext()) {
                GridDatatype grid = gridDataset.findGridDatatype(itVars.next());
                if (gap.hasTime(grid, date)) {
                    GridAsPointDataset.Point p = gap.readData(grid, date, ensCoord.doubleValue(), -1.0, point.getLatitude(), point.getLongitude());
                    if (contVars == 0) {
                        this.printWriter.print(point.getLatitude());
                        this.printWriter.print(",");
                        this.printWriter.print(point.getLongitude());
                        this.printWriter.print(",");
                        if (ensCoord >= 0.0) {
                            this.printWriter.print(p.ens);
                            this.printWriter.print(",");
                        }
                    }
                    this.printWriter.print(p.dataValue);
                    if (itVars.hasNext()) {
                        this.printWriter.print(",");
                    }
                } else {
                    if (contVars == 0) {
                        this.printWriter.print(point.getLatitude());
                        this.printWriter.print(",");
                        this.printWriter.print(point.getLongitude());
                        this.printWriter.print(",");
                    }
                    this.printWriter.print(gap.getMissingValue(grid));
                    if (itVars.hasNext()) {
                        this.printWriter.print(",");
                    }
                }
                ++contVars;
            }
            allDone = true;
        }
        catch (IOException ioe) {
            log.error("Error reading data", (Throwable)ioe);
        }
        this.printWriter.println();
        return allDone;
    }

    @Override
    public boolean trailer() {
        this.printWriter.flush();
        return true;
    }

    @Override
    public HttpHeaders getResponseHeaders() {
        return this.httpHeaders;
    }

    @Override
    public void setHTTPHeaders(GridDataset gridDataset, String pathInfo, boolean isStream) {
        if (!this.headersSet) {
            this.httpHeaders = new HttpHeaders();
            if (!isStream) {
                this.httpHeaders.set("Content-Location", pathInfo);
                String fileName = NcssRequestUtils.getFileNameForResponse(pathInfo, ".csv");
                this.httpHeaders.set("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            }
            this.httpHeaders.set("Content-Type", ContentType.csv.getContentHeader());
        }
        this.headersSet = true;
    }
}

