/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.radarServer;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetScan;
import thredds.catalog.query.Location;
import thredds.catalog.query.SelectStation;
import thredds.catalog.query.Selector;
import thredds.catalog.query.Station;
import thredds.server.config.TdsContext;
import thredds.server.radarServer.RadarDatasetCollection;
import thredds.servlet.DataRootHandler;
import ucar.unidata.util.StringUtil2;

@Component
public class DatasetRepository {
    private static Logger startupLog = LoggerFactory.getLogger((String)"serverStartup");
    public static InvCatalogImpl cat = null;
    public static URI catURI;
    public static HashMap<String, RadarDatasetCollection> datasetMap;
    public static HashMap<String, String> dataLocation;
    private static final String catName = "/radar/radarCollections.xml";
    private static final String nexradStations = "/radar/RadarNexradStations.xml";
    private static final String terminalStations = "/radar/RadarTerminalStations.xml";
    public static List<Station> nexradList;
    public static List<Station> terminalList;
    public static HashMap<String, Station> nexradMap;
    public static HashMap<String, Station> terminalMap;
    private static boolean init;
    private static Object lock;

    public static void init(TdsContext tdsContext) {
        if (init) {
            return;
        }
        String contentPath = tdsContext.getContentDirectory().getPath();
        InvCatalogFactory factory = InvCatalogFactory.getDefaultFactory((boolean)false);
        cat = DatasetRepository.readCatalog(factory, catName, contentPath + catName);
        if (cat == null) {
            throw new IllegalStateException("Radar DatasetRepository cant open " + contentPath + catName);
        }
        cat.setBaseURI(catURI);
        List parents = cat.getDatasets();
        for (int i = 0; i < parents.size(); ++i) {
            InvDataset top = (InvDataset)parents.get(i);
            List datasets = top.getDatasets();
            for (int j = 0; j < datasets.size(); ++j) {
                InvDatasetScan ds = (InvDatasetScan)datasets.get(j);
                if (ds.getPath() != null) {
                    String locationWithAliasRemoved = DataRootHandler.getInstance().expandAliasForDataRoot(ds.getScanLocation());
                    dataLocation.put(ds.getPath(), locationWithAliasRemoved);
                    startupLog.info("Radar DatasetRepository added path =" + ds.getPath() + " location =" + locationWithAliasRemoved);
                }
                ds.setXlinkHref(ds.getPath() + "/dataset.xml");
            }
        }
        if (nexradList.size() == 0) {
            nexradList = DatasetRepository.readStations(contentPath + nexradStations);
            if (nexradList == null) {
                startupLog.error("Station initialization problem using " + contentPath + nexradStations);
                throw new IllegalStateException("Radar DatasetRepository cant open " + contentPath + nexradStations);
            }
            terminalList = DatasetRepository.readStations(contentPath + terminalStations);
            if (terminalList == null) {
                startupLog.error("Station initialization problem using " + contentPath + terminalStations);
                throw new IllegalStateException("Radar DatasetRepository cant open " + contentPath + terminalStations);
            }
            nexradMap = DatasetRepository.getStationMap(nexradList);
            terminalMap = DatasetRepository.getStationMap(terminalList);
        }
        startupLog.info("DatasetRepository initialization done -  ");
        init = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RadarDatasetCollectionReturn getRadarDatasetCollection(String key, String var) {
        String dmkey = key;
        if (var != null) {
            dmkey = key + var;
        }
        RadarDatasetCollection rdc = datasetMap.get(dmkey);
        boolean reread = false;
        if (rdc != null) {
            reread = rdc.previousDayNowAvailable();
        }
        if (rdc == null || reread) {
            Object object = lock;
            synchronized (object) {
                if (reread) {
                    datasetMap.remove(dmkey);
                    rdc = null;
                } else {
                    rdc = datasetMap.get(dmkey);
                }
                if (rdc != null) {
                    return new RadarDatasetCollectionReturn(rdc);
                }
                String tdir = dataLocation.get(key);
                if (tdir == null) {
                    return new RadarDatasetCollectionReturn("No dataset with key= " + key);
                }
                rdc = new RadarDatasetCollection(tdir, var);
                if (rdc.yyyymmdd.size() == 0) {
                    return new RadarDatasetCollectionReturn("No dataset with yyyymmdd= " + rdc.yyyymmdd);
                }
                if (rdc.hhmm.size() == 0) {
                    return new RadarDatasetCollectionReturn("No dataset with hhmm= " + rdc.hhmm);
                }
                datasetMap.put(dmkey, rdc);
            }
        }
        return new RadarDatasetCollectionReturn(rdc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRadarDatasetCollection(String key, String var) {
        Object sync;
        Object object = sync = new Object();
        synchronized (object) {
            if (var != null) {
                datasetMap.remove(key + var);
            } else {
                datasetMap.remove(key);
            }
        }
    }

    public static InvCatalogImpl getRadarCatalog() {
        return cat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InvCatalogImpl readCatalog(InvCatalogFactory factory, String path, String catalogFullPath) {
        InvCatalogImpl acat;
        try {
            catURI = new URI("file:" + StringUtil2.escape((String)catalogFullPath, (String)"/:-_."));
        }
        catch (URISyntaxException e) {
            startupLog.info("radarServer readCatalog(): URISyntaxException=" + e.getMessage());
            return null;
        }
        startupLog.info("radarServer readCatalog(): full path=" + catalogFullPath + "; path=" + path);
        FileInputStream ios = null;
        try {
            ios = new FileInputStream(catalogFullPath);
            acat = factory.readXML((InputStream)ios, catURI);
        }
        catch (Throwable t) {
            startupLog.info("radarServer readCatalog(): Exception on catalog=" + catalogFullPath + " " + t.getMessage());
            InvCatalogImpl invCatalogImpl = null;
            return invCatalogImpl;
        }
        finally {
            if (ios != null) {
                try {
                    ios.close();
                }
                catch (IOException e) {
                    startupLog.info("radarServer readCatalog(): error closing" + catalogFullPath);
                }
            }
        }
        return acat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Station> readStations(String stnLocation) {
        ArrayList<Station> stationList = new ArrayList<Station>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        SelectStation parent = new SelectStation();
        InputStream is = null;
        try {
            DocumentBuilder parser = factory.newDocumentBuilder();
            is = new FileInputStream(stnLocation);
            Document doc = parser.parse(is);
            NodeList stns = doc.getElementsByTagName("station");
            for (int i = 0; i < stns.getLength(); ++i) {
                NamedNodeMap attr = stns.item(i).getAttributes();
                String name = "";
                String value = "";
                String state = "";
                String country = "";
                for (int j = 0; j < attr.getLength(); ++j) {
                    if (attr.item(j).getNodeName().equals("value")) {
                        value = attr.item(j).getNodeValue();
                        continue;
                    }
                    if (attr.item(j).getNodeName().equals("name")) {
                        name = attr.item(j).getNodeValue();
                        continue;
                    }
                    if (attr.item(j).getNodeName().equals("state")) {
                        state = attr.item(j).getNodeValue();
                        continue;
                    }
                    if (!attr.item(j).getNodeName().equals("country")) continue;
                    country = attr.item(j).getNodeValue();
                }
                NodeList child = stns.item(i).getChildNodes();
                Location location = null;
                for (int j = 0; j < child.getLength(); ++j) {
                    if (!child.item(j).getNodeName().equals("location3D")) continue;
                    NamedNodeMap ca = child.item(j).getAttributes();
                    String latitude = "";
                    String longitude = "";
                    String elevation = "";
                    for (int k = 0; k < ca.getLength(); ++k) {
                        if (ca.item(k).getNodeName().equals("latitude")) {
                            latitude = ca.item(k).getNodeValue();
                            continue;
                        }
                        if (ca.item(k).getNodeName().equals("longitude")) {
                            longitude = ca.item(k).getNodeValue();
                            continue;
                        }
                        if (!ca.item(k).getNodeName().equals("elevation")) continue;
                        elevation = ca.item(k).getNodeValue();
                    }
                    location = new Location(latitude, longitude, elevation, null, null, null);
                }
                Station station = new Station((Selector)parent, name, value, state, country, null);
                station.setLocation(location);
                stationList.add(station);
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
            stationList = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            stationList = null;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            stationList = null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    startupLog.error("radarServer getStations(): error closing" + stnLocation);
                }
            }
        }
        return stationList;
    }

    public static HashMap<String, Station> getStationMap(List<Station> list) {
        HashMap<String, Station> stationMap = new HashMap<String, Station>();
        for (Station station : list) {
            stationMap.put(station.getValue(), station);
        }
        return stationMap;
    }

    static {
        datasetMap = new HashMap();
        dataLocation = new HashMap();
        nexradList = new ArrayList<Station>();
        terminalList = new ArrayList<Station>();
        lock = new Object();
    }

    public static class RadarDatasetCollectionReturn {
        RadarDatasetCollection rdc;
        String err;

        public RadarDatasetCollectionReturn(RadarDatasetCollection rdc) {
            this.rdc = rdc;
        }

        public RadarDatasetCollectionReturn(String err) {
            this.err = err;
        }
    }

    public static enum RadarType {
        nexrad,
        terminal;

    }
}

