/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public class HtmlConfig {
    private String webappName;
    private String webappVersion;
    private String webappVersionBuildDate;
    private String webappContextPath;
    private String webappUrl;
    private String webappDocsUrl;
    private String webappLogoUrl;
    private String webappLogoAlt;
    private String pageCssUrl;
    private String catalogCssUrl;
    private String googleTrackingCode;
    private String folderIconUrl;
    private String folderIconAlt;
    private String datasetIconUrl;
    private String datasetIconAlt;
    private String installName;
    private String installUrl;
    private String installLogoUrl;
    private String installLogoAlt;
    private String hostInstName;
    private String hostInstUrl;
    private String hostInstLogoUrl;
    private String hostInstLogoAlt;
    private boolean useRemoteCatalogService;

    public void init(String webappName, String webappVersion, String webappVersionBuildDate, String webappContextPath) {
        this.webappName = webappName;
        this.webappVersion = webappVersion;
        this.webappVersionBuildDate = webappVersionBuildDate;
        this.webappContextPath = webappContextPath;
    }

    public String getWebappName() {
        return this.webappName;
    }

    public String getWebappVersion() {
        return this.webappVersion;
    }

    public String getWebappVersionBuildDate() {
        return this.webappVersionBuildDate;
    }

    public String getWebappContextPath() {
        return this.webappContextPath;
    }

    public String getWebappUrl() {
        return this.webappUrl;
    }

    public void setWebappUrl(String webappUrl) {
        this.webappUrl = webappUrl;
    }

    public String getWebappDocsUrl() {
        return this.webappDocsUrl;
    }

    public void setWebappDocsUrl(String webappDocsUrl) {
        this.webappDocsUrl = webappDocsUrl;
    }

    public String getWebappLogoUrl() {
        return this.webappLogoUrl;
    }

    public void setWebappLogoUrl(String webappLogoUrl) {
        this.webappLogoUrl = webappLogoUrl;
    }

    public String getWebappLogoAlt() {
        return this.webappLogoAlt;
    }

    public void setWebappLogoAlt(String webappLogoAlt) {
        this.webappLogoAlt = webappLogoAlt;
    }

    public String getPageCssUrl() {
        return this.pageCssUrl;
    }

    public void setPageCssUrl(String pageCssUrl) {
        this.pageCssUrl = pageCssUrl;
    }

    public String getCatalogCssUrl() {
        return this.catalogCssUrl;
    }

    public void setCatalogCssUrl(String catalogCssUrl) {
        this.catalogCssUrl = catalogCssUrl;
    }

    public String getGoogleTrackingCode() {
        return this.googleTrackingCode;
    }

    public void setGoogleTrackingCode(String googleTrackingCode) {
        this.googleTrackingCode = googleTrackingCode;
    }

    public String getFolderIconUrl() {
        return this.folderIconUrl;
    }

    public void setFolderIconUrl(String folderIconUrl) {
        this.folderIconUrl = folderIconUrl;
    }

    public String getFolderIconAlt() {
        return this.folderIconAlt;
    }

    public void setFolderIconAlt(String folderIconAlt) {
        this.folderIconAlt = folderIconAlt;
    }

    public String getDatasetIconUrl() {
        return this.datasetIconUrl;
    }

    public void setDatasetIconUrl(String datasetIconUrl) {
        this.datasetIconUrl = datasetIconUrl;
    }

    public String getDatasetIconAlt() {
        return this.datasetIconAlt;
    }

    public void setDatasetIconAlt(String datasetIconAlt) {
        this.datasetIconAlt = datasetIconAlt;
    }

    public String getInstallName() {
        return this.installName;
    }

    public void setInstallName(String installName) {
        this.installName = installName;
    }

    public String getInstallUrl() {
        return this.installUrl;
    }

    public void setInstallUrl(String installUrl) {
        this.installUrl = installUrl;
    }

    public String getInstallLogoUrl() {
        return this.installLogoUrl;
    }

    public void setInstallLogoUrl(String installLogoUrl) {
        this.installLogoUrl = installLogoUrl;
    }

    public String getInstallLogoAlt() {
        return this.installLogoAlt;
    }

    public void setInstallLogoAlt(String installLogoAlt) {
        this.installLogoAlt = installLogoAlt;
    }

    public String getHostInstName() {
        return this.hostInstName;
    }

    public void setHostInstName(String hostInstName) {
        this.hostInstName = hostInstName;
    }

    public String getHostInstUrl() {
        return this.hostInstUrl;
    }

    public void setHostInstUrl(String hostInstUrl) {
        this.hostInstUrl = hostInstUrl;
    }

    public String getHostInstLogoUrl() {
        return this.hostInstLogoUrl;
    }

    public void setHostInstLogoUrl(String hostInstLogoUrl) {
        this.hostInstLogoUrl = hostInstLogoUrl;
    }

    public String getHostInstLogoAlt() {
        return this.hostInstLogoAlt;
    }

    public void setHostInstLogoAlt(String hostInstLogoAlt) {
        this.hostInstLogoAlt = hostInstLogoAlt;
    }

    public Boolean getUseRemoteCatalogService() {
        return this.useRemoteCatalogService;
    }

    public void setUseRemoteCatalogService(Boolean remoteCatalogService) {
        this.useRemoteCatalogService = remoteCatalogService;
    }

    public String prepareUrlStringForHtml(String url) {
        if (url == null) {
            return null;
        }
        URI uri = null;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Given a bad URL [" + url + "].", e);
        }
        if (uri.isAbsolute()) {
            return uri.toString();
        }
        if (url.startsWith("/")) {
            return url;
        }
        return this.getWebappContextPath() + "/" + url;
    }

    public void addHtmlConfigInfoToModel(Map<String, Object> model) {
        model.put("catalogCssUrl", this.getCatalogCssUrl());
        model.put("standardCssUrl", this.getPageCssUrl());
        model.put("googleTrackingCode", this.getGoogleTrackingCode());
        model.put("datasetIconAlt", this.getDatasetIconAlt());
        model.put("datasetIconUrl", this.getDatasetIconUrl());
        model.put("folderIconAlt", this.getFolderIconAlt());
        model.put("folderIconUrl", this.getFolderIconUrl());
        model.put("hostInstName", this.getHostInstName());
        model.put("hostInstUrl", this.prepareUrlStringForHtml(this.getHostInstUrl()));
        model.put("hostInstLogoUrl", this.prepareUrlStringForHtml(this.getHostInstLogoUrl()));
        model.put("hostInstLogoAlt", this.getHostInstLogoAlt());
        model.put("installationName", this.getInstallName());
        model.put("installationUrl", this.prepareUrlStringForHtml(this.getInstallUrl()));
        model.put("installationLogoUrl", this.prepareUrlStringForHtml(this.getInstallLogoUrl()));
        model.put("installationLogoAlt", this.getInstallLogoAlt());
        model.put("useRemoteCatalogService", this.getUseRemoteCatalogService());
        model.put("webappName", this.getWebappName());
        model.put("webappVersion", this.getWebappVersion());
        model.put("webappVersionBuildDate", this.getWebappVersionBuildDate());
        model.put("webappUrl", this.prepareUrlStringForHtml(this.getWebappUrl()));
        model.put("webappDocsUrl", this.prepareUrlStringForHtml(this.getWebappDocsUrl()));
        model.put("webappLogoUrl", this.prepareUrlStringForHtml(this.getWebappLogoUrl()));
        model.put("webappLogoAlt", this.getWebappLogoAlt());
    }
}

