/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.fileserver;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.LastModified;
import thredds.servlet.DataRootHandler;
import thredds.servlet.DatasetHandler;
import thredds.servlet.ServletUtil;
import thredds.util.TdsPathUtils;

@Controller
@RequestMapping(value={"/fileServer"})
public class FileServerController
implements LastModified {
    protected static Logger log = LoggerFactory.getLogger(FileServerController.class);

    public long getLastModified(HttpServletRequest req) {
        String reqPath = TdsPathUtils.extractPath(req, "fileServer/");
        if (reqPath == null) {
            return -1L;
        }
        File file = this.getFile(reqPath);
        if (file == null) {
            return -1L;
        }
        return file.lastModified();
    }

    @RequestMapping(value={"**"})
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String reqPath = TdsPathUtils.extractPath(req, "fileServer/");
        if (reqPath == null) {
            return;
        }
        if (!DatasetHandler.resourceControlOk(req, res, reqPath)) {
            return;
        }
        File file = this.getFile(reqPath);
        ServletUtil.returnFile(null, req, res, file, null);
    }

    private File getFile(String reqPath) {
        if (reqPath == null) {
            return null;
        }
        File file = DataRootHandler.getInstance().getCrawlableDatasetAsFile(reqPath);
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        return file;
    }
}

